$(document).ready(function() {
    var fechaSinFormato = new Date();
    var fechaActual = fechaSinFormato.getFullYear() + "-" + ("0"+(fechaSinFormato.getMonth()+1)).slice(-2) + "-" + ("0" + fechaSinFormato.getDate()).slice(-2);
    transacciones(fechaActual,fechaActual);
    drawBtn(fechaActual,fechaActual);
    eliminarCarritoNotas();


    /*
    $('#modalFactura').modal({
        onOpenEnd() {
            window.focus();
            window.print();
        },
    }); 
    console.log(shopFacturas);
    */
    datePickerRange();
    resizeDOMHeights();

}); 

//DatePicker version movil
function datepicker(fechaActual) {
    $("#datePicker").html("");
    var maxDay = "";
    maxDay = `<input class="mdl-textfield__input" type="date" max="${fechaActual}" value="${fechaActual}" id="date">`;
    maxDay += `<label class="mdl-textfield__label" for="date">Filtrar por fecha</label>`;
    $("#datePicker").html(maxDay);
}

function anulacionFactura(idVenta,fechaInicio,fechaFin) {
    const { value: motivo } =  Swal.fire({
        title: 'Motivo de la Anulaci&#243;n',
        input: 'text',
        showCancelButton: true,
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Ok',
        confirmButtonColor: '#ff8f00',
        inputPlaceholder: 'Ingresa el motivo de la anulacion',
        footer: '<span style="color:#ff0000">Este campo es obligatorio</span>',
        allowOutsideClick: false,
        inputValidator: (value) => {
            if (!value) {
                return "No puedes enviar el motivo en blanco";
            }
        }
    }).then((result) => {
        if (result.value) {
            var res = JSON.stringify(result.value)
            var motivo = res.replace(/[_\W]+/g, " ");
            //console.log(motivo)
            params = {
                service: 'anulacionFactura',
                dbName: dbName,
                urlFEL: urlFEL,
				tokenFEL: tokenFEL,
                idEmpresas: localStorage.idEmpresas,
                idSucursales: localStorage.idSucursales,
                idUsuarios: localStorage.idUsuarios,
                idVenta: idVenta,
                motivo: motivo
            };

            $("#loader").show();
            $.post(host, params, function(data) {
                console.log(data);
                switch(data.message){
                    case 'success':
                        Swal.fire({
                            icon: 'success',
                            html: 'Documento anulado con &#233;xito',
                            showConfirmButton: false,
                            timer: 1500
                        });
                        transacciones(fechaInicio,fechaFin);
                        break;
                    default:
                        Swal.fire({
                            icon: 'error',
                            title: `Error al anular documento`, 
                            html: data.error,
                            showCloseButton: true,
							confirmButtonText: "Intentar de nuevo",
                        });
                        //alert(data.error); 
                    break;
                }
            }, 'json').done(function() {
                $("#loader").hide();
            });
            
        }
    })
};

function transacciones(fechaInicio,fechaFin) {
    params = {
        service: 'transacciones',
        dbName: dbName,
        idEmpresas: localStorage.idEmpresas,
        idSucursales: localStorage.idSucursales,
        fechaInicio: fechaInicio,
        fechaFin: fechaFin
    };
    $('#dataTable').DataTable().clear().destroy()
    $.post(host, params, function(data) {
        var totalQ = 0;
        var totalNCRE = 0;
        var totalDolares = 0;
        var descuentos = 0;
        $.each(data, function(key, val){
            if (val.anulacion == "0"){
            //total += accounting.unformat(val.valorFactura);
                if (val.tipoTransaccion != "2"){
                    totalQ += accounting.unformat(val.total);
                    totalDolares += accounting.unformat(val.totalDolares);
                    descuentos += accounting.unformat(val.descuento);
                }else{
                    totalNCRE += accounting.unformat(val.total);
                }
            }
        });

        $('#dataTable').DataTable().clear().destroy()
        $('#dataTable').DataTable({
            responsive: true,
            //fixedColumns: true,
            fixedHeader: true,
            lengthChange: false,
            bDestroy: true,
            pageLength: 8,
            columnDefs: [
                { 
                    targets: [0, 1],
                    className: "text-center", 
                    width: 20
                }
            ],
            oLanguage: { "sSearch": "" }, 
            language: {
                lengthMenu: "Mostrar _MENU_ registros por pagina",
                zeroRecords: "No se encontraron resultados en su busqueda",
                searchPlaceholder: "Buscar registros",
                info: "Mostrando registros de _START_ al _END_ de un total de  _TOTAL_ registros.",
                infoEmpty: "No existen registros",
                infoFiltered: "(filtrado de un total de _MAX_ registros)",
                //search: "Buscar:",
                paginate: {
                    first: "Primero",
                    last: "Último",
                    next: "Siguiente",
                    previous: "Anterior"
                },
            },
            data: JSON.parse(JSON.stringify(data)),
            columns: [
            { 
                "title": '<i class="Small material-icons">receipt</i>',
                "data": "Estado",
                "render": function (data, type, row) {
                    if(shopFacturas === true){
                        return `<center><i class="Small material-icons" style="color:#00897b;cursor: pointer;" onclick="reprintHeaderFactura(${row['id']})">receipt</i></center>`;
                    }else{
                        return `<center><i class="Small material-icons" style="color:#00897b;cursor: pointer;" onclick="printer(${row['id']},${row['tipoTransaccion']}, false, 0)">receipt</i></center>`;
                    }
                },
            },
            { 
                "title": '<i class="Small material-icons">cancel</i>',
                "data": "Estado",
                "render": function (data, type, row) {
                    let btnAnulacion;
                    let fechaSinFormato = new Date();
                    let fechaActual = fechaSinFormato.getFullYear() + "-" + ("0"+(fechaSinFormato.getMonth()+1)).slice(-2) + "-" + ("0" + fechaSinFormato.getDate()).slice(-2);

                    let startDate = moment(row['fechaFactura'], 'YYYY-MM-DD');
                    let endDate = moment(fechaActual, 'YYYY-MM-DD');
            
                    let dayDiff = endDate.diff(startDate, 'days');
                    let monthDiff = endDate.diff(startDate, 'months');

                    if(row['Estado'] == 'ACTIVA'){
                        if(dayDiff < 5){
                            btnAnulacion = `<center><i class="Small material-icons" id="anulacion" style="color:#d84315;cursor:pointer" onclick="anulacionFactura(${row['id']},'${fechaInicio}','${fechaFin}')">cancel</i></center>`;
                        }else{
                            btnAnulacion = `<center><i class="Small material-icons" style="color:#d84315;">highlight_off</i></center>`;
                        }
                    }
                    else{
                        btnAnulacion = `<center><i class="Small material-icons" style="color:#d84315;">highlight_off</i></center>`;
                    }

                    return btnAnulacion;  
                },
            },
            { 
                "title": '<i class="Small material-icons">chrome_reader_mode</i>',
                "data": "Estado",
                "render": function (data, type, row) {
                    let btnNota;
                    let fechaSinFormato = new Date();
                    let fechaActual = fechaSinFormato.getFullYear() + "-" + ("0"+(fechaSinFormato.getMonth()+1)).slice(-2) + "-" + ("0" + fechaSinFormato.getDate()).slice(-2);

                    let startDate = moment(row['fechaFactura'], 'YYYY-MM-DD');
                    let endDate = moment(fechaActual, 'YYYY-MM-DD');
            
                    let dayDiff = endDate.diff(startDate, 'days');
                    let monthDiff = endDate.diff(startDate, 'months');
                
                    //console.log(monthDiff," ",dayDiff);
                    //! AGREGAR LA CONDICIONAL EN EL IF PARA LOS DIAS
                    if(row['tipoTransaccion'] == '2' || row['idVentasOrigen'] == '0' || row['tipoTransaccion'] == '0'){
                        btnNota = `<center><i class="Small material-icons" style="color:#757575;cursor: pointer;">chrome_reader_mode</i></center>`;
                    }else{
                        if(monthDiff < 2){
                            btnNota = `<center><i class="Small material-icons" id="notaCredito" style="color:#00897b;cursor: pointer;" onclick="viewNotasCredito(${row['id']},'${row['fechaFactura']}')">chrome_reader_mode</i></center>`;
                        }else{
                           btnNota = `<center><i class="Small material-icons" style="color:#757575;cursor: pointer;">chrome_reader_mode</i></center>`;
                        }
                    }
                    return btnNota; 
                },
            },
            { data: "tipoTransaccionTXT" },
            { data: "Estado" },
            { data: "serie" },
            { data: "correlativo" },
            { data: "fechaConFormato" },
            { data: "nit" },
            { data: "nombre" },
            { 
                "title": "Descuento",
                "data": "descuento",
                "render": function (data, type, row) {
                return accounting.formatNumber(row['descuento'],2);
                },
            },
            { 
                "title": "Total",
                "data": "total",
                "render": function (data, type, row) {

                    if (row['total'] == 0){
                        return "$" + accounting.formatNumber(row['totalDolares'],2);
                    }else{
                        return "Q" + accounting.formatNumber(row['total'],2);
                    }

                },
            },
            ]
        });

        if (localStorage.tipoUsuario == 1 || localStorage.tipoUsuario == 2) {
            $('#dataTable').DataTable().column(1).visible(true);
        }else{
            $('#dataTable').DataTable().column(1).visible(false);
        }
        var summary = `<div>Total Ventas Q: ${accounting.formatNumber(totalQ,2)}</div>`;
        summary += `<div style="font-size:20px; padding-top: 5px;">Total Notas de Cr&eacute;dito: ${accounting.formatNumber(totalNCRE,2)} </div>
        <div style="font-size:20px; padding-top: 5px;"> Total Descuentos: ${accounting.formatNumber(descuentos,2)} </div>`;
        $("#ventas").html(summary);
    }, 'json').done(function(){
        });
}

//* Redireccion a la pantalla de notas de crédito de esa venta seleccionada
function viewNotasCredito(id,fecha){
    //sessionStorage.idAjuste = undefined;
    sessionStorage.idNota = id;
    window.location = "notasCredito.html";
}

//* Dibuja el boton para mandar fechas a la funcion
function drawBtn(fechaInicio,fechaFin){
    $("#drawBtn").html("");
    let component = "";

    //Selecciona el estilo de boton de exportar reporte segun version utilizada
    if (localStorage.isMobile == "true"){
        component += `<form>
            <button type='button' id="export" class="mdl-cell mdl-cell--12-col mdl-cell--6-col-phone mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect shapedbox" 
            style="background-color: #ff8f00;height:45px;" onclick="getDatosReporte('${fechaInicio}','${fechaFin}')">Exportar Reporte</button>
        </form>`
    }else{
        component += `<form>
            <div id="export" class="btn-large waves-effect waves-light" style="background-color: #ff8f00;" onclick="getDatosReporte('${fechaInicio}','${fechaFin}')">Exportar Reporte</div>
        </form>`;
    }
    
    $("#drawBtn").html(component);
}

//* Funcion que obtiene los datos de la consulta
function getDatosReporte(fechaInicio,fechaFin){
    params = {
        service: 'getDatosReporte',
        dbName: dbName,
        fechaInicio: fechaInicio,
        fechaFin: fechaFin
    };
    $.post(host, params, function(data) {
        exportarReporte(data);
    }, 'json');
}

//* Funcion para mandar el archivo por correo
function exportarReporte(datos){
console.log(datos);
    params = {
        service: 'reporteTransac',
        dbName: dbName,
        datos: datos,
        idEmpresas: localStorage.idEmpresas
    };
    $.post(host, params, function(data) {
    }, 'json').done(function(){});
    
    Swal.fire({
        icon: 'success',
        html: 'Reporte Enviado con &#233;xito',
        showConfirmButton: false,
        timer: 1500
    });
}

function datePickerRange(){
    $('input[name="daterange"]').daterangepicker({
        startdate: new Date(), //Fecha inicial default
        endDate: new Date(), //Fecha final default
        maxDate: new Date(),
      }, function(start, end, label) {
        //console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
        //console.log(start.format('YYYY-MM-DD'))
        let inicio = start.format('YYYY-MM-DD');
        let fin = end.format('YYYY-MM-DD');
        drawBtn(inicio,fin);
        transacciones(inicio,fin);
      });
}

function reprintHeaderFactura(id){
    console.log("here");
	$("#headers1").empty();
	$("#facturaFoot1").empty();
	params = {
		service: "reprintFactHeader",
		dbName: dbName,
        id: id
	};
	$.post(host, params, function (data) {
		let headers = ``;
        let headerTable = ``;
		let watermark = ``;
		let summary = ``;
		let foot = ``;
		$.each(data, function (key, val) {
			if(val.autorizacionFEL === null){
				autorizacion = "N/A";
			}else{
				autorizacion = val.autorizacionFEL;
			}
            if(val.fechaEmisionFEL === null){
				fechaHora = "N/A";
			}else{
				fechaHora = val.fechaEmisionFEL;
			}
			headers += `
			<div style="display: grid;grid-template-columns: auto auto auto auto;">
				<div style="grid-column: 1 / span 3">
					<img src="assets/images/corfila.jpg" style="width: 105px; height: 100px;vertical-align: unset !important;" />
					<div style="display: inline-block;font-size: smaller;text-align: center;">
					<b style="font-size: x-large;">CORFILA S.A.</b></br>
					Corporaci&oacute;n Filadelfia, S.A.</br>
					F&aacute;brica de Bolsas y Productos Pl&aacute;sticos </br>
					17 avenida 5-46, Zona 1. Guatemala, Ciudad </br>
					Tels.: (502) 2253-3823, 253-8249/50, 2238-4901 </br>
					E-mail: ventascorfila01@gmail.com / ventas@corfila-gt.com </br>
					</div>
				</div>
				<div style="grid-column: 4;padding-top: 25px">
					<b>FACTURA</b> </br>
					<b>NIT:</b> ${val.nitEmpresa} </br>
					<b>SERIE:</b> ${val.serie} </br>
					<b>DTE:</b> ${val.correlativo}
				</div>
				<div style="border: 1px solid;border-top-left-radius:20px;padding-left: 15px !important;padding: unset; grid-column:1 / span 2">
					<b>ORDEN DE COMPRA:</b> ${val.ordenCompra}
				</div>
				<div style="border: 1px solid;padding-left: 15px !important;padding: unset;grid-column:3"> 
					<b>Venta:</b> ${val.formaPago}
				</div>
				<div style="border: 1px solid;border-top-right-radius:20px;padding-left: 15px !important;padding: unset;grid-column: 4;">
					<b>GUATEMALA </br> FECHA:</b> ${val.fechaFactura}
				</div>
				<div style="border: 1px solid;border-right:none;grid-column: 1 / span 3;padding-left: 15px !important;padding: unset;"><b>NOMBRE:</b> ${val.nombre} <br/>
					<b>DIRECCI&Oacute;N:</b> ${val.direccion}
				</div>
				<div style="border: 1px solid;border-left:none;padding-left: 15px !important;padding: unset;grid-column: 4 ;">
					<b>NIT:</b> ${val.nit}
				</div>
				<div style="border: 1px solid;border-bottom-left-radius:20px;padding-left: 15px !important;padding: unset;grid-column: 1 / span 2;">
					<b>TRANSPORTE:</b> ${val.transporte}
				</div>
				<div style="border: 1px solid;padding-left: 15px !important;padding: unset;grid-column:3">
					<b>VENDEDOR:</b> ${val.userName}
				</div>
				<div style="border: 1px solid;border-bottom-right-radius:20px;padding-left: 15px !important;padding: unset;grid-column: 4;">
					<b>C&Oacute;DIGO:</b> ${val.codigo}
				</div>
			</div>	
			`;
            watermark += `<img src="assets/images/corfila.jpg" style="height: 30%;display: block;margin-left: auto;margin-right: auto;width: 30%;margin-top: 220px;"/>`;
            headerTable += `
            <tr>
                <th style="padding-left: 15px;">CANTIDAD</th>
                <th style="padding-left: 15px;">C&Oacute;DIGO</th>
                <th style="padding-left: 15px;">D E S C R I P C I &Oacute; N</th>
                <th style="padding-left: 15px;">P. UNITARIO</th>
                <th style="border-top-right-radius: 20px;padding-left: 15px;">IMPORTE</th>
            </tr>
            `;
			summary += `<tr style="">
			<td colspan="3" style="padding-left: 15px;font-size: 8px;text-align: justify;border-top-style: solid;border-width: thin;">
			<b>EMITIR CHEQUE A NOMBRE DE LA EMPRESA CORFILA, S.A.</b></br>
			EN LAS CONDICIONES ESTIPULADAS EN ESTE TITULO.</br>
			A:</br>
			SE SERVIRAN USTEDES PAGAR POR ESTA UNICA FACTURA CAMBIARIA GIRADA LIBRE DE PROTESTO A LA ORDEN O ENDOSO DE </br>
			<b> CORFILA, S.A.</b> VALOR TOTAL POR EL QUE SE ESTA EXTENDIDA O POR EL ULTIMO SALDO INSOLUTO QUE APAREZCA, 
			VALOR RECIBIDO QUE ASENTARAN USTEDES A CUENTA, SEGUN NUESTRO AVISO. LAS MERCADERIAS CONSIGNADAS EN ESTA FACTURA, 
			SE RECIBEN DE CONFORMIDAD Y CONDICIONES OPTIMAS.</br>
			EL VALOR DE ESTA FACTURA DEBERA SER CANCELADO DENTRO DE LOS 30 DIAS FECHA DE FACTURACION. CASO CONTRARIO, 
			SE LE CARGARA 2% DE INTERES MENSUAL. <b>SI SU PAGO ES CON CHEQUE FAVOR EMITIRLO A NOMBRE DE CORFILA, S.A.</br>
			NOTA:</b> POR CADA CHEQUE RECHAZADO SE COBRARA LA CANTIDAD DE CIEN QUETZALES.
			</td>
			<td style="text-align: center;font-size: large;border-top-style: solid;border-left-style: solid;border-width: thin;"><b>Total Q</b></td>
			<td style="text-align: center;padding-right: 15px;font-size: large;border-top-style: solid;border-left-style: solid;border-width: thin;"><b>${accounting.formatNumber(val.total,2)}</b></td>
			</tr>
			<tr >
				<td colspan="5" style="padding-left: 15px;border-top-style: solid;border-width: thin;"><b>TOTAL EN LETRAS: </b>${val.totalEnLetras}</td>
			</tr>
			`;
			foot += `
			<div style="text-align:end;margin-right: 10px;font-size: smaller;"><b>SUJETO A PAGOS TRIMESTRALES, NO RETENER</b></br><b>AUTORIZACION: </b>${autorizacion}</br><b>FECHA Y HORA: </b>${fechaHora}</div>
			<div style="text-align: center;margin-top: 20px;">____________________________</div>
			<div style="text-align: center;font-size: x-small;">ACEPTADO LIBRE DE PROTESTO</div>
			`
		});
        //console.log(headers);
		$("#headers1").html(headers);
        $("#watermark").html(watermark);
        $("#bodyTable1 thead").html(headerTable);
		$("#bodyTable1 tfoot").html(summary);
		$("#facturaFoot1").html(foot);
	}, "json").done(function(){
		reprintDetallesFactura(id);
	});
}

function reprintDetallesFactura(id){
	$("#bodyTable1 tbody").empty();
	params = {
		service: "reprintFactDetail",
		dbName: dbName,
        id: id
	};
	$.post(host, params, function (data) {
		let table = ``;
		var total = 0;
		
		$.each(data, function (key, val) {
			total += accounting.unformat(val.total);
			table += `

				<tr>
					<td style="padding-left: 15px">${val.cantidad}</td>
					<td style="padding-left: 15px">${val.sku}</td>
					<td style="padding-left: 15px">${val.descLarga}</td>
					<td style="padding-left: 15px">${val.precio}</td>
					<td style="padding-left: 15px">${val.total}</td>
				</tr>
			`;
		});
		$("#bodyTable1 tbody").html(table);		
	}, "json").done(function(){    
        //$("#modalFactura").modal("open");
        window.print();
	});
}

function cerrarModalF() {
	$("#modalFactura").modal("close");
}

