$(document).ready(function () {
    var fechaSinFormato = new Date();
    var fechaActual = fechaSinFormato.getFullYear() + "-" + ("0"+(fechaSinFormato.getMonth()+1)).slice(-2) + "-" + ("0" + fechaSinFormato.getDate()).slice(-2);
    $("#dateResumen").val(fechaActual);

    //Inicializacion para version movil
    if (localStorage.isMobile == "true"){  
        datepicker(fechaActual);
        $("#dateResumen").change(function(){
            $("#dateResumen").val();
        });
        
    }

    //Obtener datos del select 
    getCajerosOpcional();
    getVendedoresOpcional();
    resizeDOMHeights();

});

//Regula que solo del dia actual para atras el usuario pueda seleccionar una fecha en el calendario {movil}
function datepicker(fechaActual) {
    $("#datePicker").html("");
    var maxDay = "";
    maxDay = `<input class="mdl-textfield__input" type="date" max="${fechaActual}" value="${fechaActual}" id="dateResumen">`;
    $("#datePicker").html(maxDay);
}


$('.date').datepicker({
    autoClose: true, 
    maxDate: new Date(),
    yearRange: 1,
    defaultDate: new Date(),
    setDefaultDate: true,
    i18n: {
        weekdaysShort: ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab'],
        months: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo',
        'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 
        'Noviembre', 'Diciembre'],
        monthsShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May',
       'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 
       'Nov', 'Dic'],
        weekdays: ['Domingo','Lunes', 'Martes', 'Miercoles', 'Jueves', 'Viernes', 'Sabado'],
        weekdaysAbbrev: ['D','L', 'M', 'M', 'J', 'V', 'S'],
        cancel: 'Cancelar',
    },
    onSelect: function(fechaPicker) { 
    var fechaBusqueda = fechaPicker.getFullYear() + "-" + ("0"+(fechaPicker.getMonth()+1)).slice(-2) + "-" + ("0" + fechaPicker.getDate()).slice(-2);
    $("#dateResumen").val(fechaBusqueda);
    //console.log($("#dateResumen").val());
    }   
});

function getResumen(){
    if ($("#tipoDeCambio").val() == 0.00 || $("#tipoDeCambio").val() <= 0 || $("#tipoDeCambio").val() == "" || $("#tipoDeCambio").val() == undefined ){
        Swal.fire({
            icon: "warning",
            text: "Debe ingresar un tipo de cambio.",
            showCloseButton: true,
            confirmButtonText: "Intentar de nuevo",
        });
    }else{

        if(localStorage.isMobile == "false"){
            $("#selectVendedor").val('0');
        }

        console.log("cajero: " + $("#selectCajero").val());
        console.log("vendedor: " + $("#selectVendedor").val());
        console.log("tipo de cambio: " + $("#tipoDeCambio").val());
        console.log("fecha:" + $("#dateResumen").val());

        var tipoCambio = $("#tipoDeCambio").val();
        params = {
            service: "getResumen",
            dbName: dbName,
            idEmpresas: localStorage.idEmpresas,
            idSucursales: localStorage.idSucursales,
            fecha: $("#dateResumen").val(),
            cajero: $("#selectCajero").val(),
            vendedor: $("#selectVendedor").val(),
        };
        $.post(host, params, function (data) {

            var dolarTC = 0;
            var granTotal = 0;
            var ticketProm = 0;
            var vendedorSelected = $("#selectVendedor option:selected").text();
            var cajeroSelected = $("#selectCajero option:selected").text();

            let content = `<div class="mdl-cell mdl-cell--12-col mdl-cell--12-col-phone" style="font-size:15px;text-align:center;font-weight:bold;">
            <div id="headerResumen">
            <h4 style="font-weight:bold;margin-top: 0px;margin-bottom: 5px;padding-top:0px;">Detalle de Corte</h4>
            <p>Cajero: ${cajeroSelected}`;

            if(localStorage.isMobile == "true"){
                content += `<br />Vendedor: ${vendedorSelected}</p>
                </div></div>`;
            }else{
                content += `</p></div></div>`;
            }

            $.each(data, function (key, val) {

                // tema de solo elegir cajero o vendedor y funcion de validacion
                    dolarTC = accounting.unformat(val.totalDolar * tipoCambio);
                    
                    let totalEfectivo = parseFloat(val.totalEfectivo);
                    let totalTarjeta = parseFloat(val.totalTarjeta);
                    
                    granTotal = (totalEfectivo + dolarTC + totalTarjeta);
                    ticketProm =  (granTotal / val.cantidadProductos);

                    content += `<div class="mdl-cell mdl-cell--12-col mdl-cell--12-col-phone" style="font-size:25px !important;text-align:center;font-weight:bold;">
                    <ul id="resumenLista" class='mdl-list'>
                        <li class="mdl-list__item no-padding">
                            <div class="mdl-cell mdl-cell--8-col mdl-cell--2-col-phone" style="text-align:left">
                                Efectivo 
                            </div>
                            <div class="mdl-cell mdl-cell--4-col mdl-cell--2-col-phone" style="text-align:right">
                                Q ${val.totalEfectivo}
                            </div>
                        </li>
                        <li class="mdl-list__item no-padding">
                            <div class="mdl-cell mdl-cell--8-col mdl-cell--2-col-phone" style="text-align:left">
                                Dolares
                            </div>
                            <div class="mdl-cell mdl-cell--4-col mdl-cell--2-col-phone" style="text-align:right">
                                $ ${val.totalDolar}
                            </div>
                        </li>
                        <li class="mdl-list__item no-padding">
                            <div class="mdl-cell mdl-cell--8-col mdl-cell--2-col-phone" style="text-align:left">
                                Dolares x T.C. 
                            </div>    
                            <div class="mdl-cell mdl-cell--4-col mdl-cell--2-col-phone" style="text-align:right">
                                Q ${accounting.formatNumber((dolarTC),2)}
                            </div>         
                        </li>
                        <li class="mdl-list__item no-padding">
                            <div class="mdl-cell mdl-cell--8-col mdl-cell--2-col-phone" style="text-align:left">
                                Tarjeta 
                            </div>    
                            <div class="mdl-cell mdl-cell--4-col mdl-cell--2-col-phone" style="text-align:right">
                                Q ${val.totalTarjeta}
                            </div>         
                        </li>
                        <li class="mdl-list__item no-padding">
                            <div class="mdl-cell mdl-cell--8-col mdl-cell--2-col-phone" style="text-align:left">
                                Productos Vendidos 
                            </div>    
                            <div class="mdl-cell mdl-cell--4-col mdl-cell--2-col-phone" style="text-align:right">
                                ${val.cantidadProductos}
                            </div>         
                        </li>
                        <li class="mdl-list__item no-padding">
                            <div class="mdl-cell mdl-cell--8-col mdl-cell--2-col-phone" style="text-align:left">
                                Transacciones 
                            </div>    
                            <div class="mdl-cell mdl-cell--4-col mdl-cell--2-col-phone" style="text-align:right">
                                ${val.totalTransacciones}
                            </div>         
                        </li>
                        <li class="mdl-list__item mdl-menu__item--full-bleed-divider no-padding">
                            <div class="mdl-cell mdl-cell--8-col mdl-cell--2-col-phone" style="text-align:left">
                                Ticket Promedio
                            </div>    
                            <div class="mdl-cell mdl-cell--4-col mdl-cell--2-col-phone" style="text-align:right">
                               Q ${accounting.formatNumber((ticketProm),2)}
                            </div>         
                        </li>
                        <li class="mdl-list__item no-padding">
                            <div class="mdl-cell mdl-cell--8-col mdl-cell--2-col-phone" style="text-align:left">
                                Gran Total 
                            </div>    
                            <div class="mdl-cell mdl-cell--4-col mdl-cell--2-col-phone" style="text-align:right">
                                Q ${accounting.formatNumber((granTotal),2)}
                            </div>         
                        </li>
                    </ul>
                    </div>
                    `;
            });    

            $("#resumenTable").html(content);
            
            if(localStorage.isMobile == "false"){
                $("#main").animate({ scrollTop: $('#main').height() }, 1000);    
                $('.mdl-list__item').addClass('listDesk');
                $("#headerResumen").css('font-size: xx-large')
            }
            else{
                $("main").animate({ scrollTop: $('main').height() }, 1000);
            }
        }, "json",);
    }
}

function printResumen(){
    if ($("#tipoDeCambio").val() == 0.00 || $("#tipoDeCambio").val() <= 0 || $("#tipoDeCambio").val() == "" || $("#tipoDeCambio").val() == undefined ){
        Swal.fire({
            icon: "warning",
            text: "Debe ingresar un tipo de cambio.",
            showCloseButton: true,
            confirmButtonText: "Intentar de nuevo",
        });
    }else{

        console.log("cajero: " + $("#selectCajero").val());
        console.log("vendedor: " + $("#selectVendedor").val());

        var tipoCambio = $("#tipoDeCambio").val();
        params = {
            service: "getResumen",
            dbName: dbName,
            idEmpresas: localStorage.idEmpresas,
            idSucursales: localStorage.idSucursales,
            fecha: $("#dateResumen").val(),
            cajero: $("#selectCajero").val(),
            vendedor: $("#selectVendedor").val(),
        };
        $.post(host, params, function (data) {

            var dolarTC = 0;
            var granTotal = 0;
            var ticketProm = 0;
            var vendedorSelected = $("#selectVendedor option:selected").text();
            var cajeroSelected = $("#selectCajero option:selected").text();
            var fecha = $("#dateResumen").val();

            $.each(data, function (key, val) {

                // tema de solo elegir cajero o vendedor y funcion de validacion
                    dolarTC = accounting.unformat(val.totalDolar * tipoCambio);
                    
                    let totalEfectivo = parseFloat(val.totalEfectivo);
                    let totalTarjeta = parseFloat(val.totalTarjeta);
                    
                    granTotal = (totalEfectivo + dolarTC + totalTarjeta);
                    ticketProm =  (granTotal / val.cantidadProductos);

                    sunmiInnerPrinter.printerInit()
                    .then(() => {
                        return sunmiInnerPrinter.setAlignment(1);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printTextWithFont(`Detalle de Corte\n`, "", fontL);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printTextWithFont(`Fecha : ${fecha}\n`, "", fontS);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printTextWithFont(`Cajero : ${cajeroSelected}\n`, "", fontS);
                    })
                    .then(() => {
                        if(vendedorSelected == '' || vendedorSelected === undefined){
                            return sunmiInnerPrinter.setAlignment(1);
                        }
                        else{
                            return sunmiInnerPrinter.printTextWithFont(`Vendedor : ${vendedorSelected}\n`, "", fontS);
                        }
                        
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printTextWithFont(`Tipo de Cambio : ${tipoCambio}\n\n`, "", fontS);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printColumnsText(['Efectivo', `Q${val.totalEfectivo}`], [col2Y, col2Z], [0, 2]);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printColumnsText(['Dolares', `$${val.totalDolar}`], [col2Y, col2Z], [0, 2]);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printColumnsText(['Dolares x T.C.', `Q${accounting.formatNumber((dolarTC),2)}`], [col2Y, col2Z], [0, 2]);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printColumnsText(['Tarjeta', `Q${val.totalTarjeta}`], [col2Y, col2Z], [0, 2]);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printColumnsText(['Productos Vendidos', `${val.cantidadProductos}`], [col2Y, col2Z], [0, 2]);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printColumnsText(['Transacciones', `${val.totalTransacciones}`], [col2Y, col2Z], [0, 2]);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printColumnsText(['Ticket Promedio', `Q${accounting.formatNumber((ticketProm),2)}`], [col2Y, col2Z], [0, 2]);
                    })
                    .then(()=>{
                        return sunmiInnerPrinter.setAlignment(1);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printTextWithFont(`${prntlinea}\n`,"",fontL);
                    })
                    .then(()=>{
                        return sunmiInnerPrinter.setAlignment(0);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printColumnsText(['Gran Total', `Q${accounting.formatNumber((granTotal),2)}`], [col2Y, col2Z], [0, 2]);
                    })
                    .then(() => {
                        return sunmiInnerPrinter.printTextWithFont(`\n\n\n\n`,"",fontL);
                    })
                    
            });    

        }, "json",);
    }
}

function getVendedoresOpcional(){
	$("#loader").show();

	params = {
		service: "getVendedores",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};
	$.post(host, params, function (data) {
		let vendedores = "<option value='0'>Todos</option>";
		$.each(data, function (key, val) {
			vendedores += `<option value="${val.id}">${val.userName}</option>`;
		});
		$("#selectVendedor").append(vendedores);
		//$("#selectVendedor").val($("#vendedor").val());
		//$('select').formSelect();
	}, "json").done(function(){
		$("#loader").hide();
	});

}

function getCajerosOpcional(){
	params = {
		service: "getCajeros",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};
	$.post(host, params, function (data) {
		let cajeros = "<option value='0'>Todos</option>";
		$.each(data, function (key, val) {
			cajeros += `<option value="${val.id}">${val.userName}</option>`;
		});
		$("#selectCajero").html(cajeros);
        if(localStorage.isMobile == "false"){
            $('select').formSelect();
        }
	}, "json",);
}