$(document).ready(function () {
    getVendedores();
	getTransportistas();
    
	getProductoSelect();
	getCarrito();
	getTotalesCarrito();
	getDocumentoFacturacion();
	//Inicializacion formatos para imprimir
	getHeaderFactura();
	getHeaderEnvio();
	getHeaderEnvioRecibo();
});

function delay(callback, ms) {
    var timer = 0;
    return function() {
      var context = this, args = arguments;
      clearTimeout(timer);
      timer = setTimeout(function () {
        callback.apply(context, args);
      }, ms || 0);
    };
}

//Agrega el producto seleccionado al carrito
$("#selectProductos").on("change", function () {
	var idProducto = $('#selectProductos').val();
	getDatosProducto(idProducto);	
});

// Agrega un producto al carrito 
function agregarProductoCarrito(
	idProductos,
	existencia,
	idTipoProductos,
	producto,
	cantidad,
	precioPublico, 
	arrGlobal,
	precioDolar,
	agrupar
) {
	if(precioDolar == undefined){ //Para cuando no se manejan precios en dolares
		precioDolar = '0.00';
	}
	params = {
		service: "agregarProductoVenta",
		idProductos: idProductos,
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales,
		idUsuarios: localStorage.idUsuarios,
		cantidad: cantidad,
		precioPublico: precioPublico,
		precioDolar: precioDolar,
		agrupar: agrupar
	};
	$("#loader").show();
	if (idTipoProductos === 1) {
		if (accounting.unformat(existencia) > 0) {
			$.post(host,params,function (data) {
				$.each(data, function (key, val) {
						switch (val.message) {
							case "success":
								getCarrito();
								getTotalesCarrito();
								break;
							case "sin_existencia":
								errorMsg = `No hay existencias de componentes del producto: ${producto} \n`;
								errorMsg += "Producto: " + val.producto + "\n";
								errorMsg +=
									"Exitencia: " + val.existencia + "\n";
								errorMsg +=
									"Cantidad solicitada: " +
									val.cantidad +
									"\n";
								Swal.fire({
									title: `${producto}`,
									text: `No hay existencias de los componentes`,
									icon: "warning",
									confirmButtonColor: "#3085d6",
									confirmButtonText: "Ok",
								}).then((result) => {});
								break;
							default:
								alert(`Error PROD ${val.error}`);
								break;
						}
					});
				},
				"json",
			).done(function () {
				$("#loader").hide();
			});
		}
	} else {
		$.post(host, params, function (data) {
				$.each(data, function (key, val) {
					switch (val.message) {
						case "success":
							getCarrito();
							getTotalesCarrito();
							break;
						case "sin_existencia":
							errorMsg = `No hay existencias de componentes del producto: ${producto} \n`;
							errorMsg += "Producto: " + val.producto + "\n";
							errorMsg += "Exitencia: " + val.existencia + "\n";
							errorMsg +=
								"Cantidad solicitada: " + val.cantidad + "\n";
							Swal.fire({
								title: `${producto}`,
								text: `No hay existencias de los componentes`,
								icon: "warning",
								confirmButtonColor: "#3085d6",
								confirmButtonText: "Ok",
							}).then((result) => {});
							break;
						default:
							alert(`Error ${val.error}`);
							break;
					}
				});
			},
			"json",
		).done(function () {
			$("#loader").hide();
		});
	}
}

//Regresa valor de Nombre y Domicilio al introducir NIT
$("#nit").on("keyup", function() {
    validarNIT();
});

//Obtiene los vendedores para mostrarlos en select
function getVendedores(){
	params = {
		service: "getVendedores",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};
	$.post(host, params, function (data) {
		let vendedores = "<option value=''>Seleccione un vendedor...</option>";
		$.each(data, function (key, val) {
			vendedores += `<option value="${val.id}"> ${val.codigoUsuario} - ${val.userName}</option>`;
		});
		$("#selectVendedor1").append(vendedores);
		//$('select').formSelect();
	}, "json").done(function(){
		$("#loader").hide();
	});
}

function getTransportistas(){
	params = {
		service: "getTransportistas",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};
	$.post(host, params, function (data) {
		let pilotos = "<option value=''>Seleccione un transportista...</option>";
		$.each(data, function (key, val) {
			pilotos += `<option value="${val.userName}"> ${val.codigoUsuario} - ${val.userName}</option>`;
		});
		$("#selectTransportista").append(pilotos);
		//$('select').formSelect();
	}, "json").done(function(){
		$("#loader").hide();
	});
}

//Obtiene los productos para mostrarlos en select2
function getProductoSelect(){
	params = {
		service: "getProductos",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};
	$.post(host, params, function (data) {
		
		let productos = "<option></option>";
		$.each(data, function (key, val) {
			productos += `<option value="${val.id}">${val.sku} - ${val.descLarga}</option>`;
		});
		$("#selectProductos").html(productos);

		$('.select2').select2({
			placeholder: "Productos...",
		});
	}, "json",);
}

function formasPago(){

	Swal.fire({
		title: `Seleccione la Forma de Pago`,   
		html: `<div class="row"><div class= "col s6" style="padding-top: 20px;"><b>Efectivo:</b></div>
		<div  class="col s6">
			<input class="formasPago" id="efectivoPago" placeholder="Cantidad en Efectivo" data-type="1" data-emisor="0" required type="number"/>
		</div>
		<div class= "col s6" style="padding-top: 20px;"><b>Cheques:</b></div>
		<div  class="col s6">
			<input class="formasPago" id="chequesPago" placeholder="Cantidad en Cheques" data-type="3" data-emisor="0" required type="number"/>
		</div>
		<div class= "col s6" style="padding-top: 20px;"><b>Deposito:</b></div>
		<div  class="col s6">
			<input class="formasPago" id="depositoPago" placeholder="Cantidad en Deposito" data-type="8" data-emisor="0" required type="number"/>
		</div>
		<div class= "col s6" style="padding-top: 20px;"><b>Credito:</b></div>
		<div  class="col s6">
			<input class="formasPago" id="creditoPago" placeholder="Cantidad en Credito" data-type="4" data-emisor="0" required type="number"/>
		</div>
		<div class= "col s6" style="padding-top: 20px;"><b>Total Restante:</b></div>
		<div class="col s6">
			<input id="totalResto" type="number" readonly/>
		</div>
		</div>`,
		showConfirmButton: true,
		showCancelButton: true,
		confirmButtonColor: '#ff8f00',
		cancelButtonText: "Cancelar",
		confirmButtonText: "FACTURAR",
		customClass: {
			container: 'my-swal'
		}
	}).then((result) => {
		if($("#totalResto").val() == 0){
			finalizarFactura();
		}else{
			Swal.fire({
				icon: "warning",
				text: "Debe ingresar montos validos.",
				showCloseButton: true,
				confirmButtonText: "Intentar de nuevo",
				confirmButtonColor: "#3085d6",
			}).then((result) => {});
		}
	});

	$("#totalResto").val(accounting.formatNumber($("#total").val(), 2)); 

	$("#efectivoPago").change(function() {
		let totalResto = $("#totalResto").val(); 

		/*
		$("#efectivoPago").each(function() {
			var thisVal = parseFloat($(this).val());
			thisVal = (isNaN(thisVal))? 0: thisVal;
			totalResto = totalResto - thisVal;
		});
		*/	
		var valor = 0;
		$(".formasPago").each(function (index) {
			valor += accounting.unformat($(this).val());
			totalResto = $("#total").val() - valor;
		});
		$("#totalResto").val(accounting.formatNumber(totalResto, 2));

	});

	$("#chequesPago").change(function() {
		let totalResto = $("#totalResto").val(); 

		/*
		$("#chequesPago").each(function() {
			var thisVal = parseFloat($(this).val());
			thisVal = (isNaN(thisVal))? 0: thisVal;
			totalResto = totalResto - thisVal;
		});
		$("#totalResto").val(accounting.formatNumber(totalResto, 2));
		*/

		var valor = 0;
		$(".formasPago").each(function (index) {
			valor += accounting.unformat($(this).val());
			totalResto = $("#total").val() - valor;
		});
		$("#totalResto").val(accounting.formatNumber(totalResto, 2));
	});

	$("#depositoPago").change(function() {
		let totalResto = $("#totalResto").val(); 
		/*
		$("#depositoPago").each(function() {
			var thisVal = parseFloat($(this).val());
			thisVal = (isNaN(thisVal))? 0: thisVal;
			totalResto = totalResto - thisVal;
		});
		$("#totalResto").val(accounting.formatNumber(totalResto, 2));
		*/

		var valor = 0;
		$(".formasPago").each(function (index) {
			valor += accounting.unformat($(this).val());
			totalResto = $("#total").val() - valor;
		});
		$("#totalResto").val(accounting.formatNumber(totalResto, 2));
	});

	$("#creditoPago").change(function() {
		let totalResto = $("#totalResto").val(); 
		/*
		$("#creditoPago").each(function() {
			var thisVal = parseFloat($(this).val());
			thisVal = (isNaN(thisVal))? 0: thisVal;
			totalResto = totalResto - thisVal;
		});
		$("#totalResto").val(accounting.formatNumber(totalResto, 2));
		*/
		var valor = 0;
		$(".formasPago").each(function (index) {
			valor += accounting.unformat($(this).val());
			totalResto = $("#total").val() - valor;
		});
		$("#totalResto").val(accounting.formatNumber(totalResto, 2));
	});

}

function verificarCampos(){	

	var nombre = !$("#nombre").val() ? "Consumidor Final" : $("#nombre").val();
	var direccion = !$("#direccion").val() ? "Consumidor Final" : $("#direccion").val();
	var nit = !$("#nit").val() ? "CF" : $("#nit").val();

	var direccionEnvio = $("#direccionEnvio").val();
	var telefono = $("#telefono").val();
	var transporte = $("#transporte").val();
	var vendedor = $("#selectVendedor1").val();
	var piloto = $("#selectTransportista").val();

	//Pre-asigna valores si es que no se va a generar un recibo de envio
	if ($("input[name=generarEnvio]:checked").val() == undefined){
		direccionEnvio = "NA";
		transporte = "NA";
		telefono = "0";
		piloto = "NA"
   }

	var errorMsg = "<b>Campos obligatorios pendientes: </b></br>";
	var flag = true;

	if ($("input[name=envioEspecial]:checked").val() == "on"){
		if ($("input[name=generarEnvio]:checked").val() == undefined){
			flag = false;
			errorMsg += "Marque la casilla de Generacion de Envio</br>";
		}
	}

	if (!nit) {
		flag = false;
		errorMsg += "Ingrese el NIT </br>";
	}
	if (!transporte) {
		flag = false;
		errorMsg += "Ingrese el transporte </br>";
	}
	if (!telefono) {
		flag = false;
		errorMsg += "Ingrese el telefono </br>";
	}	
	if (!vendedor) {
		flag = false;
		errorMsg += "Seleccione un vendedor </br>";
	}
	if (!piloto) {
		flag = false;
		errorMsg += "Seleccione un transportista </br>";
	}
	if (!nombre || !direccion) {
		flag = false;
		errorMsg += "Ingrese un NIT valido </br>";
	}
	if (flag === false) {
		Swal.fire({
			html: errorMsg,
			icon: "warning",
			confirmButtonColor: "#3085d6",
			confirmButtonText: "Ok",
		}).then((result) => {});
		return false;
	}else{
		validacionCarritoFactura();
	}
}

function validacionCarritoFactura(){
	if ($("#totalItems").val() === undefined || $("#totalItems").val() === '0'  ) {
		Swal.fire({
			html: 'No tiene articulos en esta venta',
			timer: 2000,
			timerProgressBar: true,
			confirmButtonColor: "#ff8f00",
			confirmButtonText: "Aceptar",
		}).then((result) => {});
	} else {
		formasPago();
	}
}

function finalizarFactura(){
	//Guardar los datos introducidos en la tabla de ventas y en la tabla de envios
	$('#btnFinalizar').attr('disabled', 'disabled');
	$("#loader").show();
	try {
			var tipoTransaccion = 1;
			if ($("input[name=envioEspecial]:checked").val() == "on"){
					console.log("Recibo");
					tipoTransaccion = 0;
			}
			//! Detalle de formas pago y emisores

			var detalle = [];
			$(".formasPago").each(function (index) {
				if (accounting.unformat($(this).val()) != 0) {
					var arr = {};
					arr["idFormasPago"] = $(this).data("type");
					arr["idEmisor"] = $(this).data("emisor");
					arr["valor"] = accounting.unformat($(this).val());
					detalle.push(arr);
				}
			});

			console.log(detalle);

			/*
			var detalle = [];
			var arr = {};
			arr["idFormasPago"] = 1;
			arr["idEmisor"] = 0;
			arr["valor"] = $("#totalFacturacion").val();
			detalle.push(arr);
			*/
		
			//! TOTALES
			var totalFactura = accounting.unformat($("#totalFacturacion").val());
			var iva = accounting.unformat(((totalFactura / 1.12) * 0.12 * 100) / 100);
			var total = accounting.unformat(totalFactura - iva);
			//var descuento = accounting.unformat($("#totalDescontado").val());
			var descuento = 0;
			//var subtotal = accounting.unformat($("#subtotalVenta").val());
			var subtotal = accounting.unformat($("#totalFacturacion").val()); 
			 
			//var tipoVenta = $("input[name=formaPago]:checked").val();
			var tipoVenta = 0;


			var nombre = !$("#nombre").val() ? "Consumidor Final" : $("#nombre").val();
			var direccion = !$("#direccion").val() ? "Consumidor Final" : $("#direccion").val();

			var nit = !$("#nit").val() ? "CF" : $("#nit").val();


			var vendedor = $("#selectVendedor1").val();
			
			params = {
				service: "finalizarVenta",
				dbName: dbName,
				urlFEL: urlFEL,
				tokenFEL: tokenFEL,
				idVendedor: vendedor,
				idUsuarios: localStorage.idUsuarios,
				idSucursales: localStorage.idSucursales,
				idEmpresas: localStorage.idEmpresas,
				totalFactura : totalFactura,
				total: subtotal,
				nombre: nombre,
				nit: nit,
				direccion: direccion,
				subtotal: subtotal,
				descuentoM: descuento,
				descuentoP: 0,
				anticipo: 0,
				saldo: total,
				iva: iva,
				tasaCambio: 0,
				totalDolares: 0,
				tipoVenta: tipoVenta,
				idDocumento: $("#idDocumento").val(),
				serie: $("#serie").val(),
				correlativo: $("#correlativo").val(),
				tipoTransaccion:  tipoTransaccion ,
				detalle: detalle,
				codigoMoneda: "GTQ",
				nitExt: 0
			};
			console.log(params);
			$.post(host, params, function (data) {
					$.each(data, function (key, val) {
						switch (val.message) {
							case "success":
								//Cargar funcion que guarde los datos de envío
								guardarDatosEnvio();
								break;
							case "docExists":
								alert("Correlativo de documento ya existe en el sistema");
								break;
							default:
								alert(val.error);
								break;
						}
					});
				}, "json").done(function () {
				$("#loader").hide();
			});
	} catch (err) {
		Swal.fire({
			html: err.message,
			icon: "error",
			confirmButtonColor: "#3085d6",
			confirmButtonText: "Ok",
		}).then((result) => {});
		$("#loader").hide();
		return false;
	}
}

function guardarDatosEnvio(){
	$("#loader").show();
	try {
			//! Valores de entrada
			var ordenCompra = $("#ordenCompra").val().replace(/[_\W]+/g, " ");
			var direccionEnvio = $("#direccionEnvio").val().replace(/[_\W]+/g, " ");
			var pedido = $("#pedido").val().replace(/[_\W]+/g, " ");
			//! CANTIDAD DE BULTOS
			var bultos = $("#bultos").val();
			var telefono = $("#telefono").val().replace(/[_\W]+/g, " ");
			var transporte = $("#transporte").val().replace(/[_\W]+/g, " ");
			var transportista = $("#selectTransportista").val();
			var tipoEnvio = $("#tipoEnvio").val();
			var codigo = $("#selectVendedor1").val();

			if ($("input[name=generarEnvio]:checked").val() == undefined){
				direccionEnvio = "NA";
				transporte = "NA";
				telefono = "0";
				transportista = "NA";
		   }
			if ($("input[name=envioEspecial]:checked").val() == "on"){
				var envioEspecial = 1;
			}else{
				var envioEspecial = 0;
			}
			params = {
				service: "guardarDatosEnvio",
				dbName: dbName,
				urlFEL: urlFEL,
				tokenFEL: tokenFEL,
				idUsuarios: localStorage.idUsuarios,
				idSucursales: localStorage.idSucursales,
				idEmpresas: localStorage.idEmpresas,
				ordenCompra: ordenCompra,
				direccionEnvio: direccionEnvio,
				transporte: transporte,
				pedido: pedido,
				bultos: bultos,
				envioEspecial: envioEspecial,
				codigo: codigo,
				transportista: transportista,
				telefono: telefono,
				tipoEnvio : tipoEnvio
			};
			console.log(params);
			$.post(host, params, function (data) {
					$.each(data, function (key, val) {
						switch (val.message) {
							case "success":
								//Cargar funcion que imprima los recibos
								//Si se selecciono envio especial, no se factura
								if ($("input[name=envioEspecial]:checked").val() == "on"){
									console.log("Recibo");
									popUpEnvioRecibo();
								}else{
									if ($("input[name=generarEnvio]:checked").val() == "on"){
										popUpEnvio();
										popUpFactura();
									}else{
										popUpFactura();
									}
								}
								location.reload();
								break;
							default:
								alert(val.error);
								break;
						}
					});
				}, "json").done(function () {
				$("#loader").hide();
			});
	} catch (err) {
		Swal.fire({
			html: err.message,
			icon: "error",
			confirmButtonColor: "#3085d6",
			confirmButtonText: "Ok",
		}).then((result) => {});
		$("#loader").hide();
		return false;
	}
}
//Dibujar la tabla de articulos 
function getCarrito(){
	$("#tableCarrito tbody").empty();
	params = {
        service: 'loadProductosVenta',
        dbName: dbName,
		idUsuarios: localStorage.idUsuarios,
		idEmpresas: localStorage.idEmpresas
    };
    $.post(host, params, function(data) {
		let carrito = ``;
		if (data === null){
			carrito =`<td colspan="8" style="text-align:center;">0 registros encontrados en el carrito</td>`;
		}else{
			$.each(data, function (key, val) {
				carrito += `
				<tr id="${val.id}" data-precioa ="${val.precioA}" data-preciob ="${val.precioB}" data-precioc ="${val.precioC}" data-preciod ="${val.precioD}">
					<td onclick="eliminarProductoFactura(${val.id}, '${val.descLarga}',${val.idProductos})"><i class="small material-icons">delete</i></td>
					<td><input id="cant${val.id}" min="1" type="number" style="width: 100px; border-bottom: none !important;"/></td>
					<td><input id="unidadMedida${val.id}" type="text" style="width: 100px;border-bottom: none !important;" readonly /></td>
					<td><input id="desc${val.id}" type="text" style="border-bottom: none !important;"/></td>
					<td><input id="fardoMonto${val.id}" type="number" style="width: 100px; border-bottom: none !important;text-align: center;"/></td>
					<td><select class="browser-default" id="tipoPrecio${val.id}" style="width: 100px; border-bottom: none !important;font-size: small;">		
							<option value="menor${val.id}">Menor</option>
							<option value="mayor${val.id}">Mayor</option>
							<option value="cliente${val.id}">Cliente</option>
							<option value="clienteD${val.id}">Cliente Distribuidor</option>
						</select>
					</td>
					<td><input id="totalPrecio${val.id}" min="1" type="number" style="width: 100px; border-bottom: none !important;"/></td>
					<td><input id="valorMonto${val.id}" class="valorMonto" type="number" style="width: 100px;border-bottom: none !important;" readonly /></td>
				</tr>	
				`;
			});
		}
		$("#tableCarrito tbody").html(carrito);

		//Llena los campos de la tabla
		$.each(data, function (key, val) {
			$(`#cant${val.id}`).val(accounting.formatNumber(val.cantidad,2));
			$(`#unidadMedida${val.id}`).val(val.abrev);
			$(`#desc${val.id}`).val(val.descLarga);
			$(`#totalPrecio${val.id}`).val(accounting.formatNumber(val.precio,2));
			$(`#valorMonto${val.id}`).val(val.subtotal);
			$(`#fardoMonto${val.id}`).val(accounting.formatNumber(val.cantFardos,1));

			$(`#desc${val.id}`).on("keyup", delay(function() {
				var input = $(this).val();
				if(input.length >= 3){
					guardarDetCambios(val.id,$(`#cant${val.id}`).val(),input,$(`#totalPrecio${val.id}`).val(),$(`#valorMonto${val.id}`).val(),$(`#fardoMonto${val.id}`).val());
				}
			}, 1500));

			$(`#fardoMonto${val.id}`).on("keyup", delay(function() {
				var input = $(this).val();
				if(input.length >= 1){
					guardarDetCambios(val.id,$(`#cant${val.id}`).val(),$(`#desc${val.id}`).val(),$(`#totalPrecio${val.id}`).val(),$(`#valorMonto${val.id}`).val(),input);
				}
			}, 1500));

			$(`#totalPrecio${val.id}`).on("keyup", delay(function() {
				var input = $(this).val();
				if(input.length >= 1){
					let valor = input;
					let contador = $(`#cant${val.id}`).val();
					valor = valor * contador;
					$(`#valorMonto${val.id}`).val(valor);
					guardarDetCambios(val.id,$(`#cant${val.id}`).val(),$(`#desc${val.id}`).val(),input,$(`#valorMonto${val.id}`).val(),$(`#fardoMonto${val.id}`).val());
				}
			}, 1500));
			
			$(`#cant${val.id}`).on("keyup", delay(function() {
				var input = $(this).val();
				if(input.length >= 1){
					let valor = $(`#totalPrecio${val.id}`).val();
					let contador = input;
					valor = valor * contador;
					console.log(valor)
					$(`#valorMonto${val.id}`).val(valor);
					console.log($(`#valorMonto${val.id}`).val())
					guardarDetCambios(val.id,input,$(`#desc${val.id}`).val(),$(`#totalPrecio${val.id}`).val(),$(`#valorMonto${val.id}`).val(),$(`#fardoMonto${val.id}`).val());
				}
			}, 1500));

			$(`#tipoPrecio${val.id}`).on("change", function() {
				var cantidad = accounting.unformat($(`#cant${val.id}`).val());

				var tipoPrecio = $(`#tipoPrecio${val.id}`).val();
				var precioA = $(`#${val.id}`).data("precioa");
				var precioB = $(`#${val.id}`).data("preciob");
				var precioC = $(`#${val.id}`).data("precioc");
				var precioD = $(`#${val.id}`).data("preciod");

				switch(tipoPrecio){
					case `menor${val.id}`:
						$(`#totalPrecio${val.id}`).val(accounting.formatNumber(precioA,2));
						$(`#valorMonto${val.id}`).val(precioA * cantidad);
						guardarDetCambios(val.id,$(`#cant${val.id}`).val(),$(`#desc${val.id}`).val(),$(`#totalPrecio${val.id}`).val(),$(`#valorMonto${val.id}`).val(),$(`#fardoMonto${val.id}`).val());
						break;
					case `mayor${val.id}`:
						$(`#totalPrecio${val.id}`).val(accounting.formatNumber(precioB,2));
						$(`#valorMonto${val.id}`).val(precioB * cantidad);
						guardarDetCambios(val.id,$(`#cant${val.id}`).val(),$(`#desc${val.id}`).val(),$(`#totalPrecio${val.id}`).val(),$(`#valorMonto${val.id}`).val(),$(`#fardoMonto${val.id}`).val());
						break;
					case `cliente${val.id}`:
						$(`#totalPrecio${val.id}`).val(accounting.formatNumber(precioC,2));
						$(`#valorMonto${val.id}`).val(precioC * cantidad);
						guardarDetCambios(val.id,$(`#cant${val.id}`).val(),$(`#desc${val.id}`).val(),$(`#totalPrecio${val.id}`).val(),$(`#valorMonto${val.id}`).val(),$(`#fardoMonto${val.id}`).val());
					break;
					case `clienteD${val.id}`:
						$(`#totalPrecio${val.id}`).val(accounting.formatNumber(precioD,2));
						$(`#valorMonto${val.id}`).val(precioD * cantidad);
						guardarDetCambios(val.id,$(`#cant${val.id}`).val(),$(`#desc${val.id}`).val(),$(`#totalPrecio${val.id}`).val(),$(`#valorMonto${val.id}`).val(),$(`#fardoMonto${val.id}`).val());
					break;
					default: break;
				}
			});
		});
    }, 'json').done(function(){});
}

function getTotalesCarrito(){
	params = {
        service: 'loadProductosVenta',
        dbName: dbName,
		idUsuarios: localStorage.idUsuarios,
		idEmpresas: localStorage.idEmpresas,
    };
    $.post(host, params, function(data) {
		var total = 0;
		var total2 = 0;
		var totalFardos = 0;
		if (data === null){
			$("#totalItems").val(0);
			$("#total").val(0);
			var summary = `<tr style="background-color: #263238 !important;color:  #FFF !important;border: 0 !important;">
				<td colspan="4" style="text-align:right;">Cantidad de Bultos:</td>
				<td><input type="number" id="bultos" value="${totalFardos}" style="height:auto;text-align: center; color: white; border-bottom: none !important;"/></td>
				<td></td>
				<td>Total Q</td>
				<td id="totalFacturacion1">${accounting.formatNumber(total,2)}</td>
				<input type="hidden" id="totalFacturacion" value="${total}" />
			</tr>`;
		}else{
			$.each(data, function (key, val) {
				totalFardos += accounting.unformat(val.cantFardos);
				total += accounting.unformat(val.total);
				total2 += accounting.unformat(val.cantidad);
			});
		$("#totalItems").val(total2);
		$("#total").val(total);
		var summary = `<tr style="background-color: #263238 !important;color:  #FFF !important;border: 0 !important;">
			<td colspan="4" style="text-align:right;">Cantidad de Bultos:</td>
			<td><input type="number" id="bultos" value="${totalFardos}" style="height:auto;text-align: center; color: white; border-bottom: none !important;"/></td>
			<td></td>
			<td>Total Q</td>
			<td id="totalFacturacion1">${accounting.formatNumber(total,2)}</td>
			<input type="hidden" id="totalFacturacion" value="${total}" />
			
		</tr>`;
		}
		$("#tableCarrito tfoot").html(summary);
    }, 'json').done(function(){});
}

//Guarda los campos de la tabla si es que se modificaron;
function guardarDetCambios(id,cant,desc,precio,valor,fardos){
	var descripcion = desc.replace(/[_\W]+/g, " ");
	var cantidad = cant;

	if (cant < 0 || cant == "" || precio < 0 || precio == "" || descripcion == "" || fardos < 0 ){
		Swal.fire({
			text: `Introduce un valor valido`,
			icon: "warning",
			confirmButtonColor: "#3085d6",
			confirmButtonText: "Ok",
		}).then((result) => {});
	}else{
		params = {
			service: "guardarDetCambios",
			dbName: dbName,
			idSucursales: localStorage.idSucursales,
			idUsuarios: localStorage.idUsuarios,
			id: id,
			desc: descripcion,
			cant: cantidad,
			precio: precio,
			valor: valor,
			fardos: fardos
		};
		$.post(host, params, function (data) {
		}, "json").done(function () {
				console.log("Saved!");
				getTotalesCarrito();
		});
	}
}

function popUpFactura(){
	var popup = window.open("facturaPrint.html", "","width=1000,height=800");
}

//Otra factura de envio 
function popUpEnvio(){
	var popup = window.open("envioPrint.html", "","width=1000,height=800");
}

function popUpEnvioRecibo(){
	window.open("envioPrintRecibo.html", "","width=1000,height=800");
}

function getHeaderFactura(){
	$("#headers").html("");
	$("#facturaFoot").html("");
	params = {
		service: "printFacturaEnvioHeader",
		dbName: dbName
	};
	$.post(host, params, function (data) {
		//console.log(data);
		let headers = ``;
		let summary = ``;
		let foot = ``;
		$.each(data, function (key, val) {
			if(val.autorizacionFEL === null){
				var autorizacion = "N/A";
			}else{
				var autorizacion = val.autorizacionFEL;
			}
			if(val.fechaEmisionFEL === null){
				var fechaHora = "N/A";
			}else{
				var fechaHora = val.fechaEmisionFEL;
			}
			headers += `
			<div style="display: grid;grid-template-columns: auto auto auto auto;">
				<div style="grid-column: 1 / span 3">
					<img src="assets/images/corfila.jpg" style="width: 105px; height: 100px;" />
					<div style="display: inline-block;font-size: smaller;text-align: center;">
					<b style="font-size: x-large;">CORFILA S.A.</b></br>
					Corporaci&oacute;n Filadelfia, S.A.</br>
					F&aacute;brica de Bolsas y Productos Pl&aacute;sticos </br>
					17 avenida 5-46, Zona 1. Guatemala, Ciudad </br>
					Tels.: (502) 2253-3823, 253-8249/50, 2238-4901 </br>
					E-mail: ventascorfila01@gmail.com / ventas@corfila-gt.com </br>
					</div>
				</div>
				<div style="grid-column: 4;padding-top: 25px">
					<b>FACTURA</b> </br>
					<b>NIT:</b> ${val.nitEmpresa} </br>
					<b>SERIE:</b> ${val.serie} </br>
					<b>DTE:</b> ${val.correlativo}
				</div>
				<div style="border: 1px solid;border-top-left-radius:20px;padding-left: 15px !important;padding: unset; grid-column:1 / span 2">
					<b>ORDEN DE COMPRA:</b> ${val.ordenCompra}
				</div>
				<div style="border: 1px solid;padding-left: 15px !important;padding: unset;grid-column:3"> 
					<b>Venta:</b> ${val.formaPago}
				</div>
				<div style="border: 1px solid;border-top-right-radius:20px;padding-left: 15px !important;padding: unset;grid-column: 4;">
					<b>GUATEMALA </br> FECHA:</b> ${val.fechaFactura}
				</div>
				<div style="border: 1px solid;border-right:none;grid-column: 1 / span 3;padding-left: 15px !important;padding: unset;"><b>NOMBRE:</b> ${val.nombre} <br/>
					<b>DIRECCI&Oacute;N:</b> ${val.direccion}
				</div>
				<div style="border: 1px solid;border-left:none;padding-left: 15px !important;padding: unset;grid-column: 4 ;">
					<b>NIT:</b> ${val.nit}
				</div>
				<div style="border: 1px solid;border-bottom-left-radius:20px;padding-left: 15px !important;padding: unset;grid-column: 1 / span 2;">
					<b>TRANSPORTE:</b> ${val.transporte}
				</div>
				<div style="border: 1px solid;padding-left: 15px !important;padding: unset;grid-column:3">
					<b>VENDEDOR:</b> ${val.userName}
				</div>
				<div style="border: 1px solid;border-bottom-right-radius:20px;padding-left: 15px !important;padding: unset;grid-column: 4;">
					<b>C&Oacute;DIGO:</b> ${val.codigo}
				</div>
			</div>	
			`;
			summary += `<tr style="">
			<td colspan="3" style="padding-left: 15px;font-size: 8px;text-align: justify;border-top-style: solid;border-width: thin;">
			<b>EMITIR CHEQUE A NOMBRE DE LA EMPRESA CORFILA, S.A.</b></br>
			EN LAS CONDICIONES ESTIPULADAS EN ESTE TITULO.</br>
			A:</br>
			SE SERVIRAN USTEDES PAGAR POR ESTA UNICA FACTURA CAMBIARIA GIRADA LIBRE DE PROTESTO A LA ORDEN O ENDOSO DE </br>
			<b> CORFILA, S.A.</b> VALOR TOTAL POR EL QUE SE ESTA EXTENDIDA O POR EL ULTIMO SALDO INSOLUTO QUE APAREZCA, 
			VALOR RECIBIDO QUE ASENTARAN USTEDES A CUENTA, SEGUN NUESTRO AVISO. LAS MERCADERIAS CONSIGNADAS EN ESTA FACTURA, 
			SE RECIBEN DE CONFORMIDAD Y CONDICIONES OPTIMAS.</br>
			EL VALOR DE ESTA FACTURA DEBERA SER CANCELADO DENTRO DE LOS 30 DIAS FECHA DE FACTURACION. CASO CONTRARIO, 
			SE LE CARGARA 2% DE INTERES MENSUAL. <b>SI SU PAGO ES CON CHEQUE FAVOR EMITIRLO A NOMBRE DE CORFILA, S.A.</br>
			NOTA:</b> POR CADA CHEQUE RECHAZADO SE COBRARA LA CANTIDAD DE CIEN QUETZALES.
			</td>
			<td style="text-align: center;font-size: large;border-top-style: solid;border-left-style: solid;border-width: thin;"><b>Total Q</b></td>
			<td style="text-align: center;padding-right: 15px;font-size: large;border-top-style: solid;border-left-style: solid;border-width: thin;"><b>${accounting.formatNumber(val.total,2)}</b></td>
			</tr>
			<tr >
				<td colspan="5" style="padding-left: 15px;border-top-style: solid;border-width: thin;"><b>TOTAL EN LETRAS: </b>${val.totalEnLetras}</td>
			</tr>
			`;
			foot += `
			<div style="text-align:end;margin-right: 10px;font-size: smaller;"><b>SUJETO A PAGOS TRIMESTRALES, NO RETENER</b></br><b>AUTORIZACION: </b>${autorizacion}</br><b>FECHA Y HORA: </b>${fechaHora}</div>
			<div style="text-align: center;margin-top: 20px;">____________________________</div>
			<div style="text-align: center;font-size: x-small;">ACEPTADO LIBRE DE PROTESTO</div>
			`
		});
		$("#headers").html(headers);
		$("#bodyTable tfoot").html(summary);
		$("#facturaFoot").html(foot);
	}, "json").done(function(){
		getDetallesFactura();
	});
}

function getDetallesFactura(){
	$("#bodyTable tbody").html("");
	params = {
		service: "printFacturaEnvioDetail",
		dbName: dbName
	};
	$.post(host, params, function (data) {
		let table = ``;
		var total = 0;
		
		$.each(data, function (key, val) {
			total += accounting.unformat(val.total);
			table += `
				<tr>
					<td style="padding-left: 15px">${val.cantidad}</td>
					<td style="padding-left: 15px">${val.sku}</td>
					<td style="padding-left: 15px">${val.descLarga}</td>
					<td style="padding-left: 15px">${val.precio}</td>
					<td style="padding-left: 15px">${val.total}</td>
				</tr>
			`;
		});
		$("#bodyTable tbody").html(table);		
	}, "json").done(function(){
	});
}

//Construccion del formato para el documento de imprecion de envio
function getHeaderEnvio(){
	$("#headerEnvio").html("");
	$("#envioFoot").html("");
	params = {
		service: "printFacturaEnvioHeader",
		dbName: dbName
	};
	$.post(host, params, function (data) {
		//console.log(data);
		let headersEnvio = ``;
		let summary = ``;
		let pageFoot = ``;
		$.each(data, function (key, val) {
			if(val.autorizacionFEL === null){
				autorizacion = "N/A";
			}else{
				autorizacion = val.autorizacionFEL;
			}
			headersEnvio += `
			<div style="display: grid;grid-template-columns: auto auto auto auto;">
				<div style="grid-column: 1 / span 2">
					<img src="assets/images/corfila.jpg" style="width: 105px; height: 100px;" />
					<div style="display: inline-block;font-size: smaller;text-align: center;">
						<b style="font-size: x-large;">CORFILA S.A.</b></br>
						Corporaci&oacute;n Filadelfia, S.A.</br>
						F&aacute;brica de Bolsas y Productos Pl&aacute;sticos </br>
						17 avenida 5-46, Zona 1. Guatemala, Ciudad </br>
						Tels.: (502) 2253-3823, 253-8249/50, 2238-4901 </br>
						E-mail: ventascorfila01@gmail.com / ventas@corfila-gt.com </br>
					</div>
				</div>
				<div style="border: 1px solid;border-top-right-radius:10px;border-top-left-radius:20px;border-bottom-right-radius:10px;padding-left: 15px;padding-top: 10px;margin-top: 50px;padding-bottom: 11px;grid-column: 3 / span 2;">
				<b>GUATEMALA - FECHA: </b>${val.fechaFactura}
				</div>
				<div style="border: 1px solid;border-right:none;border-bottom: none;border-top-left-radius:10px;padding-left: 15px;grid-column: 1 / span 2;padding-left: 15px !important;padding: unset;"><b>NOMBRE:</b> ${val.nombre} <br/>
					<b>DIRECCI&Oacute;N:</b> ${val.direccionEnvio}
				</div>
				<div style="border: 1px solid;border-left:none;border-bottom: none;border-top-right-radius:10px;padding-left: 15px !important;padding: unset;grid-column: 4 ;">
					<b>NIT:</b> ${val.nit} </br>
					<b>TEL:</b> ${val.telefono}
				</div>
				<div style="border-left: 1px solid;border-top: none;padding-left: 15px !important;padding: unset;grid-column: 1 / span 2;">
					<b>SERIE:</b> ${val.serie} &emsp; &emsp; <b>DTE:</b> ${val.correlativo} </br><b>AUTORIZACION:</b> ${autorizacion} 
				</div>
				<div style="border-right: 1px solid;border-top: none;padding-left: 15px !important;padding: unset;grid-column: 3 / span 2 ;">
					<b>PEDIDO No.:</b> ${val.pedido}
				</div>
				<div style="border: 1px solid;border-bottom-left-radius:20px;border-right: none;border-top: none;padding-left: 15px !important;padding: unset;grid-column: 1 / span 2;">
					<b>TRANSPORTE: </b> ${val.transporte}
				</div>
				<div style="border: 1px solid;border-bottom-right-radius:20px;border-left: none;border-top: none;padding-left: 15px !important;padding: unset;grid-column: 3 / span 2 ;">
					<b>CANTIDAD DE BULTOS:</b> ${val.cantBultos}
				</div>
			</div>	
			`;
			if (val.tipoEnvio == '1'){
				summary += `<tr>
				<td colspan="2" style="padding-left: 15px;"><b>EN LETRAS: </b></br> ${val.totalEnLetras}</td>
				<td style="font-size: large;"><b>Total Q</b></td>
				<td style="padding-right: 15px;font-size: large;"><b>${accounting.formatNumber(val.total,2)}</b></td>
			</tr>
			`;
			}else{
				summary += `<tr>
				<td colspan="2" style="padding-left: 15px;"><b>EN LETRAS:</b></br></td>
				<td style="font-size: large;"><b>Total Q</b></td>
				<td style="padding-right: 15px;font-size: large;"><b>0.00</b></td>
				</tr>
			`;
			}
			pageFoot += `<div style="text-align: center;margin-top: 20px;font-size: smaller;"><pre><b>ENTREGO: </b>${val.transportista}<b>	RECIB&Iacute:</b>_____________________________</pre></div>
			`;
		});
		$("#headerEnvio").html(headersEnvio);
		$("#bodyTableEnvio tfoot").html(summary);
		$("#envioFoot").html(pageFoot);
	}, "json").done(function(){
		getDetallesEnvios();
	});
}

function getDetallesEnvios(){
	$("#bodyTableEnvio tbody").html("");
	params = {
		service: "printFacturaEnvioDetail",
		dbName: dbName
	};
	$.post(host, params, function (data) {
		let table = ``;
		var total = 0;
		var totales = ``;
		$.each(data, function (key, val) {
			if (val.tipoEnvio == '1'){
				totales = val.total;
			}else{
				totales = "0.00";
			}
			total += accounting.unformat(val.total);
			table += `
				<tr>
					<td style="padding-left: 15px">${val.cantidad}</td>
					<td style="padding-left: 15px">${val.descLarga}</td>
					<td style="padding-left: 15px">${val.cantFardos}</td>
					<td style="padding-left: 15px">${totales}</td>
				</tr>
			`;
		});
		$("#bodyTableEnvio tbody").html(table);
	}, "json").done(function(){
	});
}

function eliminarProductoFactura(id, descLarga,idProductos) {
	$("#loader").hide();
	Swal.fire({
		title: "&iquest;Eliminar Producto?",
		text: `${descLarga}`,
		icon: "warning",
		showCancelButton: true,
		confirmButtonColor: "#3085d6",
		cancelButtonColor: "#d33",
		confirmButtonText: "Si",
		cancelButtonText: "Cancelar",
	}).then((result) => {
		if (result.value) {
			params = {
				service: "eliminarProductoVenta",
				dbName: dbName,
				id: id,
				idProductos: idProductos
			};
			$.post(
				host,
				params,
				function (data) {
					$.each(data, function (key, val) {
						if (val.message === "success") {
							getCarrito();
							getTotalesCarrito();
						} else {
							alert(`Error: ${val.Query}`);
						}
					});
				},
				"json",
			);
		}
	});
}


//Construccion del formato para el documento de imprecion de envio
function getHeaderEnvioRecibo(){
	$("#headerEnvioRecibo").html("");
	$("#envioFootRecibo").html("");
	params = {
		service: "printFacturaEnvioHeader",
		dbName: dbName
	};
	$.post(host, params, function (data) {
		let headersEnvio = ``;
		let summary = ``;
		let pageFoot = ``;
		$.each(data, function (key, val) {
			headersEnvio += `
			<div style="display: grid;grid-template-columns: auto auto auto auto;">
				<div style="grid-column: 1 / span 2">
					<img src="assets/images/corfila.jpg" style="width: 105px; height: 100px;" />
					<div style="display: inline-block;font-size: smaller;text-align: center;">
						<b style="font-size: x-large;">CORFILA S.A.</b></br>
						Corporaci&oacute;n Filadelfia, S.A.</br>
						F&aacute;brica de Bolsas y Productos Pl&aacute;sticos </br>
						17 avenida 5-46, Zona 1. Guatemala, Ciudad </br>
						Tels.: (502) 2253-3823, 253-8249/50, 2238-4901 </br>
						E-mail: ventascorfila01@gmail.com / ventas@corfila-gt.com </br>
					</div>
				</div>
				<div style="border: 1px solid;border-top-right-radius:10px;border-top-left-radius:20px;border-bottom-right-radius:10px;padding-left: 15px;padding-top: 10px;margin-top: 50px;padding-bottom: 11px;grid-column: 3 / span 2;">
					<b>RECIBO DE ENVIO</b></br>
					<b>GUATEMALA - FECHA: </b>${val.fechaFactura}
				</div>
				<div style="border: 1px solid;border-right:none;border-bottom: none;border-top-left-radius:10px;padding-left: 15px;grid-column: 1 / span 2;padding-left: 15px !important;padding: unset;"><b>NOMBRE:</b> ${val.nombre} <br/>
					<b>DIRECCI&Oacute;N:</b> ${val.direccionEnvio}
				</div>
				<div style="border: 1px solid;border-left:none;border-bottom: none;border-top-right-radius:10px;padding-left: 15px !important;padding: unset;grid-column: 4 ;">
					<b>NIT:</b> ${val.nit} </br>
					<b>TEL:</b> ${val.telefono}
				</div>
				<div style="border-left: 1px solid;border-top: none;padding-left: 15px !important;padding: unset;grid-column: 1 / span 2;">
				</div>
				<div style="border-right: 1px solid;border-top: none;padding-left: 15px !important;padding: unset;grid-column: 3 / span 2 ;">
					<b>PEDIDO No.:</b> ${val.pedido}
				</div>
				<div style="border: 1px solid;border-bottom-left-radius:20px;border-right: none;border-top: none;padding-left: 15px !important;padding: unset;grid-column: 1 / span 2;">
					<b>TRANSPORTE: </b> ${val.transporte}
				</div>
				<div style="border: 1px solid;border-bottom-right-radius:20px;border-left: none;border-top: none;padding-left: 15px !important;padding: unset;grid-column: 3 / span 2 ;">
					<b>CANTIDAD DE BULTOS:</b> ${val.cantBultos}
				</div>
			</div>	
			`;
			if (val.tipoEnvio == '1'){
				summary += `<tr>
				<td colspan="2" style="padding-left: 15px;"><b>EN LETRAS: </b></br> ${val.totalEnLetras}</td>
				<td style="font-size: large;"><b>Total Q</b></td>
				<td style="padding-right: 15px;font-size: large;"><b>${accounting.formatNumber(val.total,2)}</b></td>
			</tr>
			`;
			}else{
				summary += `<tr>
				<td colspan="2" style="padding-left: 15px;"><b>EN LETRAS:</b></br></td>
				<td style="font-size: large;"><b>Total Q</b></td>
				<td style="padding-right: 15px;font-size: large;"><b>0.00</b></td>
				</tr>
			`;
			}
			pageFoot += `<div style="text-align: center;margin-top: 20px;font-size: smaller;"><pre><b>ENTREGO: </b>${val.transportista}<b>	RECIB&Iacute:</b>_____________________________</pre></div>
			`;
		});
		$("#headerEnvioRecibo").html(headersEnvio);
		$("#bodyTableEnvioRecibo tfoot").html(summary);
		$("#envioFootRecibo").html(pageFoot);
	}, "json").done(function(){
		getDetallesEnviosRecibo();
	});
}

function getDetallesEnviosRecibo(){
	$("#bodyTableEnvioRecibo tbody").html("");
	params = {
		service: "printFacturaEnvioDetail",
		dbName: dbName
	};
	$.post(host, params, function (data) {
		let table = ``;
		var total = 0;
		var totales = ``;
		$.each(data, function (key, val) {
			if (val.tipoEnvio == '1'){
				totales = val.total;
			}else{
				totales = "0.00";
			}
			total += accounting.unformat(val.total);
			table += `
				<tr>
					<td style="padding-left: 15px">${val.cantidad}</td>
					<td style="padding-left: 15px">${val.descLarga}</td>
					<td style="padding-left: 15px">${val.cantFardos}</td>
					<td style="padding-left: 15px">${totales}</td>
				</tr>
			`;
		});
		$("#bodyTableEnvioRecibo tbody").html(table);
	}, "json").done(function(){
	});
}

