// Imprimer la apertura de caja
function printApertura() {
	params = {
		service: "fondoCaja",
		dbName: dbName,
		IdSucursales: localStorage.idSucursales,
		IdUsuarios: localStorage.idUsuarios,
	};
	$.post(host, params, function (data) {
			$.each(data, function (key, val) {
				if (sunmiDevice) {
					sunmiApertura(val);
					
				} else {
					localPrinter(val, "printApertura");
				}
			});
		},
		"json",
	).done(function () {});
}

// Impresion de Ticket de apertura en impresora Sunmi
function sunmiApertura(val){
	sunmiInnerPrinter.printerInit()
	.then(() => {
		return sunmiInnerPrinter.setAlignment(1);
	})
	.then(() => {
		return sunmiInnerPrinter.printTextWithFont(`APERTURA DE CAJA\n${val.empresa}\n`, "", fontL);
	})
	.then(() => {
		return sunmiInnerPrinter.printTextWithFont(`NIT: ${val.nit}\n${val.sucursal}\n`, "", fontM);
	})
	.then(()=>{
		return sunmiInnerPrinter.setAlignment(0);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`Usuario : ${val.usuario}\nApertura: ${val.date_apertura}\n`, "", fontS);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`Fondo : Q${val.monto}\n`, "", fontM);
	})
	.then(()=>{
		return sunmiInnerPrinter.setAlignment(1);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`\n\n\n${prntlinea}\n`, "", fontL);
	})
	.then(()=>{    
		return sunmiInnerPrinter.printTextWithFont(`Firma Cajero`, "", fontS);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`\n\n\n${prntlinea}\n`, "", fontL);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`Firma Encargado\n\n\n`, "", fontS);
	})
	.then(()=>{
		if(hasCutter)
			return sunmiInnerPrinter.cutPaper();		
		else
			return true;
	})
	.then(()=>{
		location.reload();
	});
}

// Obtiene datos del documento emitido para su impresion
function printer(idVenta, tipTrans, openCash, noImpresiones) {
	params = {
		service: "generarFormatoFEL",
		idVenta: idVenta,
		dbName: dbName
	};
	$.post( host, params, function (data) {
			$.each(data, function (key, val) {
				switch (val.message) {
					case "success":
						val.tipoTransaccion = tipTrans;
						val.openCashDrawer = openCash;

						if (sunmiDevice) {
							//console.log(val);
							printFacturaSunmi(val);
						} else {
							localPrinter(val, "printFactura");
						}


						break;
					default:
						alert(`Error generacion FEL: ${val.error}`);
						break;
				}
			});
		}, "json").done(function () {
		$("#loader").hide();
		//location.reload();
	});
}

function printerNotaCredito(idVenta, tipTrans, openCash, noImpresiones) {
	params = {
		service: "generarFormatoFEL",
		idVenta: idVenta,
		dbName: dbName
	};
	$.post( host, params, function (data) {
			$.each(data, function (key, val) {
				switch (val.message) {
					case "success":
						val.tipoTransaccion = tipTrans;
						val.openCashDrawer = openCash;
						val.serieOrigen = $("#serieOrigen").val();
						val.correlativoOrigen = $("#correlativoOrigen").val();
						val.fechaOrigen = $("#fechaOrigen").val();
						val.autorizacionFELOrigen = $("#autorizacionFELOrigen").val();

						if (sunmiDevice) {
							printNCRESunmi(val);
						} else {
							localPrinter(val, "printNCRE");
						}
						break;
					default:
						alert(`Error generacion FEL: ${val.error}`);
						break;
				}
			});
		}, "json").done(function () {
		$("#loader").hide();
		//location.reload();
	});
}

// Imrpime Documento emitido por venta en impresora sunmi
function printNCRESunmi(val) {
	let datFac = val.data;
	let detVenta = val.detalle;
	var tamano = [col4A, col4B, col4C, col4C];
	var alineamiento = [0, 0, 2, 2];
	var autorizacioFEL = "";

	var texto = ["Cant.", "Descrip.", "Precio", "Total"];
	//var moneda = (datFac.idFormasPago == 2)? "$" : "Q";
	var moneda = "Q";
	//var nombreFEL;
	switch (papel){
		case 55:
			let strFEL = datFac.AutorizacionFEL;
			let arrFEL = strFEL.split("-");
			autorizacioFEL = arrFEL[0] + "-" + arrFEL[1] + "-" + arrFEL[2] + "\n-" + arrFEL[3] + "-" + arrFEL[4];
			break;
		case 80:
			autorizacioFEL = datFac.AutorizacionFEL;
			break;
		default:
			autorizacioFEL = datFac.AutorizacionFEL;
			break;
	}
	
	sunmiInnerPrinter.printerInit()
	.then(() => {
		return sunmiInnerPrinter.setAlignment(1);
	})
	.then(() => {
		return sunmiInnerPrinter.printBitmap(datFac.logoFEL, datFac.widthFEL, datFac.heightFEL);
	})
	.then(() => {
		return sunmiInnerPrinter.printTextWithFont(`\n\n${datFac.Empresa}\n`, "", fontL);
	})
	.then(() => {
		return sunmiInnerPrinter.printTextWithFont(`${datFac.razonSocial}\n${datFac.direccion}\nNIT: ${datFac.NIT}\n`, "", fontS);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`\nNOTA DE CREDITO\n`, "", fontM);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`DOCUMENTO ELECTRONICO\n${datFac.leyendaFEL}\nNumero Autorizacion\n${autorizacioFEL}\nFecha Certificacion : ${ datFac.FechaEmisionFEL}\nDIGIFACT Servicios \n NIT: 77454820\n\n`,"",fontS);
	})
	.then(()=>{
		return sunmiInnerPrinter.setAlignment(0);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`Serie: ${datFac.serie}\nNumero: ${datFac.correlativo}\nFecha Emision: ${datFac.FechaFactura}\nNIT: ${datFac.nitCliente}\nNombre: ${datFac.nombreCliente}\n`, "", fontS);
	})
	.then(()=>{
		return sunmiInnerPrinter.setAlignment(1);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`DATOS DE FACTURA ORIGEN\nNumero Autorizacion\n${val.autorizacionFELOrigen}\nFecha Certificacion : ${val.fechaOrigen}\nDIGIFACT Servicios \n NIT: 77454820\n\n`,"",fontS);
	})
	.then(()=>{
		return sunmiInnerPrinter.setAlignment(0);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`Serie: ${val.serieOrigen}\nNumero: ${val.correlativoOrigen}\nFecha Emision: ${val.fechaOrigen}\n`, "", fontS);
	})

	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont(`\nVendedor: ${datFac.userName}\n\n`, "", fontS);
	})
	.then(()=>{
		return sunmiInnerPrinter.printColumnsText(texto, tamano, alineamiento);
	})
	.then(()=>{
		// ! Agregar impresion de opciones por producto
		var i = 0;
		while (detVenta[i]) {
			let item = detVenta[i];
			let producto = [
				parseFloat(item.Cantidad),
				item.DescCorta,
				moneda + item.PrecioUnitario,
				moneda + item.Total];
			i++;
			sunmiInnerPrinter.printerInit()
			.then(() => {
				return sunmiInnerPrinter.printColumnsText(producto, tamano, alineamiento);
			});
			
		}

		return sunmiInnerPrinter.setAlignment(0);
	})
	.then(()=>{
		tamano = [col2A, col2B];
		alineamiento = [2, 2];
		if(datFac.descuento > 0){
			let subTotal = parseFloat(datFac.total) + parseFloat(datFac.descuento);
			return sunmiInnerPrinter.printColumnsText(["Sub-Total", moneda + subTotal], tamano, alineamiento);
		}
		else
			return sunmiInnerPrinter.setAlignment(0);
	})
	.then(()=>{
		if(datFac.descuento > 0)
			return sunmiInnerPrinter.printColumnsText(["Descuento", "-" + moneda + datFac.descuento], tamano, alineamiento);
		else
			return sunmiInnerPrinter.setAlignment(0);
	})
	.then(()=>{
		texto = ["Total", moneda + datFac.total];
		return sunmiInnerPrinter.printColumnsText(texto, tamano, alineamiento);
	})
	.then(()=>{
		return sunmiInnerPrinter.setAlignment(1);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont("\npowered by Proper\nwww.somosproper.com\n\n\n", "", fontS);
	})
	.then(() =>{
		if (footerFEL == "") {
			return sunmiInnerPrinter.printTextWithFont("\n\n\n", "", fontS);
		}
		else{
			return sunmiInnerPrinter.printTextWithFont(`IMPORTANTE\n`, "", fontM);
		}
	})
	.then(()=>{
		return sunmiInnerPrinter.setAlignment(1);
	})
	.then(() =>{
		if (footerFEL == "") {
			return sunmiInnerPrinter.printTextWithFont("\n", "", fontS);
		}
		else{
			return sunmiInnerPrinter.printTextWithFont(`${footerFEL}\n\n\n\n`, "", fontS);
		}
	})
	.then(()=>{
		if(hasCutter)
			return sunmiInnerPrinter.cutPaper();		
		else
			return true;
	})
	.then(()=>{
		if(localStorage.isMobile != 'true' && val.openCashDrawer){
			sunmiInnerPrinter.openDrawer();
			return true;
		}
		else
			return true;
	})
	.then(()=>{
		if(usaComandas && pagina == "main"){
			Swal.fire({
				icon: 'warning',
				iconHtml: '<a class="btn-floating btn-large pulse amber darken-2"><i class="medium material-icons pulse">content_cut</i></a>',
				backdrop: false,
				showCloseButton: false,
				confirmButtonText: 'Comandar',
				html: '&#191;Continuar con impresi&#243;n de comanda?'
			}).then((result) => {
				if(result){
					tamano = [5, 25];
					alineamiento = [2, 0];

					sunmiInnerPrinter.printerInit()
					.then(() => {
						return sunmiInnerPrinter.setAlignment(0);
					})
					.then(() => {
						return sunmiInnerPrinter.printTextWithFont(`COMANDA # ${datFac.correlativo}\n`, "", fontL);
					})
					.then(() => {
						return sunmiInnerPrinter.setAlignment(1);
					})
					.then(()=>{
						return sunmiInnerPrinter.printTextWithFont(`${prntlinea}\n`, "", fontL);
					})
					.then(()=>{
						return sunmiInnerPrinter.printColumnsText(["Cant.", "Descrip."], tamano, alineamiento);
					})
					.then(()=>{
						return sunmiInnerPrinter.setAlignment(0);
					})
					.then(()=>{
						var j = 0;
						while (detVenta[j]) {
							let item = detVenta[j];
							let producto = [parseFloat(item.Cantidad), item.DescCorta];
							j++;
							sunmiInnerPrinter.printerInit()
							.then(() => {
								return sunmiInnerPrinter.printColumnsText(producto, tamano, alineamiento);
							});
							// print item.subopciones
						}
						return sunmiInnerPrinter.setAlignment(1);
					})
					.then(()=>{
						return sunmiInnerPrinter.printTextWithFont(`\n\n\n\n\n\n\n${prntlinea}\n`, "", fontL);
					})
					.then(()=>{
						if(hasCutter)
							return sunmiInnerPrinter.cutPaper();		
						else
							return true;
					})
					.then(()=>{
						if(pagina == 'main' || pagina == 'mobileShop' || pagina == 'pumpStation')
							location.reload();
					});
				}
				
			});
		}
		else{
			window.location = "transacciones.html";
		}
	});
}

// Imrpime Documento emitido por venta en impresora sunmi
function printFacturaSunmi(val) {
	let datFac = val.data;
	let detVenta = val.detalle;
	var tamano = [col4A, col4B, col4C, col4C];
	var alineamiento = [0, 0, 2, 2];
	var autorizacioFEL = "";

	var texto = ["Cant.", "Descrip.", "Precio", "Total"];
	//var moneda = (datFac.idFormasPago == 2)? "$" : "Q";
	var moneda = "Q";
	//var nombreFEL;
console.log(val.data);
	if (val.tipoTransaccion == 1){
		switch (papel){
			case 55:
				let strFEL = datFac.AutorizacionFEL;
				let arrFEL = strFEL.split("-");
				autorizacioFEL = arrFEL[0] + "-" + arrFEL[1] + "-" + arrFEL[2] + "\n-" + arrFEL[3] + "-" + arrFEL[4];
				break;
			case 80:
				autorizacioFEL = datFac.AutorizacionFEL;
				break;
			default:
				autorizacioFEL = datFac.AutorizacionFEL;
				break;
		}
	}
	
	// switch (datFac.tipoAfiliacion){
	// 	case "GEN":
	// 		nombreFEL = "FACTURA";
	// 		break;
	// 	case "PEQ":
	// 		nombreFEL = "FACTURA PEQUEÑO CONTRIBUYENTE";
	// 		break;
	// 	default:
	// 		nombreFEL = "FACTURA";
	// 		break;
	// }

	sunmiInnerPrinter.printerInit()
	.then(() => {
		return sunmiInnerPrinter.setAlignment(1);
	})
	.then(() => {
		return sunmiInnerPrinter.printBitmap(datFac.logoFEL, datFac.widthFEL, datFac.heightFEL);
	})
	.then(() => {
		return sunmiInnerPrinter.printTextWithFont(`\n\n${datFac.Empresa}\n`, "", fontL);
	})
	.then(() => {
		return sunmiInnerPrinter.printTextWithFont(`${datFac.razonSocial}\n${datFac.direccion}\nNIT: ${datFac.NIT}\n`, "", fontS);
	})
	.then(()=>{
		if (val.tipoTransaccion == 1)
			return sunmiInnerPrinter.printTextWithFont(`\n${datFac.tipoAfiliacion}\n`, "", fontM);
		else
			return sunmiInnerPrinter.printTextWithFont("\nRECIBO\n", "bold", fontM);
	})
	.then(()=>{
		if (val.tipoTransaccion == 1)
		return sunmiInnerPrinter.printTextWithFont(`DOCUMENTO ELECTRONICO\n${datFac.leyendaFEL}\nNumero Autorizacion\n${autorizacioFEL}\nFecha Certificacion : ${ datFac.FechaEmisionFEL}\nDIGIFACT Servicios \n NIT: 77454820\n\n`,"",fontS);
		else
			return sunmiInnerPrinter.printTextWithFont("- DOCUMENTO NO CONTABLE -\n", "", fontS);
		
	})
	.then(()=>{
		return sunmiInnerPrinter.setAlignment(0);
	})
	.then(()=>{
		if (val.tipoTransaccion == 1)
			return sunmiInnerPrinter.printTextWithFont(`Serie: ${datFac.serie}\nNumero: ${datFac.correlativo}\nFecha Emision: ${datFac.FechaFactura}\nNIT: ${datFac.nitCliente}\nNombre: ${datFac.nombreCliente}\n`, "", fontS);
		else
			return sunmiInnerPrinter.printTextWithFont(`\n`, "", fontS);
	})
	.then(()=>{
		if (val.tipoTransaccion == 1)
			return sunmiInnerPrinter.printTextWithFont(`\nVendedor: ${datFac.userName}\n\n`, "", fontS);
		else
			return true;
	})
	.then(()=>{
		return sunmiInnerPrinter.printColumnsText(texto, tamano, alineamiento);
	})
	.then(()=>{
		// ! Agregar impresion de opciones por producto
		var i = 0;
		while (detVenta[i]) {
			let item = detVenta[i];
			let producto = [
				parseFloat(item.Cantidad),
				item.DescCorta,
				moneda + item.PrecioUnitario,
				moneda + item.Total];
			i++;
			sunmiInnerPrinter.printerInit()
			.then(() => {
				return sunmiInnerPrinter.printColumnsText(producto, tamano, alineamiento);
			});
			
		}

		return sunmiInnerPrinter.setAlignment(0);
	})
	.then(()=>{
		tamano = [col2A, col2B];
		alineamiento = [2, 2];
		if(datFac.descuento > 0){
			let subTotal = parseFloat(datFac.total) + parseFloat(datFac.descuento);
			return sunmiInnerPrinter.printColumnsText(["Sub-Total", moneda + subTotal], tamano, alineamiento);
		}
		else
			return sunmiInnerPrinter.setAlignment(0);
	})
	.then(()=>{
		if(datFac.descuento > 0)
			return sunmiInnerPrinter.printColumnsText(["Descuento", "-" + moneda + datFac.descuento], tamano, alineamiento);
		else
			return sunmiInnerPrinter.setAlignment(0);
	})
	.then(()=>{
		texto = ["Total", moneda + datFac.total];
		return sunmiInnerPrinter.printColumnsText(texto, tamano, alineamiento);
	})
	.then(()=>{
		return sunmiInnerPrinter.setAlignment(1);
	})
	.then(()=>{
		return sunmiInnerPrinter.printTextWithFont("\npowered by Proper\nwww.somosproper.com\n\n\n", "", fontS);
	})
	.then(() =>{
		if (footerFEL == "") {
			return sunmiInnerPrinter.printTextWithFont("\n\n\n", "", fontS);
		}
		else{
			return sunmiInnerPrinter.printTextWithFont(`IMPORTANTE\n`, "", fontM);
		}
	})
	.then(()=>{
		return sunmiInnerPrinter.setAlignment(1);
	})
	.then(() =>{
		if (footerFEL == "") {
			return sunmiInnerPrinter.printTextWithFont("\n", "", fontS);
		}
		else{
			return sunmiInnerPrinter.printTextWithFont(`${footerFEL}\n\n\n\n`, "", fontS);
		}
	})
	.then(()=>{
		if(hasCutter)
			return sunmiInnerPrinter.cutPaper();		
		else
			return true;
	})
	.then(()=>{
		if(localStorage.isMobile != 'true' && val.openCashDrawer){

			sunmiInnerPrinter.openDrawer();
			return true;
		}
		else
			return true;
	})
	.then(()=>{
		
		if(usaComandas && pagina == "main"){
			Swal.fire({
				icon: 'warning',
				iconHtml: '<a class="btn-floating btn-large pulse amber darken-2"><i class="medium material-icons pulse">content_cut</i></a>',
				backdrop: false,
				showCloseButton: false,
				confirmButtonText: 'Comandar',
				html: '&#191;Continuar con impresi&#243;n de comanda?'
			}).then((result) => {
				if(result){
					tamano = [5, 25];
					alineamiento = [2, 0];

					sunmiInnerPrinter.printerInit()
					.then(() => {
						return sunmiInnerPrinter.setAlignment(0);
					})
					.then(() => {
						return sunmiInnerPrinter.printTextWithFont(`COMANDA # ${datFac.correlativo}\n`, "", fontL);
					})
					.then(() => {
						return sunmiInnerPrinter.setAlignment(1);
					})
					.then(()=>{
						return sunmiInnerPrinter.printTextWithFont(`${prntlinea}\n`, "", fontL);
					})
					.then(()=>{
						return sunmiInnerPrinter.printColumnsText(["Cant.", "Descrip."], tamano, alineamiento);
					})
					.then(()=>{
						return sunmiInnerPrinter.setAlignment(0);
					})
					.then(()=>{
						var j = 0;
						while (detVenta[j]) {
							let item = detVenta[j];
							let producto = [parseFloat(item.Cantidad), item.DescCorta];
							j++;
							sunmiInnerPrinter.printerInit()
							.then(() => {
								return sunmiInnerPrinter.printColumnsText(producto, tamano, alineamiento);
							});
							// print item.subopciones
						}
						return sunmiInnerPrinter.setAlignment(1);
					})
					.then(()=>{
						return sunmiInnerPrinter.printTextWithFont(`\n\n\n\n\n\n\n${prntlinea}\n`, "", fontL);
					})
					.then(()=>{
						if(hasCutter)
							return sunmiInnerPrinter.cutPaper();		
						else
							return true;
					})
					.then(()=>{
						if(pagina == 'main' || pagina == 'mobileShop' || pagina == 'pumpStation')
							location.reload();
					});
				}
				
			});
		}
		else{
			if(pagina == 'main' || pagina == 'mobileShop' || pagina == 'pumpStation')
				location.reload();
		}
	});

	
    
}

// ! Adecuar a formato de impresion
// Imprime un resumen de las ventas del dia
// TODO: Evaluar si se pasa solo a la pagina de transacciones (para poder imprimer de cualquier dia segun el filtro)
function lecturaCaja() {
	params = {
		service: "lecturaCaja",
		dbName: dbName,
		idUsuarios: localStorage.idUsuarios,
	};
	$.post(host, params, function (data) {
			var formato = `RESUMEN DE CAJA\n`;
			var total = 0;
			$.each(data, function (key, val) {
				if (key === 0) {
					formato += `NIT: ${val.nit}\n`;
					formato += `${val.Empresa}:\n`;
					formato += `${val.Sucursal}:\n`;
					formato += `CAJERO: ${val.Usuario}\n`;
					formato += `\n`;
				}
				if (key === 0) {
					total = val.total;
					formato += ` - - - - - - - RESUMEN - - - - - - - -\n`;
					formato += `APERTURA: ${val.FechaApertura}\n`;
					formato += `CORTE: ${val.FechaEmision}\n`;
					formato += `FONDO DE CAJA: Q. ${val.Apertura}\n`;
					formato += `NO. TRANSACCIONES: ${val.TotalTransacciones}\n`;
					formato += `......................................\n`;
					formato += ` - - - - - DETALLE DE VENTAS - - - - -\n`;
				}
				//
				let sub = (Math.round(val.total * 100) / 100).toFixed(2);
				formato += `${val.tipoTransaccion}(${val.Transacciones})            Q. ${sub}\n`;
			});

			total = (Math.round(total * 100) / 100).toFixed(2);
			formato += `TOTAL VENTAS: Q. ${total}\n`;
			formato += `......................................\n`;
			formato += `\n`;
			formato += `\n`;
			formato += `f.....................................\n`;
			formato += `FIRMA CAJERO\n`;
			formato += `\n`;
			formato += `\n`;
			formato += `\n`;
			formato += `f.....................................\n`;
			formato += `FIRMA SUPERVISOR\n`;
			formato += `\n`;
			formato += `\n`;
			formato += `\n`;
			//IMPRESION
			sunmiInnerPrinter.setAlignment(0);
			sunmiInnerPrinter.printTextWithFont(`${formato}`, "Arial", 20);
			sunmiInnerPrinter.sendRAWData("HVZCAA==");
			//console.log(formato);
		}, "json").done(function () {
		window.location = "main.html";
	});
}

// Impresion por medio de app local-printer (NODE JS)
function localPrinter(params, pService) {
	console.log(params);
	params.service = pService;

	var settings = {
		url: "http://localhost/",
		method: "POST",
		timeout: 0,
		headers: {
			"Content-Type": "application/json",
		},
		data: JSON.stringify(params),
		dataType: "json",
	};

	$.ajax(settings)
		.done(function (response) {
			console.log(response);
			if(pService == "printNCRE"){
				window.location = "transacciones.html";
			}else{
				location.reload();
			}
		})
		.fail(function () {
			console.log(params);
			if(pService == "printNCRE"){
				window.location = "transacciones.html";
			}else{
				location.reload();
			}
		});
}