$(document).ready(function() {
    resizeDOMHeights();
    getDatosVenta();
    insertItemsVenta();
	getDocumentoFacturacion();

    $('#modalCuenta').modal({
		"inDuration": 0,
		"outDuration": 0
	});

    //Inicializa el switch de Recibo/Factura
	$("#chkTipoTransaccion").change(function () {
		if ($(this).is(":checked")) {
			if(!$('#tipoVenta').is(":checked")){
				$("#nit").val($("#NITOrigen").val());
				$("#nombre").val($("#nombreOrigen").val());
				$("#direccion").val($("#direccionOrigen").val());
			}else{
				$("#divReferencia").slideDown();
			}
			$("#divNIT").slideDown();
			$("#divDireccion").slideDown();
		} else {
			if(!$('#tipoVenta').is(":checked")){
				$("#nit").val($("#NITOrigen").val());
				$("#direccion").val($("#direccionOrigen").val());
			}else{
				$("#divReferencia").slideUp();
			}
			$("#divNIT").slideUp();
			$("#divDireccion").slideUp();
			$("#nombre").attr("readonly", false);
		}

		
	});

	$("#tipoVenta").change(function () {
		if ($(this).is(":checked")) {
			//Crédito:
			$("#btnCobrar").removeClass("disabled");
			$("#btnCobrar").addClass("pulse");
		} else {
			//Contado:
			$('#btnCobrar').addClass('disabled');
			$("#btnCobrar").removeClass("pulse");
		}
	});

}); 

function delay(callback, ms) {
    var timer = 0;
    return function() {
      var context = this, args = arguments;
      clearTimeout(timer);
      timer = setTimeout(function () {
        callback.apply(context, args);
      }, ms || 0);
    };
}

function returnMovimientos(){
    window.location = "transacciones.html";
}

function getDatosVenta(){
    $("#loader").show();
    $("#notaVenta").empty();
    console.log(sessionStorage.idNota);
    params = {
        service: 'getDatosVenta',
        dbName: dbName,
        idVenta: sessionStorage.idNota
    };
    $.post(host, params, function(data) {
        let content = "";
		let count = 0;
        $.each(data, function (key, val) {
            console.log(val);
            let venta = val.data;
	        let ventaDetalles = val.detalle;
            // construir los encabezados con venta.
            content += `<h5><b>Serie:</b> ${venta.serie}, <b>Correlativo: </b>${venta.correlativo}, <b>Autorizacion FEL:</b> ${venta.autorizacionFEL}</h5>
            <h5><b>Nombre: </b>${venta.nombre}, <b>NIT: </b>${venta.nit}, <b>Fecha: </b>${venta.created_at}</h5>`;

            $("#serieOrigen").val(venta.serie);
            $("#correlativoOrigen").val(venta.correlativo);
            $("#autorizacionFELOrigen").val(venta.autorizacionFEL);
            $("#fechaOrigen").val(venta.fechaFactura);
			$("#NITOrigen").val(venta.nit);
			$("#nombreOrigen").val(venta.nombre);
			$("#direccionOrigen").val(venta.direccion);

			$("#totalOrigen").val(venta.total);

			$.each(val.detalle, function (key, val) {
				count++;
			});

        });
		$("#totalItems").val(count);
		console.log($("#totalItems").val());
        $("#notaVenta").html(content);
    }, "json").done(function(){
        $("#loader").hide();
    });
    // consumir servicio para obtener la informacion de la venta

}
//* Trae la lista de productos que fueron vendidos.
function insertItemsVenta(){
	params = {
        service: 'insertItemsVenta',
        dbName: dbName,
        idVenta: sessionStorage.idNota
    };
    $.post(host, params, function(data) {
        $.each(data, function (key, val) {
        });
    }, 'json').done(function(){
        getItemsVenta();
    });
}

//* Trae la lista de productos que fueron vendidos.
function getItemsVenta(){
	$("#tableItemsVenta tbody").empty();
	params = {
        service: 'getItemsVenta',
        dbName: dbName,
        idVenta: sessionStorage.idNota
    };
    $.post(host, params, function(data) {
		let carrito = ``;
        var total = 0;
		var total2 = 0;
		if (data === null){
            $("#totalItems").val(0);
			$("#total").val(0);
			carrito =`<td colspan="5" style="text-align:center;">0 registros encontrados para esta venta</td>`;
		}else{
			$.each(data, function (key, val) {
                total += accounting.unformat(val.total);
				total2 += accounting.unformat(val.cantidad);
				carrito += `
				<tr id="${val.id}">
					<td onclick=""><label>
                    <input type="checkbox" id="checkItem${val.id}" class="filled-in" checked="checked" style="position: relative;"/><span></span></label></td>
					<td><input id="cant${val.id}" min="1" type="number" style="width: 100px; border-bottom: none !important;"/></td>
					<td><input id="desc${val.id}" type="text" style="border-bottom: none !important;"/></td>
					<td><input id="totalPrecio${val.id}" min="1" type="number" style="width: 100px; border-bottom: none !important;"/></td>
					<td><input id="valorMonto${val.id}" class="valorMonto checkItemVal" type="number" style="width: 100px;border-bottom: none !important;" readonly /></td>
				</tr>`;
			});
            $("#totalItems").val(total2);
		    $("#total").val(total);
		}
		$("#tableItemsVenta tbody").html(carrito);

		//Llena los campos de la tabla
		$.each(data, function (key, val) {
			$(`#cant${val.id}`).val(accounting.formatNumber(val.cantidad,2));
			$(`#desc${val.id}`).val(val.descLarga);
			$(`#totalPrecio${val.id}`).val(accounting.formatNumber(val.precio,2));
			$(`#valorMonto${val.id}`).val(val.total);

			$(`#desc${val.id}`).on("keyup", delay(function() {
				var input = $(this).val();
				if(input.length >= 3){
					guardarDetCambios(val.id,$(`#cant${val.id}`).val(),input,$(`#totalPrecio${val.id}`).val(),$(`#valorMonto${val.id}`).val());
				}
			}, 1500));

            $(`#checkItem${val.id}`).change(function() {
                getTotalesItems();       
            });

			$(`#totalPrecio${val.id}`).on("keyup", delay(function() {
				var input = $(this).val();
				if(input.length >= 1){
					let valor = input;
					let contador = $(`#cant${val.id}`).val();
					valor = valor * contador;
					$(`#valorMonto${val.id}`).val(valor);
					guardarDetCambios(val.id,$(`#cant${val.id}`).val(),$(`#desc${val.id}`).val(),input,$(`#valorMonto${val.id}`).val());
				}
			}, 1500));
			
			$(`#cant${val.id}`).on("keyup", delay(function() {
				var input = $(this).val();
				if(input.length >= 1){
					let valor = $(`#totalPrecio${val.id}`).val();
					let contador = input;
					valor = valor * contador;
					$(`#valorMonto${val.id}`).val(valor);
					guardarDetCambios(val.id,input,$(`#desc${val.id}`).val(),$(`#totalPrecio${val.id}`).val(),$(`#valorMonto${val.id}`).val());
				}
			}, 1500));
		});
    }, 'json').done(function(){
        getTotalesItems();
    });
}


function getTotalesItems(){
    var total = 0;
	var total2 = 0;
    $(".checkItemVal").each(function (index) {
        //replace valorMonto x checkItem para evaluar si esta checked y contarlo...
        let ide = $(this).attr('id');
        ide = ide.replace("valorMonto","checkItem");
        if ($(`#${ide}`).is(":checked")) { // revisar que el mismo id este check
            ide = $(this).attr('id');
            ide = ide.replace("checkItem","valorMonto");
            total += accounting.unformat($(`#${ide}`).val());
        }
    });
    
    $("#total").val(total);
    var summary = `<tr style="background-color: #263238 !important;color:  #FFF !important;border: 0 !important;">
        <td colspan="3"></td>
        <td>Total Q</td>
        <td id="totalFacturacion1">${accounting.formatNumber(total,2)}</td>
        <input type="hidden" id="totalFacturacion" value="${total}" />
        
    </tr>`;
    $("#tableItemsVenta tfoot").html(summary);
}

//Guarda los campos de la tabla si es que se modificaron;
function guardarDetCambios(id,cant,desc,precio,valor){
	var descripcion = desc.replace(/[_\W]+/g, " ");
	var cantidad = cant;
	if (cant < 0 || cant == "" || precio < 0 || precio == "" || descripcion == ""){
		Swal.fire({
			text: `Introduzca un valor valido`,
			icon: "warning",
			confirmButtonColor: "#3085d6",
			confirmButtonText: "Ok",
		}).then((result) => {});
	}else{
		params = {
			service: "guardarDetCambios",
			dbName: dbName,
			idSucursales: localStorage.idSucursales,
			idUsuarios: localStorage.idUsuarios,
            idEmpresas: localStorage.idEmpresas,
			id: id,
			desc: descripcion,
			cant: cantidad,
			precio: precio,
			valor: valor,
			fardos: 0
		};
		$.post(host, params, function (data) {
		}, "json").done(function () {
            getTotalesItems();
		});
	}
}

function itemsBorrar(){
	if ($("#totalFacturacion").val() <= 0) {
		Swal.fire({
			html: 'No tiene articulos seleccionados',
			timer: 2000,
			timerProgressBar: true,
			confirmButtonColor: "#ff8f00",
			confirmButtonText: "Aceptar",
		}).then((result) => {
		
		});
	}else if( parseFloat($("#totalFacturacion").val()) > parseFloat($("#totalOrigen").val())){
		Swal.fire({
			html: 'El total sobrepasa el valor de la factura original',
			timer: 2000,
			timerProgressBar: true,
			confirmButtonColor: "#ff8f00",
			confirmButtonText: "Aceptar",
		}).then((result) => {
		
		});
	}else{
		var items = 0;
		$(".checkItemVal").each(function (index) {
			items++;
			let ide = $(this).attr('id');
			ide = ide.replace("valorMonto","checkItem");
			if (!$(`#${ide}`).is(":checked")) { // revisar que el mismo id este check
				ide = ide.replace("checkItem","");
				params = {
					service: 'itemsBorrar',
					dbName: dbName,
					id: ide
				};
				$.post(host, params, function(data) {
					$.each(data, function (key, val) {
					});
				}, 'json').done(function(){
				});
			}
			if(items == parseFloat($("#totalItems").val())){
				notaCredito();
			}
		});
		//notaCredito();
	}
}


function abrirModal() {
	//Restablece los valores por default para los botones y campos.
	$("#modalCuenta").css("height","unset");
	$("#nombre").val($("#nombreOrigen").val());
	$("#nit").val($("#NITOrigen").val());
	$("#direccion").val($("#direccionOrigen").val());
	console.log($("#nit").val());
	$("#tipoVenta").prop("checked", false).change();
	$("#divNumPadCobro").empty();
	$("#divNumPadNIT").empty();
		//Validacion para caso de carrito vacío
		if ($("#totalFacturacion").val() <= 0 ) {
			Swal.fire({
				html: 'No tiene articulos seleccionados',
				timer: 2000,
				timerProgressBar: true,
				confirmButtonColor: "#ff8f00",
				confirmButtonText: "Aceptar",
			}).then((result) => {
				if(localStorage.isMobile == "true"){
					showCarrito();
				}
			});
		} else {
            if($("#tipoMoneda").val() == "2"){
                $('.divEfectivo').hide();
                $('.divVisa').hide();
                $('.divBac').hide();
                $('.divDolares').show();
            }
            else{
                $('.divDolares').hide();
                $('.divEfectivo').show();
                $('.divVisa').show();
                $('.divBac').show();
            }
            $("#modalCuenta").modal("open");


			if(localStorage.touchEnabled == "false"){
				$("#TxtNumPad").removeAttr('disabled');
				$("#TxtNumPad").focus();
			}
			else{
				createNumPad("divNumPadCobro", "TxtNumPad", ".", "percentage", "");
				createNumPad("divNumPadNIT", "nit", "K", "", "");
			}

			$("#TxtNumPad").attr("placeholder", "");
			$("#TxtTotal").val(0.0);
			$(".formasPago").val("");
			$("#TxtNumPad").val("");
			$("#nit").val("");
			$("#divFacturar").hide();
			$("#searchClient").hide();
			$("#divFormasPago").show();

			if (!$("#btnCobrar").hasClass("disabled")) {
				$("#btnCobrar").addClass("disabled");
				if(localStorage.isMobile == 'false')
					$("#btnCobrar").removeClass("pulse");
			}

			if ($("#tipoMoneda").val() == "2"){ //Si es Dolar:
				$("#totalFactura").val(accounting.formatNumber($("#totalDolares").val(), 2));
				$("#TxtSaldo").val(accounting.formatNumber($("#totalDolares").val(), 2));
			}else{
				$("#totalFactura").val(accounting.formatNumber($("#total").val(), 2));
				$("#TxtSaldo").val(accounting.formatNumber($("#total").val(), 2));
			}
			$('#btnFinNota').removeAttr('disabled');
		}

}

function notaCredito() {
	$('#btnFinNota').attr('disabled', 'disabled');
	$("#loader").show();

	$("#nombre").val($("#nombreOrigen").val());
	$("#nit").val($("#NITOrigen").val());
	$("#direccion").val($("#direccionOrigen").val());

	$("#totalFactura").val($("#totalFacturacion").val());

	try {
		var flag = true;
		var errorMsg = "Corrige los siguiente errores:\n";
		let chkTipTrans = $("#chkTipoTransaccion").prop("checked");

		if(!emitirRecibo){
			chkTipTrans = true;
		}

		var nitExtranjero;
        var nit;
        //Validacion para NIT si no se permite NIT Extranjero.
        if (nitExt == false ){
            if (chkTipTrans) {
                if (!$("#nit").val()) {
                } else if ($("#nit").hasClass("invalid")) {
                    errorMsg = "Debe ingesar un NIT valido";
                    flag = false;
                }
            }
        }

		var tipoVenta;
		var anticipo;
		if($('#tipoVenta').is(":checked")){
			tipoVenta = 1;
			anticipo = accounting.unformat($("#TxtTotal").val());
		}else{
			tipoVenta = 0;
			anticipo = 0;
		}

		if (flag === false) {
			Swal.fire({
				html: errorMsg,
				icon: "warning",
				confirmButtonColor: "#3085d6",
				confirmButtonText: "Ok",
			}).then((result) => {});
			$("#loader").hide();
			$('#btnFinNota').removeAttr('disabled');
			return false;
		} else {
			var detalle = [];
			$(".formasPago").each(function (index) {
				if (accounting.unformat($(this).val()) != 0) {
					var arr = {};
					arr["idFormasPago"] = $(this).data("type");
					arr["idEmisor"] = $(this).data("emisor");
					arr["valor"] = accounting.unformat($(this).val());
					detalle.push(arr);
				}
			});
		
			if ($('#tipoVenta').is(":checked") && detalle.length == 0){
				var arr = {};
				arr["idFormasPago"] = 4;
				arr["idEmisor"] = 0;
				arr["valor"] = accounting.unformat($("#TxtSaldo").val());
				detalle.push(arr);
			}

			if ($("#nit").hasClass("invalid")){
                if (nitExt == true ){
                    nit = "CF";
                    nitExtranjero = $("#nit").val();
                }
            }else{
                nit = $("#nit").val();
                nitExtranjero = "0";
            }
			
			var descuento = accounting.unformat($("#totalDescontado").val());
			var subtotal = accounting.unformat($("#subtotalVenta").val()); 

			var totalFactura = accounting.unformat($("#totalFactura").val());
			var iva = accounting.unformat(((totalFactura / 1.12) * 0.12 * 100) / 100);
			var total = accounting.unformat(totalFactura - iva);
			
			//var nit = !$("#nit").val() ? "CF" : $("#nit").val();
			if(!$("#nit").val()){
                nit = "CF";
                nitExtranjero = "0";
            }
			var nombre = !$("#nombre").val() ? "Consumidor Final" : $("#nombre").val();
			var direccion = !$("#direccion").val() ? "Consumidor Final" : $("#direccion").val();

			//var openCash = (accounting.unformat($("#TxtEfectivo").val()) > 0)? true : false;
			let pagoCash = accounting.unformat($("#TxtEfectivo").val()) + accounting.unformat($("#TxtDolares").val());
			var openCash = (pagoCash > 0)? true : false;

			if ($("#tipoMoneda").val() == "2"){ //Si es Dolar:
				var codigoMoneda = "USD";
				$("#total").val("0.00");
			}else{
				var codigoMoneda = "GTQ";
				$("#totalDolares").val("0.00");
			}

			let vendedor = $('#idVendedor').val();

			params = {
				service: "finalizarNotaCredito",
				dbName: dbName,
				urlFEL: urlFEL,
				tokenFEL: tokenFEL,
				idVendedor: vendedor,
				idUsuarios: localStorage.idUsuarios,
				idSucursales: localStorage.idSucursales,
				idEmpresas: localStorage.idEmpresas,
				totalFactura : totalFactura,
				total: accounting.unformat($("#total").val()),
				nombre: nombre,
				nit: nit,
				direccion: direccion,
				subtotal: subtotal,
				descuentoM: descuento,
				descuentoP: 0,
				anticipo: anticipo,
				saldo: accounting.unformat($("#TxtSaldo").val()),
				iva: iva,
				tasaCambio: 0,
				totalDolares: accounting.unformat($("#totalDolares").val()), //Guardar el total (con descuento) de Dolares
				tipoVenta: tipoVenta,
				idDocumento: $("#idDocumento").val(),
				serie: $("#serie").val(),
				correlativo: $("#correlativo").val(),
				documento: $("#facutra").val(),
				tipoTransaccion: chkTipTrans ? 2 : 0,
				detalle: detalle,
				codigoMoneda: codigoMoneda,
				nitExt: nitExtranjero,
                idVenta: sessionStorage.idNota,
                serieOrigen: $("#serieOrigen").val(),
                correlativoOrigen: $("#correlativoOrigen").val(),
                fechaOrigen: $("#fechaOrigen").val(),
                autorizacionFELOrigen: $("#autorizacionFELOrigen").val(),
			};

			console.log(params);
			$.post(host, params, function (data) {
					$.each(data, function (key, val) {
						switch (val.message) {
							case "success":
								//alert(val.error);
                                console.log(data);
								printerNotaCredito(val.idVenta, params.tipoTransaccion, openCash, 0);
								// if($('#tipoVenta').is(":checked")){
								// 	guardarSaldoActual();
								// }
								break;
							case "docExists":
								alert("Correlativo de documento ya existe en el sistema");
								break;
							default:
								alert(val.error);
								break;
						}
					});
				}, "json").done(function () {
				$("#loader").hide();
				$('#btnFinNota').removeClass('disabled');
			});
		}
	} catch (err) {
		Swal.fire({
			html: err.message,
			icon: "error",
			confirmButtonColor: "#3085d6",
			confirmButtonText: "Ok",
		}).then((result) => {});
		$("#loader").hide();
		return false;
	}
}

function calcTotal(param) {
	let valSaldo = parseFloat(accounting.unformat($("#TxtSaldo").val()));
	let valTotalFactura = parseFloat(
		accounting.unformat($("#totalFactura").val()),
	);

	// Valida que la cantidad ingresada sea mayor a 0
	if($("#TxtNumPad").val() < 0 ){
		Swal.fire({
		icon: "warning",
		text: "Debe ingresar un monto valido.",
		showCloseButton: true,
		confirmButtonText: "Intentar de nuevo",
		html: "Debe ingresar un monto valido.",
	});
	}else{
		if (valSaldo > 0) {
			let valDolares = 0;
			let valNuevo = parseFloat($("#TxtNumPad").val());
			let valAnterior = parseFloat($("#" + param).val());

			// TODO: Para cobrar en dolares (no facturar en dolares)
			

			valNuevo = isNaN(valNuevo) ? valSaldo : valNuevo;
			valAnterior = isNaN(valAnterior) ? 0 : valAnterior;

			if (param == "TxtEfectivo" || param == "TxtDolares") {
				$("#TxtNumPad").attr("placeholder", "");

				if (valNuevo >= valSaldo) {
					let restante = valNuevo - valSaldo;
					valNuevo = valSaldo;
					valSaldo = accounting.formatNumber(0, 2);

					// if(param == 'TxtDolares'){
					// 	restante = accounting.formatNumber(restante * 7.5, 2);
					// }
					// else{
					// 	restante = accounting.formatNumber(restante, 2);
					// }
					restante = accounting.formatNumber(restante, 2);
					$("#TxtNumPad").attr("placeholder", `Cambio: ${restante}`);
				}
			} else {
				valNuevo = valNuevo > valSaldo ? valSaldo : valNuevo;
			}

			valNuevo = valNuevo + valAnterior;
			$("#" + param).val(accounting.formatNumber(valNuevo, 2));

			// if(param == "TxtDolares"){
			// 	$("#" + param).val(accounting.formatNumber(valDolares, 2));
			// }
			// else{
			// 	$("#" + param).val(accounting.formatNumber(valNuevo, 2));
			// }
			
			let efectivo = parseFloat(accounting.unformat($("#TxtEfectivo").val()));
			let dolares = parseFloat(accounting.unformat($("#TxtDolares").val()));
			//let dolares = valNuevo;
			let visa = parseFloat(accounting.unformat($("#TxtVisa").val()));
			let bac = parseFloat(accounting.unformat($("#TxtBac").val()));
			let descuento = parseFloat(accounting.unformat($("#TxtDescuento").val()));

			efectivo = isNaN(efectivo) ? 0 : efectivo;
			dolares = isNaN(dolares) ? 0 : dolares;
			visa = isNaN(visa) ? 0 : visa;
			bac = isNaN(bac) ? 0 : bac;
			descuento = isNaN(descuento) ? 0 : descuento;
			// ! Multiplicar por tipo de cambio del dia para Cobro multiple con dolares
			// ! dolares = dolares * cambio;
			let valTotal = efectivo + visa + bac + descuento + dolares;
			$("#TxtTotal").val(accounting.formatNumber(valTotal, 2));

			valTotalFactura = isNaN(valTotalFactura) ? 0 : valTotalFactura;

			valSaldo = valTotalFactura - valTotal;
			$("#TxtSaldo").val(accounting.formatNumber(valSaldo, 2));

			$("#TxtNumPad").val("");

			if (valSaldo == 0 || $('#tipoVenta').is(":checked")) {
				if(localStorage.isMobile == 'false'){
					if ($("#btnCobrar").hasClass("disabled")) {
						$("#btnCobrar").removeClass("disabled");
						$("#btnCobrar").addClass("pulse");
					}
				}
				else{
					let attr = $('#btnCobrar').attr('disabled');
					if(typeof attr !== typeof undefined && attr !== false){
						$('#btnCobrar').removeAttr('disabled');
					}
				}
			}
			else{
				if(localStorage.isMobile == 'false'){
					if (!$("#btnCobrar").hasClass("disabled")) {
						$("#btnCobrar").addClass("disabled");
						$("#btnCobrar").removeClass("pulse");
					}
				}
				else{
					let attr = $('#btnCobrar').attr('disabled');
					if(typeof attr == typeof undefined || attr == false){
						$('#btnCobrar').attr('disabled','""');
					}
				}
			}
		}
	}
	
}

function resetCuenta() {
	$("#TxtSaldo").val($("#totalFactura").val());
	$("#TxtNumPad").attr("placeholder", "");
	$("#TxtEfectivo").val("");
	$("#TxtDolares").val("");
	$("#TxtVisa").val("");
	$("#TxtBac").val("");
	$("#TxtDescuento").val("");
	$("#TxtTotal").val(0.0);

	if(localStorage.isMobile == 'false'){
		if (!$("#btnCobrar").hasClass("disabled")) {
			$("#btnCobrar").addClass("disabled");
			if(localStorage.isMobile == 'false')
				$("#btnCobrar").removeClass("pulse");
		}
	}
	else{
		let attr = $('#btnCobrar').attr('disabled');
		if(typeof attr == typeof undefined || attr == false){
			$('#btnCobrar').attr('disabled','""');
		}
	}
	
}

function tipoDeVenta(){
	if ($('#tipoVenta').is(":checked")) {
		$("#loader").show();
		modalCredito();
	} else {
		confirmCompra();
	}
}

function modalCredito(){
	$("#loader").hide();

	$('#modalCuenta').css('height','60%');
	$('#btnCobrar').addClass('disabled');
	$("#btnCobrar").removeClass("pulse");

	//Creacion del modal para venta en Credito
	$("#divFormasPago").slideUp();
	$("#searchClient").slideDown(); 
	$("#iCloseModal1").attr("onclick","cerrarModal();");

	getClientes();
}

function confirmCompra() {
	let visa = $("#TxtVisa").val();
	let bac = $("#TxtBac").val();

	if (emitirRecibo == false){
		$("#chkTipoTransaccion").prop("checked", true).change();
		$("#chkTipoTransaccion").attr("disabled", "disabled");
	} else if (facturaDefault == true) {
		$("#chkTipoTransaccion").prop("checked", true).change();
	} else {
		if (visa > 0 || bac > 0) {
			$("#chkTipoTransaccion").prop("checked", true).change();
			$("#chkTipoTransaccion").attr("disabled", "disabled");
		} else {
			$("#chkTipoTransaccion").prop("checked", false).change();
			$("#chkTipoTransaccion").removeAttr("disabled", "disabled");
		}
	}

	if(localStorage.isMobile == 'true'){
		showFacturacion();
	}
	else{
		$("#modalCuenta").css("height","unset");
		$("#searchClient").slideUp();
		$("#divFormasPago").slideUp();
		$("#divFacturar").slideDown();
		if(localStorage.touchEnabled == "false"){
			$("#nit").focus();
		}
	}
	
}

// Obtiene el correlativo del siguiente documento a emitir 
function getDocumentoFacturacion() {
	params = {
		service: "getDocumentoFacturacion",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idUsuarios: localStorage.idUsuarios,
	};
	$.post(host, params, function (data) {
			if (data !== null) {
				$.each(data, function (key, val) {
					$("#idDocumento").val(val.id);
					$("#serie").val(val.serie);
					$("#correlativo").val(val.correlativo);
				});
			}
		}, "json");
}

