$(document).ready(function () {
	aperturaCaja();
	getDocumentoFacturacion();

	if(!emitirRecibo)
		$('#divTipTrans').hide();

	
	//inicializar con tipo de moneda Quetzal
	$("#tipoMoneda").val("1");
	$("#tipoMoneda").change(function () {
		if ($(this).is(":checked")) {
			//console.log("dolar")
			$("#tipoMoneda").val("2");
			returnProductos();
		} else {
			$("#tipoMoneda").val("1");
			returnProductos();
			//console.log("quetzal")
		}
	});

});

//getProductos regresa los productos (sin categoria) y con precio en Q y precio $
function getProductos() {
    $("#txtScanner").focus();
	params = {
		service: "getProductos",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales,
	};
	$.post(host, params, function (data) {
		$("#productosMobile").empty();
		var component = ``;
		$.each(data, function (key, val) {
			let color = accounting.unformat(val.existencia) > 0 ? "light-green" : "deep-orange ";
			let icon = accounting.unformat(val.existencia) > 0 ? "check" : "clear";
			//let showIcon = val.idTipoProductos == 3 ? false : true;
			productoVenta = `agregarProductoVenta(${val.id},${accounting.unformat(val.existencia)},${val.idTipoProductos},'${val.descLarga}',1, ${val.precioPublico},0,${$("#precioDolar").val()},1);`;

			//De momento no se usa en el mobile
			if (pVariable && val.precioPublico == 0) {
				// swalPrecioPublico();
				productoVenta = `swalPrecioPublico(${
					val.id
				},${accounting.unformat(val.existencia)},${
					val.idTipoProductos
				},'${val.descLarga}',1);`;
			} else {
				productoVenta = `agregarProductoVenta(${
					val.id
				},${accounting.unformat(val.existencia)},${
					val.idTipoProductos
				},'${val.descLarga}',1, ${val.precioPublico},0,${$("#precioDolar").val()},1);`;
           	}
			if (val.menuOpcion != "No tiene Opcion"){
                component += `
				<div class="mdl-cell mdl-cell--12-col mdl-cell--12-col-phone">
				<div class="mdl-card mdl-shadow--2dp card shapedbox" onclick="opcionesProducto(${val.id},${accounting.unformat(val.existencia)},${val.idTipoProductos},'${val.descLarga}',${val.precioPublico},${val.precioDolar})" >
				<p class="nombre-card-Mobile">${val.descLarga.toLowerCase()}</p>
                    <div class="mdl-card__supporting-text">
                    <br> 
						<p class='truncate sku-card'>
							${val.sku}
						</p>`;
			} else {
                component += `
                <div class="mdl-cell mdl-cell--12-col mdl-cell--12-col-phone">
				<div class="mdl-card mdl-shadow--2dp card shapedbox"  onclick="modalAgregarProducto(${val.id},${accounting.unformat(val.existencia)},${val.idTipoProductos},'${val.descLarga}',${val.precioPublico},${val.precioDolar})" >
				<p class="nombre-card-Mobile">${val.descLarga.toLowerCase()}</p>
                    <div class="mdl-card__supporting-text">
                    <br> 
						<p class='truncate sku-card'>
							${val.sku}
						</p>`;
            }
                /*
				if (showIcon) {
					component += `<a class="btn-existencias btn-floating btn-flat btn-small waves-effect waves-light ${color}"><i class="material-icons">${icon}</i></a>`;
                }
                */
				//component += `<div style="float: right;">${val.menuOpcion}</div></br>`;
			component += `<p class='precio-card accent-color' style="font-size: large; margin-bottom: 0px !important;">`;

			if ($("#tipoMoneda").val() == "2"){ //Si es Dolar:
				component += `$${val.precioDolar}`;
			} else {
				component += `Q${val.precioPublico}`;			
			}
			component += `		</p>
							
							</div>
						</div>
					</div>`;
			});
			
			$("#productosMobile").append(component);
			$('#divTipMoneda').show();
		},
		"json",
	);
}

// Barra Search (version mobile)
$("#buscador").on("keyup", function() {
     var value = $(this).val().toLowerCase();
    $("#productosMobile div.mdl-cell").filter(function() {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
});

function modalAgregarProducto(id,existencia,idTipoProductos,descLarga,precioPublico,precioDolar){
	$("#loader").hide();
	$('#btnDespachar').hide();

	$('#btnBackTool').attr('onclick', 'returnProductos()');
	$('#btnBackTool').show();

	$('#divTipMoneda').hide();

	$('#productosMobile').empty();
	$('#productosMobile').height('100%');
	//var cantidad =  $("#contador").get(0).value;

	$("#idProducto").val(id);
	$("#existencia").val(existencia);
	$("#idTipoProductos").val(idTipoProductos);
	$("#descripcion").val(descLarga);
	
	//Se guardan valores en ambas monedas
	$("#precioPublico").val(accounting.formatNumber(precioPublico, 2));
	$("#precioDolar").val(accounting.formatNumber(precioDolar, 2));

	let agregarBody = `
		<div class="mdl-grid" style="font-size:20px">
			<div class="mdl-cell mdl-cell--2-col-phone">
				Precio: 
			</div>
			<div class="mdl-cell mdl-cell--2-col-phone">
				<input type="text" id="inputPrecio" value="" disabled="" class="big-numbers" style="width: 100%;">
			</div>
		</div>
		<div class="mdl-grid" style="font-size:20px">
			<div class="mdl-cell mdl-cell--2-col-phone">
				Cantidad: 
			</div>	
			<div class="mdl-cell mdl-cell--2-col-phone">
				<i class="medium material-icons" onclick="cantidad('remove')" 
				style="font-size: 40px;">indeterminate_check_box</i>
				<input class="big-numbers" type="text" id="contador" value="1" min="1" disabled="" style="text-align: center;width: 28%;">
				<i class="medium material-icons" onclick="cantidad('add')" 
				style="font-size: 40px;">add_box</i>
			</div>
		</div>
		<div class="mdl-grid" style="font-size:20px">
			<div class="mdl-cell mdl-cell--2-col-phone">
				Total: 
			</div>
			<div class="mdl-cell mdl-cell--2-col-phone">
				<input type="text" id="mTotal" disabled="" class="big-numbers" style="width: 100%;">
			</div>
		</div>
		<div class="mdl-grid" style="text-align: center;" id="divNumPadCantidad"></div>
		`;

	$('#productosMobile').append(agregarBody);
	createNumPad("divNumPadCantidad", "inputPrecio", ".", "", "confirm");
	$("#contador").val("1");

	//Se determina que valor se mostrara en el inputPrecio al agregar el producto

	let moneda = ($("#tipoMoneda").val() == "2")? "$":"Q";
	let precio = ($("#tipoMoneda").val() == "2")? precioDolar : precioPublico;
	$("#inputPrecio").val(accounting.formatMoney(precio, moneda, 2));
	$("#mTotal").val(accounting.formatMoney(precio, moneda, 2));

	$("#inputPrecio").change(function() {
		let total = accounting.unformat($("#inputPrecio").val());
		let contador = $("#contador").val();
		total = total * contador;		
		let moneda = ($("#tipoMoneda").val() == "2")? "$":"Q";
		$("#mTotal").val(accounting.formatMoney(total, moneda, 2));
		
	});
}

function cantidad(boton){
    let precio = accounting.unformat($("#inputPrecio").val());
	let contador = $("#contador").get(0).value;
    let int = parseInt(contador, 10);


    if (boton == 'add'){
        $("#contador").get(0).value = int +1;
    } else {
        $("#contador").get(0).value = int -1;
        if ($("#contador").get(0).value < 1){
            $("#contador").get(0).value = 1;
        }
	}
	let moneda = ($("#tipoMoneda").val() == "2")? "$":"Q";
	let total = $("#contador").get(0).value * precio;
	$("#mTotal").val(accounting.formatMoney(total, moneda, 2));
}

function drawDetalles(){

	let agregarBody = `
	<div class="mdl-cell mdl-cell--12-col mdl-cell--12-col-phone" style="font-size:25px;text-align: center;font-weight:bold;">
		<div class="" style="padding-bottom: 15px;">
			Vendedor 
		</div>	
		<div class="" style="padding-bottom: 15px;">
			<select id="selectVendedor" style="width:80%;height:34px;">
			</select>
		</div>
		<div class="" style="padding-bottom: 15px;">
			Estaci&#243;n
		</div>	
		<div class="" style="padding-bottom: 15px;">
			<select id="selectMaquina" style="width:80%;height:34px;">
			</select>
		</div>
		<div class="" style="padding-bottom: 15px;">
			Aerol&iacute;nea
		</div>	
		<div class="" style="padding-bottom: 15px;">
			<select id="selectAerolinea" style="width:80%;height:34px;">
			</select>
		</div>
	</div>`;
		
	$('#productosMobile').append(agregarBody);
	
	getVendedores();
	getMaquinas();
	getAerolineas();
}

function getVendedores(){
	$("#loader").show();

	params = {
		service: "getVendedores",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};
	$.post(host, params, function (data) {
		let vendedores = "";
		$.each(data, function (key, val) {
			vendedores += `<option value="${val.id}">${val.userName}</option>`;
		});
		$("#selectVendedor").append(vendedores);
		//$("#selectVendedor").val($("#vendedor").val());
		//$('select').formSelect();
	}, "json").done(function(){
		$("#loader").hide();
	});

}

function getMaquinas(){
	$("#loader").show();

	params = {
		service: "getMaquinas",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};

	$.post(host, params, function (data) {
		let maquinas = "";

		$.each(data, function (key, val) {
			maquinas += `<option value="${val.id}">${val.nombre}</option>`;
		});

		$("#selectMaquina").append(maquinas);
		//$("#selectMaquina").val($("#maquina").val());
		//$('select').formSelect();
	}, "json").done(function(){
		$("#loader").hide();
	});
}

function getAerolineas(){
	$("#loader").show();

	params = {
		service: "getAerolineas",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};

	$.post(host, params, function (data) {
		let aerolineas = "";
		$.each(data, function (key, val) {
			aerolineas += `<option value="${val.id}">${val.aerolineas}</option>`;
		});
		$("#selectAerolinea").append(aerolineas);
		//$("#selectAerolinea").val($("#aerolinea").val());
		//$('select').formSelect();
	}, "json").done(function(){
		$("#loader").hide();
	});
}

function agregarVentasATO(){

	params = {
		service: "agregarVentasATO",
		dbName: dbName,
		vendedor: $('#idVendedor').val(),
		maquina: $("#idMaquina").val(),
		aerolinea: $("#idAerolinea").val()
	};

	console.log(params);

	$.post(host, params, function (data) {
		$.each(data, function (key, val) {
		});
	}, "json");

}

function drawCart(items){
	var detail = "";
	var summary = "";
	var subtotalVenta = 0; //Valor total de la venta sin descuentos
	var total1 = 0;
	var total2 = 0;
	var totalDolar = 0;
	var subtotalDolar = 0;
	var totalDescontado = 0; //Valor total de los descuentos aplicados

	if (items === null) {
		// detail += "<li>";
		// detail += '<div class="row detalleCarrito">';
		// detail += '<div class="col s12 center-align">';
		// detail += "0 registros encontrados en el carrito";
		// detail += "</div>";
		// detail += "</div>";
		// detail += "</li>";

		detail += `
		<ul id="detalleCarrito" class='mdl-list' >
			<li class="mdl-list__item">
				<span class="mdl-list__item-primary-content">
					<i class="material-icons mdl-list__item-icon">shopping_bag</i>
					No hay productos en el carrito
				</span>
			</li>
		</ul>`;

		$("#subtotalVenta").val(0);  
		$("#total").val(0);
		$("#totalDescontado").val(0);
		$("#totalItems").val(0);
		//$("#spanTotal").html("Q " + accounting.formatNumber(0, 2));
		if ($("#tipoMoneda").val() == "2"){ //Si es Dolar:
			$("#spanTotal").html("$ " + accounting.formatNumber(0, 2));
		} else {
			$("#spanTotal").html("Q " + accounting.formatNumber(0, 2));				
		}
	} else {
		detail = `<ul id="detalleCarrito" class='mdl-list' style="padding: 0; margin: 0;">`;
		$.each(items, function (key, val) {

			var Upc = "'" + val.Upc + "'";
			//var Precio = "'" + accounting.unformat(val.precio) + "'";
			subtotalVenta += accounting.unformat(val.subtotal);
			total1 += accounting.unformat(val.total);
			total2 += accounting.unformat(val.cantidad);

			subtotalDolar += accounting.unformat(val.totalDolares + val.descuento); //Cumple la funcion del subtotal sin descuentos
			totalDolar += accounting.unformat(val.totalDolares);

			totalDescontado += accounting.unformat(val.descuento);

			let precio = "";

			if ($("#tipoMoneda").val() == "2"){ //Si es Dolar
				precio = accounting.formatMoney((val.totalDolares), "$ ", 2); 
			} else {
				precio = accounting.formatMoney((val.subtotal - val.descuento), "Q ", 2);				
			}

			detail += `
			<li class="mdl-list__item mdl-menu__item--full-bleed-divider">
				<span class="mdl-list__item-primary-content" 
				onclick="menuOpciones(${val.id},'${val.descLarga}','${val.subtotal}','${val.cantidad}',${val.idProductos},${val.precioDolares});">
				<span class="mdl-list__item-icon">${parseFloat(val.cantidad)}x</span>
				<span class="truncate">${val.descLarga.toLowerCase()}</span>
				</span>
				<span class="mdl-list__item-secondary-action" >
					${precio}
				</span>
			</li>
			</ul>`;
		});

		if ($("#tipoMoneda").val() == "2"){
			//$("#total").val(totalDolar); // aqui se transforma ya el total a la moneda que deberia guardar 
			
			$("#totalDolares").val(accounting.formatNumber(totalDolar, 2));
			$("#subtotalVenta").val(accounting.formatNumber(subtotalDolar, 2));
		}else{
			$("#total").val(accounting.formatNumber(total1, 2));
			$("#subtotalVenta").val(accounting.formatNumber(subtotalVenta, 2)); //Valor total de la venta sin descuentos
		}
		
		$("#totalDescontado").val(accounting.formatNumber(totalDescontado, 2)); //Valor total de los descuentos aplicados
		$("#totalItems").val(total2);

		if ($("#tipoMoneda").val() == "2"){ //Si es Dolar
			$("#spanTotal").html("$ " + accounting.formatNumber((totalDolar), 2));
		} else {
			$("#spanTotal").html("Q " + accounting.formatNumber(total1, 2));				
		}
	}
	$('#productosMobile').empty();
	$("#productosMobile").append(detail);
	$("#resumenCarrito").append(summary);
}

function drawFormasPago(){
	$('#detalles').hide();

	if($( "#divFormasPago" ).length){
		
		$('#divFormasPago').slideDown();
		$('#facturaDatos').remove();
		$('#divNumPadNIT').remove();
	}
	else{
		$('#productosMobile').empty();

		let contenido = `
		<div id="divFormasPago" style="margin-bottom: 0px !important;">
			<div class="mdl-grid no-padding">
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<input type="text" id="TxtSaldo" class="mdl-textfield__input big-numbers full-width" disabled="">
				</div>
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<button class="mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect full-width shapedbox" 
						onclick="resetCuenta();">
						<i class="material-icons right">refresh</i>Saldo
					</button>
				</div>
			</div>
	
			<div class="mdl-grid no-padding" id="divEfectivo">
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<input type='text' id='TxtEfectivo' class="mdl-textfield__input big-numbers full-width formasPago" data-type="1" data-emisor="0" disabled />
				</div>
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<button class="mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect full-width shapedbox" 
						onclick="calcTotal('TxtEfectivo');">
						<i class="material-icons right">payments</i>Efectivo
					</button>
				</div>
			</div>
	
			<div class="mdl-grid no-padding" id="divDolares" style="display:none;">
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<input type='text' id='TxtDolares' class="mdl-textfield__input big-numbers full-width formasPago" data-type="2" data-emisor="0" disabled />
				</div>
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<button class="mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect full-width shapedbox" 
						onclick="calcTotal('TxtDolares');">
						<i class="material-icons right">monetization_on</i>Dolares
					</button>
				</div>
			</div>
	
			<div class="mdl-grid no-padding" id="divVisa">
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<input type='text' id='TxtVisa' class="mdl-textfield__input big-numbers full-width formasPago" data-type="5" data-emisor="1" disabled />
				</div>
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<button class="mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect full-width shapedbox" 
						onclick="calcTotal('TxtVisa');">
						<i class="material-icons right">credit_card</i>VISA
					</button>
				</div>
			</div>
	
			<div class="mdl-grid no-padding" id="divBac" style="display:none;">
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<input type='text' id='TxtBac' class="mdl-textfield__input big-numbers full-width formasPago" data-type="5" data-emisor="2" disabled />
				</div>
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<button class="mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect full-width shapedbox" 
						onclick="calcTotal('TxtBac');">
						<i class="material-icons right">credit_card</i>BAC
					</button>
				</div>
			</div>
	
			<div class="mdl-grid no-padding">
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<input type='text' id='TxtTotal' class="mdl-textfield__input big-numbers full-width" disabled />
				</div>
				<div class="mdl-cell mdl-cell--2-col-phone fp-margin ">
					<button id="btnCobrar" class="mdl-button mdl-js-button mdl-button--raised mdl-js-ripple-effect mdl-button--accent full-width shapedbox" 
						onclick="confirmCompra();" disabled="">Confirmar
					</button>
				</div>
			</div>
	
			<div class="mdl-grid no-padding">
				<div class="mdl-cell mdl-cell--4-col-phone fp-margin ">
					<input type="text" id="TxtNumPad" class="mdl-textfield__input big-numbers full-width right-align" disabled="">
				</div>
			</div>
			<div id="divNumPadCobro" class="mdl-grid" style="text-align: center; padding: 0px;"></div>
		</div>
		`;
	
		$('#productosMobile').append(contenido);

		if($("#tipoMoneda").val() == "2"){
			$('#divEfectivo').hide();
			$('#divVisa').hide();
			$('#divBac').hide();
			$('#divDolares').show();
		}

		getDatosVenta();
	}
}

function drawFacturacion(){
	let contenido = `
	<div id="facturaDatos" class="mdl-grid">
		<div class="mdl-cell mdl-cell--4-col-phone">
			<form id="divDatosFactura"> 
				<div class="mdl-textfield mdl-js-textfield " style="padding: 10px 0px;">
					<input placeholder="CF" class="mdl-textfield__input" type="text" id="nit">
				</div>

				<div class="mdl-textfield mdl-js-textfield " style="padding: 10px 0px;">
					<input placeholder="Consumidor Final" class="mdl-textfield__input" type="text" id="nombre">
				</div>

				<div class="mdl-textfield mdl-js-textfield " style="padding: 10px 0px;">
					<input placeholder="Direccion" class="mdl-textfield__input" type="text" id="direccion">
				</div>
    		</form>
		</div>    
	</div>
	<div id="divNumPadNIT" class="mdl-grid" style="text-align:center; padding: 0px;"></div>
	`
	$('#productosMobile').append(contenido);
	createNumPad("divNumPadNIT", "nit", "K", "", "");
}

// ? Paso 1: Seleccionar los detalles del ATO
function showDetalles(){
	$('#btnBackTool').hide();
	$('#divTipMoneda').hide();
	$('#btnTotal').hide();

	$('#productosMobile').empty();
	$('#btnDetalles').show();

	drawDetalles();

	$('#btnDespachar').hide();
	$('#btnDetalles').show();
}

//? Guardar los detalles seleccionados
function setDetalleATO(){
	$('#idVendedor').val($("#selectVendedor").children("option:selected").val());
	$('#idMaquina').val($("#selectMaquina").children("option:selected").val());
	$('#idAerolinea').val($("#selectAerolinea").children("option:selected").val());
	
	returnProductos();
}

//? Paso 2: Seleccion/Busqueda de productos
function returnProductos(){
	$('#btnBackTool').show();
	$('#btnBackTool').attr('onclick', 'showDetalles()');

	$('#divTipMoneda').show();
	$('#productosMobile').height(canvasH);
	$('#productosMobile').empty();

	getProductos();
	
	
	$('#btnDetalles').hide();
	$('#btnTotal').hide();
	$('#btnDespachar').show();
}

function showCarrito(){
	$('#btnBackTool').show();
	$('#btnBackTool').attr('onclick', 'returnProductos()');

	$('#divTipMoneda').hide();

	$('#productosMobile').height(canvasH);
	$('#productosMobile').empty();
	loadProductosVenta();
	
	$('#btnDespachar').hide();
	$('#btnDetalles').hide();
	$('#btnTotal').show();

}



function showCobro(){
	$('#btnBackTool').attr('onclick', 'showCarrito()');

	$('#productosMobile').height('100%');
	
	validacionCarrito();
	
	$('#carritoMobile').hide();
	$('#btnDetalles').hide();
	$('#btnTotal').hide();
	$('#btnFinVenta').hide();
}

function showFacturacion(){
	$('#btnBackTool').attr('onclick', 'showCobro()');
	$('#divFormasPago').slideUp();

	drawFacturacion();

	$('#btnFinVenta').show();
}


