function nitIsValid(nit) {
	if (!nit) {
		return true;
	}

	let nitRegExp = new RegExp("^[0-9]+(-?[0-9kK])?$");

	if (!nitRegExp.test(nit)) {
		return false;
	}

	nit = nit.replace(/-/, "");
	let lastChar = nit.length - 1;
	let number = nit.substring(0, lastChar);
	let expectedCheker = nit.substring(lastChar, lastChar + 1).toLowerCase();

	let factor = number.length + 1;
	let total = 0;

	for (var i = 0; i < number.length; i++) {
		let character = number.substring(i, i + 1);
		let digit = parseInt(character, 10);

		total += digit * factor;
		factor = factor - 1;
	}

	let modulus = (11 - (total % 11)) % 11;
	let computedChecker = modulus == 10 ? "k" : modulus.toString();

	return expectedCheker === computedChecker;
}

function validarNIT() {
	var $this = $("#nit");
	var nit = $this.val();

	if (nit && nitIsValid(nit)) {
		$this.removeClass("invalid");
		$this.addClass("valid");
		consultaNIT();
	} else if (nit) {
		$this.removeClass("valid");
		$this.addClass("invalid");
		$("#nombre").val("");
		$("#direccion").val("");
	} else {
		$this.removeClass("valid");
		$this.removeClass("invalid");
		$("#nombre").val("");
		$("#direccion").val("");
	}
}

function createNumPad(parent, inputElement, opt1, opt2, opt3) {
	let optHtml = [];
	let optarr = [opt1, opt2, opt3];

	if(localStorage.isMobile == "true"){
		optarr.forEach(function (item) {
			switch (item) {
				case "reset":
					optHtml.push(`<button class="btn-icon keyArrow"
					onclick="fnReset(this,'${inputElement}');">
					<i class="material-icons right ">refresh</i></button>`);
					break;
				case "swap":
					optHtml.push(`<button class="btn-icon keyArrow"
					onclick="fnSwap(this,'${inputElement}');">
					<i class="material-icons right ">swap_vert</i></button>`);
					break;
				case "arrow-up":
					optHtml.push(`<button class="btn-icon keyArrow"
					onclick="fnArrow(this,'${inputElement}');" data-valor='UP'>
					<i class="material-icons right ">keyboard_arrow_up</i></button>`);
					break;
				case "arrow-down":
					optHtml.push(`<button class="btn-icon keyArrow"
					onclick="fnArrow(this,'${inputElement}');" data-valor='DOWN'>
					<i class="material-icons right ">keyboard_arrow_down</i></button>`);
					break;
				case "confirm":
					optHtml.push(`<button id="btnIntro" class="btn-icon"
					onclick="fnConfirm(this, '${inputElement}');" data-valor='intro'>
					<i class="material-icons right ">keyboard_return</i></button>`);
					break;
				case "confirmAuth":
					optHtml.push(`<button id="btnIntro" class="btn-icon"
					onclick="fnAutorizacion(this, '${inputElement}');">
					<i class="material-icons right ">keyboard_return</i></button>`);
					break;
				case "percentage":
					optHtml.push(`<button id="btnIntro" class="btn-character"
						onclick="fnPorcentaje(this, '${inputElement}');">%</button>`);
					break;
				case "":
					optHtml.push(`<button class="btn-disabled disabled">_</button>`);
					break;
				default:
					optHtml.push(`<button class="blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='${item}'">${item}</button>`);
					break;
			}
		});
			var teclado = `
					<div class="col-num mdl-cell mdl-cell--12-col mdl-cell--12-col-phone ">
						<button class="blue-grey darken-1 btn-num keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='7'>7</button>

						<button class="blue-grey darken-1 btn-num keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='8'>8</button>
						
						<button class="blue-grey darken-1 btn-num keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='9'>9</button>
						
						<button class="btn-icon keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='backspace'>
						<i class="material-icons right ">backspace</i></button>
					</div>

					<div class="col-num mdl-cell mdl-cell--12-col mdl-cell--12-col-phone ">
						<button class="blue-grey darken-1 btn-num keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='4'>4</button>

						<button class="blue-grey darken-1 btn-num keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='5'>5</button>

						<button class="blue-grey darken-1 btn-num keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='6'>6</button>

						<button class="btn-character keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='clear'>C</button>
					</div>
				
					<div class="col-num mdl-cell mdl-cell--12-col mdl-cell--12-col-phone ">
						<button class="blue-grey darken-1 btn-num keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='1'>1</button>

						<button class="blue-grey darken-1 btn-num keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='2'>2</button>

						<button class="blue-grey darken-1 btn-num keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='3'>3</button>
						${optHtml[1]}
					</div>
				
					<div class="col-num mdl-cell mdl-cell--12-col mdl-cell--12-col-phone ">
						<button class="btn-double keyPad"
						onclick="insertNumPad(this,'${inputElement}');" data-valor='0'>0</button>
						${optHtml[0]}
						${optHtml[2]}
					</div>`;
	}else{
		optarr.forEach(function (item) {
			switch (item) {
				case "arrow-up":
					optHtml.push(`<a class="waves-effect waves-light btn-large z-depth-1 amber darken-2 btn-icon keyArrow"
					onclick="fnArrow(this,'${inputElement}');" data-valor='UP'>
					<i class="material-icons ">keyboard_arrow_up</i></a>`);
					break;
				case "arrow-down":
					optHtml.push(`<a class="waves-effect waves-light btn-large z-depth-1 amber darken-2 btn-icon keyArrow"
					onclick="fnArrow(this,'${inputElement}');" data-valor='DOWN'>
					<i class="material-icons ">keyboard_arrow_down</i></a>`);
					break;
				case "confirm":
					optHtml.push(`<a id="btnIntro" class="waves-effect waves-light btn-large z-depth-1 amber darken-2 btn-icon "
					onclick="fnConfirm(this, '${inputElement}');" data-valor='intro'>
					<i class="material-icons ">keyboard_return</i></a>`);
					break;
				case "confirmAuth":
					optHtml.push(`<a id="btnIntro" class="waves-effect waves-light btn-large z-depth-1 amber darken-2 btn-icon "
					onclick="fnAutorizacion(this, '${inputElement}');">
					<i class="material-icons ">keyboard_return</i></a>`);
					break;
				case "percentage":
					optHtml.push(`<a id="btnIntro" class="waves-effect waves-light btn-large z-depth-1 amber darken-2 btn-icon "
						onclick="fnPorcentaje(this, '${inputElement}');">%</a>`);
					break;
	
				case "":
					optHtml.push(`<a class="btn-large btn-icon disabled"></a>`);
					break;
				default:
					optHtml.push(`<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='${item}'">${item}</a>`);
	
					break;
			}
		});
		var teclado = `
				<div class="col-num col s12 center">
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='7'>7</a>
	
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='8'>8</a>
					
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='9'>9</a>
					
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-4 btn-icon keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='backspace'><i class="material-icons ">backspace</i></a>
				</div>
	
				<div class="col-num col s12 center">
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='4'>4</a>
	
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='5'>5</a>
	
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='6'>6</a>
	
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-4 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='clear'>C</a>
				</div>
			
				<div class="col-num col s12 center">
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='1'>1</a>
	
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='2'>2</a>
	
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1 btn-num keyPad"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='3'>3</a>
					${optHtml[1]}
				</div>
			
				<div class="col-num col s12 center">
					<a class="waves-effect waves-light btn-large z-depth-1 blue-grey darken-1  keyPad"
					style="width: 146.90px; border-radius: 15px; font-weight: bold; font-size: 2.5em; margin: 0em 0.1em; line-height: 65px; height: 70px;"
					onclick="insertNumPad(this,'${inputElement}');" data-valor='0'>0</a>
					${optHtml[0]}
					${optHtml[2]}
				</div>`;
	}
	$("#" + parent).empty();
	$("#" + parent).append(teclado);
}

function insertNumPad(sender, target) {
	let actual = $("#" + target).val();
	let digit = $(sender).data("valor");

	switch (digit) {
		case "clear":
			$("#" + target).val("");
			// 
			$("#percent").attr("style", "visibility: hidden");
			$("#outputDescuento").val("");
			//
			break;
		case "backspace":
			$("#" + target).val(actual.slice(0, -1));
			break;
		case ".":
			if (actual.indexOf(".") == -1) {
				if (actual == "") {
					$("#" + target).val("0.");
				} else {
					$("#" + target).val("" + actual + digit);
				}
			}
			break;
		default:
			$("#" + target).val("" + actual + digit);
			break;
	}

	switch (target) {
		case "nit":
			validarNIT();
			break;
		default:
			$("#" + target).trigger("change");
			break;
	}
}

// Subrutina para calcular porcentaje
function fnPorcentaje(sender, target) {
	var saldo = parseFloat(accounting.unformat($("#subtotal").val()));
	var porcentaje = parseFloat($("#inputDescuento").val());

	$("#percent").attr("style", "visibility: visible");

	if (saldo > 0) {
		if (porcentaje < 0) {
			Swal.fire("Porcentaje no admitido");
		}

		if (porcentaje > 100) {
			porcentaje = 100;
		}

		var calculoPorcentaje = (saldo * porcentaje) / 100;
		var totalConPorcentaje = (saldo - calculoPorcentaje)

		$("#outputDescuento").val(accounting.format(totalConPorcentaje.toString(), 2));
		$("#percent").val(accounting.format(calculoPorcentaje.toString(), 2));
		
	}
}

function fnArrow(sender, target) {
	let iTarget = $("#" + target).data("index");
	let idPreFix = target.replace(iTarget, "");
	let direction = $(sender).data("valor");
	let nTarget;

	switch (direction) {
		case "UP":
			nTarget = iTarget - 1;
			nTarget = nTarget < 0 ? 0 : nTarget;
			break;
		case "DOWN":
			nTarget = iTarget + 1;
			nTarget = $("#" + idPreFix + nTarget).length ? nTarget : iTarget;
			break;
		default:
			break;
	}

	if (iTarget != nTarget) {
		$("#" + target).css("border-bottom-color", "#9e9e9e");
		$("#" + target).css("background-color", "transparent");

		$("#" + idPreFix + nTarget).css("border-bottom-color", "#ffb300");
		$("#" + idPreFix + nTarget).css("background", "#ffecb3");

		$(".keyPad").attr(
			"onclick",
			"insertNumPad(this,'" + idPreFix + nTarget + "');",
		);
		$(".keyArrow").attr(
			"onclick",
			"fnArrow(this,'" + idPreFix + nTarget + "');",
		);
	}
}

// * Subrutina para autorizar
// ! Revisar su uso para poder utilizar en cualquier pagina.
function fnAutorizacion(target) {
	var txtInput = $("#" + target).val();

	if (target == "usuario") {
		if (txtInput == "") {
			Swal.fire({
				icon: "warning",
				text: "Debe ingresar su usuario",
				showCloseButton: true,
				confirmButtonText: "Intentar de nuevo",
				html: "Debe ingresar su usuario",
			});
		} else {
			$('#usuario').hide();
            $('#password').show();
			$("#iconoUSR").addClass("scale-out");
			$("#iconoUSR").hide(function () {
				$("#iconoPSW").show(function () {
					$("#iconoPSW").removeClass("scale-out");

					if(localStorage.touchEnabled == "false"){
						assignKeyActions('password', 'confirm'); 
					}
					else{
						$(".keyPad").attr("onclick", "insertNumPad(this,'password');");
						$("#btnIntro").attr("onclick", "fnConfirm(this, 'password');");
					}
					
					
				});
			});
		} 
	} else if (target == "password") {
		if (txtInput == "") {
			$("#loader").hide();
			Swal.fire({
				icon: "warning",
				text: "Debe ingresar su contrase&#241;a",
				showCloseButton: true,
				confirmButtonText: "Intentar de nuevo",
				html: "Debe ingresar su contrase&#241;a",
			});
		} else {
			$("#loader").show();

			params = {
				service: "login",
				dbName: dbName,
				usuario: $("#usuario").val(),
				password: $("#password").val(),
			};

			$.post(host, params, function (data) {
					var autorizado = false;
					if (data !== null) {
						if (data[0].idRoles == 1 || data[0].idRoles == 2) {
							autorizado = true;
							huellaAutorizada();
							
						} else {
							Swal.fire({
								icon: "warning",
								showCloseButton: true,
								confirmButtonText: "Intentar de nuevo",
								html: "Usuario sin autorizacio&#769;n",
							});
						}
					} else {
						Swal.fire({
							icon: "error",
							text: "El usuario o contrase&#241;a son incorrectos",
							showCloseButton: true,
							confirmButtonText: "Intentar de nuevo",
							html: "El usuario o contrase&#241;a son incorrectos",
							timer: 2000
						});
					}

					if (!autorizado) {
						$("#usuario").val("");
						$("#password").val("");
						$('#password').hide();
						$('#usuario').show();
						$("#iconoPSW").addClass("scale-out");
						$("#iconoPSW").hide(function () {
							$("#iconoUSR").show(function () {
								$("#iconoUSR").removeClass("scale-out");
								if(localStorage.touchEnabled == "false"){
									assignKeyActions('usuario', 'confirm'); 
								}
								else{
									$(".keyPad").attr("onclick", "insertNumPad(this,'usuario');");
									$("#btnIntro").attr("onclick", "fnConfirm(this, 'usuario');");
								}
								
							});
						});
						$("#loader").hide();
					}
				}, "json");
		}
	}
}

function huellaAutorizada(){

	$("#modalAutorizacion").modal("close");
	//$('.keyPad').attr('onclick', 'insertNumPad(this,"TxtNumPad");');
	$("#loader").hide();
	$("#usuario").val("");
	$("#password").val("");
	
	
	let opcion = $("#opcionAutorizacion").val();
	
	//Switch para manejar distintos casos donde sea necesario el modal de autorizacion
	switch (opcion){
	case "descuento":
		modalDescuento();
		break;
	case "eliminar":
		var descLarga = $("#descLarga").val();
		var id = $("#productoID").val();
		var idProductos = $("#idProductos").val();
		eliminarProductoVenta(id, descLarga,idProductos);
	}

}

function salirCaja() {
	localStorage.codigoUsuario = undefined;
	localStorage.idUsuarios = undefined;
	localStorage.nombreUsuario = undefined;
	localStorage.tipoUsuario = undefined;
	localStorage.idSucursales = undefined;
	localStorage.idEmpresas = undefined;
	window.location = "index.html";
}


function assignKeyActions(inputID, opt1){
	$("#" + inputID).removeAttr('disabled');
	$("#" + inputID).focus();
	$('#' + inputID).keypress(function(event){
		var keycode = (event.keyCode ? event.keyCode : event.which);
		if(keycode == '13'){
			switch(opt1){
				case 'confirm':
					fnConfirm(this, inputID);
					break;
			}
		}
	});
}

function huella(){
	var settings = {
		url: "http://localhost/verify",
		method: "GET",
		timeout: 0,
		headers: {
			"Content-Type": "application/json",
		},
		//data: JSON.stringify(params),
		dataType: "json",
	};
	$.ajax(settings)
		.done(function (returnValue) {
			console.log(returnValue);
			//location.reload();

			let page = location.href.split("/").slice(-1);
    		page = page[0].split('.');
    		let pagina = page[0];

			switch(pagina){
				case 'main':
					if (returnValue.idRoles == 1 || returnValue.idRoles == 2 ){
						huellaAutorizada();
					}else{
						Swal.fire({
							icon: "warning",
							showCloseButton: true,
							confirmButtonText: "Intentar de nuevo",
							html: "Usuario sin autorizacio&#769;n",
						});
					}
				break;
				case 'corte':
				case 'index':
					getCredenciales(returnValue.idUsuarios);
				break;
				default:
					getCredenciales(returnValue.idUsuarios);
					break;
			}
           
		})
		.fail(function (returnValue) {
			//location.reload();
            console.log("FAIL");
            console.log(returnValue);
		});
        
}

function getCredenciales(idUsuarios){
    params = {
        service: 'getCredenciales',
        dbName: dbName,
        idUsuario: idUsuarios
    };
    $.post(host, params, function(data) {
        $.each(data, function(key, val) {
            $("#usuario").val(val.codigoUsuario);
            $("#password").val(val.pwd_real);
        });
    }, 'json');
}

function eliminarCarritoNotas(){
	params = {
        service: 'eliminarCarritoNotas',
        dbName: dbName,
        idUsuarios: localStorage.idUsuarios,
        idEmpresas: localStorage.idEmpresas
    };
    $.post(host, params, function(data) {
        $.each(data, function (key, val) {
        });
    }, 'json').done(function(){
    });
}