$(document).ready(function() {
    resizeDOMHeights();
    localStorage.cajaAbierta = 'false';

	$("#modalAutorizacion").modal({
		dismissible: false,
	});

	$("#modal-title").html("Confirmacio&#769;n");
    $('#password').show();
    huella();
	if(localStorage.touchEnabled == "false"){
        $("#modalAutorizacion").modal("open");
        assignKeyActions('password', 'confirm'); 
    }
    else{
        createNumPad("divNumPadConfirmacion", "password", "confirm", "", "");
        $("#modalAutorizacion").modal("open");
    }

    if (localStorage.isMobile == "true"){
        $("#divCorte").removeClass("s6");
        $("#numpadCorte").removeClass("s6");
        //$("#numpadCorte").addClass("divFlotante");
        $("#tituloCorte").hide();
        $("#tituloTotal").hide();
    }

    	
    if(localStorage.touchEnabled == "false"){
        $("#password").removeAttr('disabled');
        $("#totalEfectivo").removeAttr('disabled');
        $("#input0").removeAttr('readonly');
        $("#input1").removeAttr('readonly');
        $("#input2").removeAttr('readonly');
        $("#input3").removeAttr('readonly');
        $("#input4").removeAttr('readonly');
        $("#input5").removeAttr('readonly');
        $("#input6").removeAttr('readonly');
        $("#input7").removeAttr('readonly');
        $("input").focus();
    }



});

function returnCaja() {
    if (localStorage.isMobile == "true"){
        window.location = "mobileShop.html";
    }else{
        window.location = "main.html";
    }

}

function autenticado(){
    localStorage.cajaAbierta = 'true';
    $('#modalAutorizacion').modal('close');
    $('#btnCloseModal').removeClass("modal-close-alt");
    $('#btnCloseModal').removeAttr("onclick");
    $('#btnCloseModal').addClass("modal-close");

    $('#input0').css('border-bottom-color', '#ffb300');
    $('#input0').css('background-color', '#ffecb3');

    $(".monedas").change(function() {
        let monto = $(this).val();
        let value = $(this).attr('title');
        let total = monto * value;
        total = (isNaN(total))? 0: total;
        
        $("#result" + value).val(accounting.formatNumber(total, 2));
        if($("#result" + value).val() < 0){
            Swal.fire({
                icon: "warning",
                text: "Debe ingresar un monto valido.",
                showCloseButton: true,
                confirmButtonText: "Intentar de nuevo",
                html: "Debe ingresar un monto valido.",
            }).then((result) => {
                $("#result" + value).val("");
            });
        }else{
            let totalEfectivo = 0;
            $(".totalesM").each(function() {
                let thisVal = parseFloat(accounting.unformat($(this).val()));
                thisVal = (isNaN(thisVal))? 0: thisVal;
                totalEfectivo = totalEfectivo + thisVal;
            });
            $("#totalEfectivo").val(accounting.formatNumber(totalEfectivo, 2));
        }

    });

    createNumPad('divNumPad','input0','.','arrow-up','arrow-down');
    
    if(sunmiDevice && localStorage.isMobile != 'true')
        sunmiInnerPrinter.openDrawer();
    else{
        let par = {service: ''};
        localPrinter(par, 'openDrawer');
    }
        
    
    //alert('se abriio');
}

function getDetalleVentas(){
    var corte = corteManual;
	if(corte == true){
		corte = 1;
	}else{
		corte = 0;
	}

    params = {
        service: 'getDetalleVentas',
        dbName: dbName,
        idSucursales: localStorage.idSucursales,
        idUsuarios: localStorage.idUsuarios,
        idEmpresas: localStorage.idEmpresas,
        corte: corte
    };
    //
    $.post(host, params, function(data) {
        procesarCorte(data);
        
    }, 'json');
}

function procesarCorte(detVentas) {
	var cantidad = [];
	var descripcion = [];
	var detalle = [];

	$(".cantidad").each(function (index) {
		cantidad.push(accounting.formatNumber($(this).val(), 2));
		descripcion.push($(this).attr("title"));
	});

	$(".totalesM").each(function (index) {
		var arr = {};
		arr["cantidad"] = accounting.unformat(cantidad[index]);
		arr["descripcion"] = descripcion[index];
		arr["total"] = accounting.formatNumber($(this).val(), 2);
		detalle.push(arr);
	});

    var corte = corteManual;
	if(corte == true){
		corte = 1;
	}else{
		corte = 0;
	}

	params = {
		service: "procesarCorte",
		totalEfectivo: accounting.unformat($("#totalEfectivo").val()),
		detalle: detalle,
		dbName: dbName,
		idSucursales: localStorage.idSucursales,
		idUsuarios: localStorage.idUsuarios,
		idEmpresas: localStorage.idEmpresas,
        corte: corte
	};
	//
	$.post(host, params, function (data) {
        let val = data[0]; 
        if (val.message === "success") {
            // ! Se envían los Detalle Corte y Detalle Venta.
            datosReporteCierre(val, detVentas);

            printCorte(val, detVentas);
        } else {
            $("#loader").hide();
            console.log(val);
            Swal.fire({
                icon: "error",
                title: val.message,
                showCloseButton: true,
                confirmButtonText: "Intentar de nuevo",
            });
        }
		}, "json");
}

function corteDeCaja() {
    $("#password").val("");
    $("#divNumPadConfirmacion").empty();
    let totalEfectivo = accounting.unformat($("#totalEfectivo").val());

    if(totalEfectivo < 0){
        Swal.fire({
			icon: "warning",
			text: "Debe ingresar un monto valido.",
			showCloseButton: true,
			confirmButtonText: "Intentar de nuevo",
			html: "Debe ingresar un monto valido.",
		});
    }else{
        $("#modal-title").html("Confirmacio&#769;n");

        if(localStorage.touchEnabled == "false"){
            $("#modalAutorizacion").modal("open");
            $('#password').focus();
            //assignKeyActions('password', 'confirm'); 
        }
        else{
            createNumPad("divNumPadConfirmacion", "password", "confirm", "", "");
            $("#modalAutorizacion").modal("open");
        }

    }

}

function fnConfirm(sender, idPassword){
    $('#loader').show();
  
    var usuario = localStorage.codigoUsuario;
    var pwd = $("#" + idPassword).val();
  
    if (usuario == undefined){
        salirCaja();
    }
  
    if (pwd == '') {
        $('#loader').hide();
        Swal.fire({
            icon: 'warning',
            text: 'Debe ingresar su contrase&#241;a',
            showCloseButton: true,
            confirmButtonText: 'Intentar de nuevo',
            html: 'Debe ingresar su contrase&#241;a'
        });
  
    } else {
        
        params = {
            service: 'login',
            dbName: dbName,
            usuario: usuario,
            password: pwd
        };
        $.post(host, params, function(data) {
            if (data !== null) {
                confirmado();
            } else {
                $("#" + idPassword).val("");
                $('#loader').hide();
                Swal.fire({
                    icon: 'error',
                    text: 'Contrase&#241;a incorrecta',
                    showCloseButton: true,
                    confirmButtonText: 'Intentar de nuevo',
                    html: 'Contrase&#241;a incorrecta'
                });
            }
        }, 'json');
    }   
}

function confirmado(){
    if(localStorage.cajaAbierta == 'true'){
        getDetalleVentas();
    }
    else{
        autenticado();
    }
    $('#loader').hide();
}

function printCorte(detCorte, detVentas){
    localStorage.cajaAbierta = 'false';

    if(sunmiDevice)
        printCorteSunmi(detCorte, detVentas);
    else{
        let par = {};
        par.detCorte = detCorte;
        par.detVentas = detVentas;
        localPrinter(par, 'printCorte');
    }
    
    Swal.fire({
        title: '&iquest;Desea Continuar?',
        icon: 'question',
        showCancelButton: true,
        showCloseButton: false,
        cancelButtonText: 'Cerrar Sesi&oacute;n',
        confirmButtonColor: '#3085d6',
        confirmButtonText: 'Si, Continuar',
        allowOutsideClick: false,
        allowEscapeKey: false,
    }).then((result) => {
        
        if (result.value) {
            window.location = "main.html";
        }
        else{
            salirCaja();
        }

    });

    $('#loader').hide();
}

function printCorteSunmi(detCorte, detVentas){
    var tamano = [col3A,col3B,col3B];
    var alineamiento = [0, 2, 2];

    sunmiInnerPrinter.printerInit()
    .then(() => {
        return sunmiInnerPrinter.setAlignment(1);
    })
    .then(() => {
        return sunmiInnerPrinter.printTextWithFont(`CORTE DE CAJA\n${detCorte.nombreEmpresa}\n`, "", fontL);
    })
    .then(() => {
        return sunmiInnerPrinter.setAlignment(0);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont(`Usuario: ${detCorte.nombreUsuario}\n`, "", fontM);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont(`Apertura: ${detCorte.fecIniFondo}\nCierre: ${detCorte.fecFinFondo}\n`, "", fontS);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont(`Fondo de Caja ${accounting.formatMoney(detCorte.montoFondo, "Q")}\n`, "", fontM);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont("Vales            " + accounting.formatMoney(detCorte.totalVales, "Q") + "\n", "", fontM);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont("VISA             " + accounting.formatMoney(detCorte.totalVisa, "Q") + "\n", "", fontM);
    })
    .then(()=>{    
        return sunmiInnerPrinter.printTextWithFont("CREDOMATIC       " + accounting.formatMoney(detCorte.totalBac, "Q") + "\n", "", fontM);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont("EFECTIVO         " + accounting.formatMoney(detCorte.totalEfectivoQ, "Q") + "\n", "", fontM);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont("DESCUENTOS (-)   " + accounting.formatMoney(detCorte.totalDescuento, "Q") + "\n\n", "", fontM);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont("NOTAS DE CREDITO " + accounting.formatMoney(detCorte.totalNCRE, "Q") + "\n\n", "", fontM);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont("VENTA NETA " + accounting.formatMoney(detCorte.totalVentas, "Q") + "\n\n", "", fontL);
    })
    .then(()=>{
        let dif = accounting.formatNumber(detCorte.diferencia, 2);
        if(dif > 0){
            return sunmiInnerPrinter.printTextWithFont("DIFERENCIA    " + accounting.formatMoney(detCorte.diferencia, "Q") + "\n\n", "", fontM);
        }
        else{
            return sunmiInnerPrinter.printTextWithFont("\n", "", fontM);
        }
    })
    .then(()=>{
        return sunmiInnerPrinter.setAlignment(1);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont("- DETALLE POR PRODUCTO -\n", "", fontM);
    })
    .then(()=>{
        var texto = ["Descripcion", "Cant.", "Total"];
        return sunmiInnerPrinter.printColumnsText(texto, tamano, alineamiento);
    })
    .then(()=>{
        var i = 0;
        while (detVentas[i]) {
            let item = detVentas[i];
            let producto = [item.nombre + " - " + item.sku, parseFloat(item.cant), "Q"+ item.total];
            i++;
            sunmiInnerPrinter.printerInit()
            .then(() => {
                return sunmiInnerPrinter.printColumnsText(producto, tamano, alineamiento);
            });
        }

        return sunmiInnerPrinter.setAlignment(1);
    })
    .then(()=>{
        return sunmiInnerPrinter.printTextWithFont(`${prntlinea}\n`, "", fontL);
    })
    .then(()=>{
        return sunmiInnerPrinter.cutPaper();
    });
}

// * Subrutina: datosReporteCierre() Se envían los Detalle Corte y Detalle Venta.
function datosReporteCierre(detCorte, detVentas) {
	params = {
		service: "reporteCierre",
		dbName: dbName,
		nombreEmpresa: detCorte.nombreEmpresa,
		nombreUsuario: detCorte.nombreUsuario,
		fecIniFondo: detCorte.fecIniFondo,
		fecFinFondo: detCorte.fecFinFondo,
		montoFondo: detCorte.montoFondo,
		totalVales: detCorte.totalVales,
		totalVisa: detCorte.totalVisa,
        totalBac: detCorte.totalBac,
        totalDescuento: detCorte.totalDescuento,
		totalEfectivoQ: detCorte.totalEfectivoQ,
		totalVentas: detCorte.totalVentas,
		diferencia: detCorte.diferencia,
		email: detCorte.email,
		detalleVentas: detVentas,
        idEmpresas: localStorage.idEmpresas
	};
	console.log("params :>> ", params);

	params_test = {
		service: "reporteCierre",
		dbName: "dbName",
		nombreEmpresa: "detCorte.nombreEmpresa",
		nombreUsuario: "detCorte.nombreUsuario",
		fecIniFondo: "detCorte.fecIniFondo",
		fecFinFondo: "detCorte.fecFinFondo",
		montoFondo: "detCorte.montoFondo",
		totalVales: "detCorte.totalVales",
		totalVisa: "detCorte.totalVisa",
		totalBac: "detCorte.totalBac",
		totalEfectivoQ: "detCorte.totalEfectivoQ",
		totalVentas: "detCorte.totalVentas",
		diferencia: "detCorte.diferencia",
		detalleVentas: [
			{ sku: "1", nombre: "uno", cant: "1.00", total: "80" },
			{ sku: "2", nombre: "uno", cant: "1.00", total: "80" },
			{ sku: "3", nombre: "uno", cant: "1.00", total: "80" },
		],
	};

	$.post(
		host,
		params
	).done(function(res){
        //alert(res);
    });
}

function localPrinter(params, pService){
    
    params.service = pService;

    var settings = {
        "url": "http://localhost/",
        "method": "POST",
        "timeout": 0,
        "headers": {
          "Content-Type": "application/json"
        },
        "data": JSON.stringify(params),
        "dataType": "json"
    };
      
    $.ajax(settings).done(function (response) {
        console.log(response);
    }).fail(function() {
        console.log( params );
    });

}