$(document).ready(function() {
    listaCreditosGeneral();
    $("#modalCreditoCliente").modal();
    $("#modalAbonoCliente").modal();
    resizeDOMHeights();

}); 

$("#cantidadEfectivo").on("keyup",function() {
    var abono =  accounting.unformat($("#efectivoPagoAbono").val());
    let calcCambio = $("#cambio").val(); 
    var valor = 0;
    $("#cantidadEfectivo").each(function (index) {
        valor += accounting.unformat($(this).val());
        calcCambio = valor - abono;
        if(calcCambio < 0 ){
            calcCambio = 0
        }
    });
    $("#cambio").val(accounting.formatNumber(calcCambio, 2));
});

function listaCreditosGeneral() {
    $("#loader").show();
    params = {
        service: 'listaCreditos',
        dbName: dbName,
        idEmpresas: localStorage.idEmpresas
    };
    $('#dataTableClientes').DataTable().clear().destroy()
    $.post(host, params, function(data) {
        var totalCredito = 0;
        $.each(data, function(key, val){
            totalCredito += accounting.unformat(val.saldo_actual);
        });

        $('#dataTableClientes').DataTable().clear().destroy()
        $('#dataTableClientes').DataTable({
            responsive: true,
            fixedHeader: true,
            lengthChange: false,
            bDestroy: true,
            pageLength: 10,
            columnDefs: [
                { 
                    targets: [0, 2],
                    className: "text-center", 
                    width: 20
                }
            ],
            oLanguage: { "sSearch": "" }, 
            language: {
                lengthMenu: "Mostrar _MENU_ registros por pagina",
                zeroRecords: "No se encontraron resultados en su busqueda",
                searchPlaceholder: "Buscar registros",
                info: "Mostrando registros de _START_ al _END_ de un total de  _TOTAL_ registros.",
                infoEmpty: "No existen registros",
                infoFiltered: "(filtrado de un total de _MAX_ registros)",
                paginate: {
                    first: "Primero",
                    last: "Último",
                    next: "Siguiente",
                    previous: "Anterior"
                },
            },
            bAutoWidth: false,
            data: JSON.parse(JSON.stringify(data)),
            columns: [
            { data: "codigoC" },
            { 
                "title": 'Nombre Cliente',
                "data": "nombreC",
                "render": function (data, type, row) {
                    let infoCliente;
                    infoCliente = `<div style="cursor:pointer" id="infoCliente" onclick="listaCreditosCliente(${row['idClientes']},'${row['nombreC']}')">${row['nombreC']}</div>`;
                    return infoCliente; 
                },
            },
            { data: "nitC" },
            { data: "telefonoC" },
            { 
                "title": 'Deuda',
                "data": "saldo_actual",
                "render": function (data, type, row) {
                    let deuda;
                    deuda = `<div>Q ${row['saldo_actual']}</div>`;
                    return deuda; 
                },
            },
            ]
        });
        
        var summary = `<div>Total Cr&eacute;ditos: Q ${accounting.formatNumber(totalCredito,2)}</div>`;
        $("#totalCredito").html(summary);
        
    }, 'json').done(function(){
        $("#loader").hide();
    });
}

function listaCreditosCliente(idCliente,nombreCliente){
    $("#loader").show();
    params = {
		service: "creditosCliente",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idCliente: idCliente 
	};

    $('#dataTableClientesCreditos').DataTable().clear().destroy()
	$.post(host, params, function (data) {
        var component = ``;
        component = `<div style="margin-top: 10px;font-size: large;"><b>Nombre del Cliente:</b> ${nombreCliente}</div>`    
		$.each(data, function (key, val) {
		});

        $('#dataTableClientesCreditos').DataTable().clear().destroy()
        $('#dataTableClientesCreditos').DataTable({
            responsive: true,
            fixedHeader: true,
            lengthChange: false,
            bDestroy: true,
            pageLength: 3,
            oLanguage: { "sSearch": "" }, 
            language: {
                lengthMenu: "Mostrar _MENU_ registros por pagina",
                zeroRecords: "No se encontraron resultados en su busqueda",
                searchPlaceholder: "Buscar registros",
                info: "Mostrando registros de _START_ al _END_ de un total de  _TOTAL_ registros.",
                infoEmpty: "No existen registros",
                infoFiltered: "(filtrado de un total de _MAX_ registros)",
                paginate: {
                    first: "Primero",
                    last: "Último",
                    next: "Siguiente",
                    previous: "Anterior"
                },
            },
            order: [[ 1, "asc" ]],
            data: JSON.parse(JSON.stringify(data)),
            columns: [
            { data: "idVentas" },
            { data: "serie" },
            { data: "correlativo" },
            { data: "fechaFactura" },
            { data: "fechaVencimiento" },
            {
                "title": 'TIPO TRANSACCION',
                "data": "tipoTransaccion",
                "render": function (data, type, row) {
                    let transaccion;
                    if(row['tipoTransaccion'] == '0'){
                        transaccion = `<div>Recibo</div>`;
                    }
                    else{
                        transaccion = `<div>Factura</div>`;
                    }
                    return transaccion; 
                },
            },
            {
                "title": 'CREDITO',
                "data": "saldo",
                "render": function (data, type, row) {
                    let credito;
                    let totalCredito = (accounting.unformat(row['total']) - accounting.unformat(row['anticipo']))
                    credito = `<div>Q ${accounting.format(totalCredito,2)}</div>`;
                    return credito; 
                },
            },
            //{ data: "abonos" },
            {
                "title": 'ANTICIPO',
                "data": "anticipo",
                "render": function (data, type, row) {
                    let anticipo;
                    anticipo = `<div>Q ${accounting.format(row['anticipo'],2)}</div>`;
                    return anticipo; 
                },
            },
            { 
                "title": 'SALDO',
                "data": "saldo",
                "render": function (data, type, row) {
                    let abonar;
                    abonar = `<div id="abonar" style="cursor:pointer" onclick="modalAbonar(${row['idVentas']},${row['idClientes']},'${row['saldo']}','${nombreCliente}','${row['anticipo']}','${row['saldo_actual']}')">Q ${accounting.format(row['saldo'],2)}</div>`;
                    return abonar; 
                },
             },
            ]
        });

        $("#modal-title").html(`Cr&eacute;ditos del Cliente`);
        if(localStorage.isMobile == "false"){
            $("#modalCreditoCliente").modal("open");
        }
        $("#modalCliente").show();
        $("#headerClienteCreditos").html(component);
        listaAbonosCliente(idCliente);

	},
    "json",
    ).done(function () {
    $("#loader").hide();
    });   
}

function listaAbonosCliente(idCliente){
    $("#loader").show();
    params = {
		service: "abonosCliente",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idCliente: idCliente 
	};

    $('#dataTableClientesAbonos').DataTable().clear().destroy()
	$.post(host, params, function (data) {  
		$.each(data, function (key, val) {
		});

        $('#dataTableClientesAbonos').DataTable().clear().destroy()
        $('#dataTableClientesAbonos').DataTable({
            responsive: true,
            fixedHeader: true,
            lengthChange: false,
            bDestroy: true,
            pageLength: 3,
            oLanguage: { "sSearch": "" }, 
            language: {
                lengthMenu: "Mostrar _MENU_ registros por pagina",
                zeroRecords: "No se encontraron resultados en su busqueda",
                searchPlaceholder: "Buscar registros",
                info: "Mostrando registros de _START_ al _END_ de un total de  _TOTAL_ registros.",
                infoEmpty: "No existen registros",
                infoFiltered: "(filtrado de un total de _MAX_ registros)",
                //search: "Buscar:",
                paginate: {
                    first: "Primero",
                    last: "Último",
                    next: "Siguiente",
                    previous: "Anterior"
                },
            },
            order: [[ 1, "desc" ]],
            data: JSON.parse(JSON.stringify(data)),
            columns: [
            {
                "title": '<i class="Small material-icons">receipt</i>',
                "data": "abonos",
                "render": function (data, type, row) {
                    return `<center><i class="Small material-icons" style="cursor:pointer;color:#00897b;" onclick="imprimirAbono(${row['idClientes']})">receipt</i></center>`;
                }
            },
            { data: "idVentas" },
            { data: "serie" },
            { data: "correlativo" },
            { data: "fechaFactura" },
            { data: "fechaVencimiento" },
            { 
                "title": 'TIPO TRANSAC',
                "data": "tipoTransaccion",
                "render": function (data, type, row) {
                    let transaccion;
                    if(row['tipoTransaccion'] == '0'){
                        transaccion = `<div>Recibo</div>`;
                    }
                    else{
                        transaccion = `<div>Factura</div>`;
                    }
                    return transaccion; 
                },
            },
            { 
                "title": 'CREDITO',
                "data": "saldo",
                "render": function (data, type, row) {
                    let credito;
                    let totalCredito = (accounting.unformat(row['total']) - accounting.unformat(row['anticipo']))
                    credito = `<div>Q ${accounting.format(totalCredito,2)}</div>`;
                    return credito; 
                },
            },
            { 
                "title": 'ABONOS',
                "data": "abonos",
                "render": function (data, type, row) {
                    let abonos;
                    abonos = `<div>Q ${accounting.format(row['abonos'],2)}</div>`;
                    return abonos; 
                },
            },
            { 
                "title": 'SALDO',
                "data": "saldo",
                "render": function (data, type, row) {
                    let saldo;
                    saldo = `<div>Q ${accounting.format(row['saldo'],2)}</div>`;
                    return saldo; 
                },
            },
            ]
        });
	},
    "json",
    ).done(function () {
    $("#loader").hide();
});    
}

//TotalSaldo es para el saldo individual de la compra
function modalAbonar(idVenta,idCliente,totalSaldo,nombreCliente,anticipo,saldoActual){
    $("#efectivoPagoAbono").val("");
    $("#cambio").val("");
    $("#cantidadEfectivo").val("");
    $("#modal-title-abono").html(`Realizar Abono`);
    if(localStorage.isMobile == "false"){
        $("#modalAbonoCliente").css('top',"10% !important");
        $("#modalAbonoCliente").modal("open");
    }
    $("#modalAbono").show();

	$("#totalRestoAbono").val(accounting.formatNumber(totalSaldo, 2)); 
	$("#efectivoPagoAbono").on("keyup",function() {
		let totalResto = $("#totalRestoAbono").val(); 
		var valor = 0;
		$(".formasPago").each(function (index) {
			valor += accounting.unformat($(this).val());
			totalResto = accounting.unformat(totalSaldo) - valor;
		});
		$("#totalRestoAbono").val(accounting.formatNumber(totalResto, 2));
	});

    var documentoAbono = "";
    var correlativo = "";
    var idDocumento = "";
    params = {
        service: "getDocumentoAbono",
        dbName: dbName,
        idEmpresas: localStorage.idEmpresas,
        idUsuarios: localStorage.idUsuarios,
    };
    $.post(host, params, function (data) {
            if (data !== null) {
                $.each(data, function (key, val) {
                    documentoAbono = val.documento;
                    correlativo = val.correlativo;
                    idDocumento = val.id;
                });
            }

        var component = ``;
        component = `<div class="waves-effect waves-light btn-large shapedbox" style="background-color: #ff8f00;margin-top: 10px;" 
        onclick="abonar(${idVenta},${idCliente},${totalSaldo},'${nombreCliente}',${anticipo},${saldoActual},'${documentoAbono}','${idDocumento}','${correlativo}')">ABONAR</div>`;
        $("#btnAbonar").html(component);

    }, "json");
    
    
}

function abonar(idVenta,idCliente,totalSaldo,nombreCliente,anticipo,saldoActual,documento,idDocumento,correlativo){

    if($("#totalRestoAbono").val() < 0 || $("#totalRestoAbono").val() > totalSaldo || $("#efectivoPagoAbono").val() == "" || $("#cantidadEfectivo").val() == ""){
        Swal.fire({
            icon: "warning",
            text: "Debe ingresar montos validos.",
            showCloseButton: true,
            confirmButtonText: "Intentar de nuevo",
            confirmButtonColor: "#3085d6",
        }).then((result) => {});
    }else{     
        var observaciones = $("#observacionesAbono").val().replace(/[_\W]+/g, " ");
        var abono = accounting.unformat($("#efectivoPagoAbono").val());
        var newSaldo = accounting.unformat(totalSaldo) - abono;
        //var newSaldoActual = saldoActual - abono;
        var newAnticipo = abono + accounting.unformat(anticipo);
        
        params = {
            service: "guardarAbono",
            dbName: dbName,
            idVentas: idVenta,
            idClientes: idCliente,
            //saldoAnterior: saldoActual, // pero trae el saldo actual de esa venta, hay que traer el mas reciente
            abonos: abono,
            //saldoActual: newSaldoActual,
            idTipoTransacciones: 2, 
            idUsuarios: localStorage.idUsuarios,
            anticipo: newAnticipo,
            saldo: newSaldo,
            observaciones: observaciones,
            idEmpresas: localStorage.idEmpresas,
            documento: documento,
            idDocumento: idDocumento,
            correlativo: correlativo
        };
        
        $.post(host, params, function (data) {
            //
        }, "json").done(function () {
            Swal.fire({
                icon: 'success',
                html: 'Abono realizado con &#233;xito',
                showConfirmButton: false,
                timer: 1500
            });
            listaCreditosCliente(idCliente,nombreCliente);
            listaAbonosCliente(idCliente);
            listaCreditosGeneral();
            $("#modalAbonoCliente").modal("close");
            imprimirAbono(idCliente);
        });
        
    }
}

function imprimirAbono(idCliente){
    params = {
		service: "datosAbono",
		dbName: dbName,
        idCliente: idCliente,
		idEmpresas: localStorage.idEmpresas
	};
	$.post(host, params, function (data) {
		$.each(data, function (key, val) {
            console.log(val);
            val.openCashDrawer = true;
			localPrinter(val, "printAbono");
		});
	}, "json",);
}