const muestraIMGS = true;
//const barcodeFormat = "0ppppppwwwwww";
/*
const barcodeFormat = "pccccccwwwwww";
const prefixNum = "3";
*/
//CHALOS
const barcodeFormat = "ppcccccvvvvvv";
const prefixNum = "11";


$(document).ready(function () {
	//Ajustar altura de elementos del DOM
	resizeDOMHeights();
	
	// *Limpia Campos de autorizacion
	$("#usuario").val("");
	$("#password").val("");	

	//Inicializa el switch de Recibo/Factura
	$("#chkTipoTransaccion").change(function () {
		if ($(this).is(":checked")) {
			if(!$('#tipoVenta').is(":checked")){
				$("#nit").val("");
				$("#nombre").val("");
				$("#direccion").val("");
			}else{
				$("#divReferencia").slideDown();
			}
			$("#divNIT").slideDown();
			$("#divDireccion").slideDown();
			
			//Validacion para NIT extranjero.
			/*
			if (nitExt == true ){
				$("#nombre").attr("readonly", false);
				$("#direccion").attr("readonly", false);
			} else {
				$("#nombre").attr("readonly", true);
			}*/
		} else {
			if(!$('#tipoVenta').is(":checked")){
				$("#nit").val("");
				$("#direccion").val("");
			}else{
				$("#divReferencia").slideUp();
			}
			$("#divNIT").slideUp();
			$("#divDireccion").slideUp();
			$("#nombre").attr("readonly", false);
		}

		
	});

	$("#tipoVenta").change(function () {
		if ($(this).is(":checked")) {
			//Crédito:
			$("#btnCobrar").removeClass("disabled");
			$("#btnCobrar").addClass("pulse");
		} else {
			//Contado:
			$('#btnCobrar').addClass('disabled');
			$("#btnCobrar").removeClass("pulse");
		}
	});
	
    if(localStorage.touchEnabled == "false"){
        $("#nit").removeAttr('readonly');
        $("#nit").focus();
    }
	createNumPad("divNumPadValeMobile", "montoVale", ".", "", "confirm");

	/*
	$('select').select2({
		dropdownParent: $('#modalCuenta')
	});
	*/

	getProductosPrecio();
});

onScan.attachTo(document, {
	onScan: function (sCode, iQty) {
		let CodLength = barcodeFormat.length;
		let prefixLen = prefixNum.length;
		let prefix = sCode.slice(0, prefixLen);

		if (prefix == prefixNum) {
			let countC = (barcodeFormat.match(/c/g) || []).length;
			let countW = (barcodeFormat.match(/w/g) || []).length;

			let countV = (barcodeFormat.match(/v/g) || []).length;

			let indexC = barcodeFormat.indexOf("c");
			let indexW = barcodeFormat.indexOf("w");

			let indexV = barcodeFormat.indexOf("v");
			let orderC;
			let valueORweight;

			if (countW > 0){
				valueORweight = "weight";
				orderC = indexC > indexW ? ["w", "c"] : ["c", "w"];
			} else if(countV > 0){
				valueORweight = "value";
				orderC = indexC > indexV ? ["v", "c"] : ["c", "v"];
			}
				

			let peso, sku, precio;

			$.each(orderC, function (index, chr) {
				switch (chr) {
					case "w":
						peso = sCode.slice(indexW, indexW + countW);
						break;
					//CHALOS
					case "v":
						precio = sCode.slice(indexV, indexV + countV);
						break;
					case "c":
						skuStr = sCode.slice(indexC, indexC + countC);
						sku = parseInt(skuStr);
						break;
				}
			});
			let centena, decena;
			if (countW > 0){
				centena = peso.substr(0, 3);
				decena = peso.substr(3, 6);
			} else if(countV > 0){
				centena = precio.substr(0, 3);
				decena = precio.substr(3, 6);
			}

			let cantidad = parseFloat(centena + "." + decena);

			getIdProducto(sku, cantidad, valueORweight);
		} else {
			let sku = parseInt(sCode);
			getIdProducto(sku, 1);
		}
	},
});



function tipoDeVenta(){
	if ($('#tipoVenta').is(":checked")) {
		$("#loader").show();
		modalCredito();
	} else {
		confirmCompra();
	}
}

function modalCredito(){
	$("#loader").hide();

	$('#modalCuenta').css('height','60%');
	$('#btnCobrar').addClass('disabled');
	$("#btnCobrar").removeClass("pulse");

	//Creacion del modal para venta en Credito
	$("#divFormasPago").slideUp();
	$("#searchClient").slideDown(); 
	$("#iCloseModal1").attr("onclick","cerrarModal();");

	getClientes();
}

function getClientes(){
	params = {
		service: "getClientes",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas
	};
	$.post(host, params, function (data) {
		let productos = `<option value=""></option>`;
		$.each(data, function (key, val) {
			productos += `<option value="${val.id}">${val.codigoC} - ${val.nombreC} - ${val.nitC}</option>`;
		});
		$("#selectClientes").html(productos);

		$('#selectClientes').select2({
			placeholder: "Buscar Clientes...",
			dropdownParent: $('#modalCuenta'),
			width: '50%'
		});
	}, "json",);
}

function getSaldoCliente() {
	
	if($('#selectClientes').val() == ""){
		Swal.fire({
			icon: "warning",
			title: "Seleccione un Cliente",
			showCloseButton: true,
			confirmButtonText: "Intentar de nuevo"
		}).then((result) => {});
	}else{
		var idCliente = $('#selectClientes').val();
		params = {
			service: "getSaldoCliente",
			dbName: dbName,
			idEmpresas: localStorage.idEmpresas,
			idCliente: idCliente 
		};
		$.post(host, params, function (data) {
			$.each(data, function (key, val) {
				if(val.saldo_actual == null){
					val.saldo_actual = 0;
				}
				var nuevoSaldoActual = accounting.unformat($('#TxtSaldo').val()) + accounting.unformat(val.saldo_actual);
				if(nuevoSaldoActual > val.limiteCredito){
					Swal.fire({
						icon: "warning",
						title: "El cliente supera el l&iacute;mite de cr&eacute;dito",
						showCloseButton: true,
						confirmButtonText: "Aceptar"
					}).then((result) => {});
				}else{
					$("#nit").val(val.nitC);
					$("#nombre").val(val.nombreC);
					$("#direccion").val(val.direccionC);

					$("#idCliente").val(val.idCliente);
					$("#saldoAnterior").val(accounting.unformat(val.saldo_actual));
					$("#saldoActual").val(nuevoSaldoActual);

					confirmCompra();
				}
			});
		},"json");
	}
}

function guardarSaldoActual(){
	var idCliente = $("#idCliente").val();
	var saldoAnterior = $("#saldoAnterior").val();
	var saldoActual = $("#saldoActual").val();
	var referenciaInterna = $("#referenciaInterna").val();

	params = {
		service: "guardarSaldo",
		dbName: dbName,
		idUsuarios: localStorage.idUsuarios,
		idCliente: idCliente,
		saldoAnterior: saldoAnterior,
		saldoActual: saldoActual,
		idTipoTransacciones: 1,
		idEmpresas: localStorage.idEmpresas,
		referenciaInterna: referenciaInterna
	};
	$.post(host, params, function (data) {
	}, "json").done(function () {});
}

function getCategorias() {
	params = {
		service: "getCategorias",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
	};
	$.post(host, params, function (data) {
			$("#categorias").html("");
			var component = "";
			$.each(data, function (key, val) {
				component += `<li class='tab'>`;
				component += `<a onclick='getProductosCategorias(${val.id});'>${val.descripcion}</a></li>`;
			});
			$("#categorias").html(component);
			$(".tabs").tabs();
		},
		"json",
	);
}
  
function swalPrecioPublico(
	idProductos,
	existencia,
	idTipoProductos,
	producto,
	cantidad,
) {
	if(propina){
		var getPropina = new Promise(function(myResolve, myReject) {
			let valTotal = parseFloat($('#total').val());
			let pCalculada = 0;
		
			pCalculada = accounting.formatNumber((valTotal * 0.1), 2);
		
			myResolve(pCalculada);
		});
	}
	else{
		var getPropina = 1;
	}

	Swal.fire({
		title: "Ingresa el precio:",
		input: "number",
		showConfirmButton: true,
		confirmButtonColor: "#3085d6",
		showCancelButton: true,
		inputValue: getPropina,
		inputAttributes: {
			min: 0.01
		},
		inputValidator: (value) => {
			if (!value) {
				return "Necesitas escribir el precio";
			}
			if (value == 0) {
				return "El precio no puede ser cero";
			}
		},
	}).then((result) => {
		precioPublico = parseFloat(result.value);
		// console.log('result.value :>> ', precioPublico);
		if (result.isConfirmed) {
			agregarProductoVenta(
				idProductos,
				existencia,
				idTipoProductos,
				producto,
				cantidad,
				precioPublico,
				0,
				$("#precioDolar").val(),
				0
			);
		}
	});
	
}
//Mostrar las opciones del producto
function opcionesProducto(id,existencia,idTipoProductos,descLarga,precioPublico,precioDolar){
	$("#loader").hide();
	var idProducto = id;
	params = {
		service: "opcionesProducto",
		dbName: dbName,
		id: idProducto,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};
	$.post(host, params, function (data) {
 
		var opcionesBody = ``;
		var opcionTemp = ``;

		$.each(data, function (key, val) {

			if (opcionTemp != val.opcionPrincipal.toUpperCase()){
				if (localStorage.isMobile == "true"){
					opcionesBody += `</div>
									<div class="col s12"  style="padding-left: 0px;">	
									`;
				}else{
					opcionesBody += `</div>
									<div class="col s6"  style="padding-left: 0px;">	
									`;
				}
				opcionesBody += `
							</br> 
							<input type="hidden" class="opc" name value="${val.opcionPrincipal}"/>
							
							</br> 
								${val.opcionPrincipal.toUpperCase()}
							
							</br>
							`;
				opcionTemp = val.opcionPrincipal.toUpperCase();
			}; 

			opcionesBody += 
			`	
			<label style="padding-left: 0px;">
        	<input class="with-gap" name="${val.opcionPrincipal}" type="radio" value="${val.opcionName}" />
       		<span>${val.opcionName}</span>
			</label>
			`;
			
		});
		opcionesBody += `</div>`;
		opcionesBody += `<input type="hidden" id="arrGlobal"/><div class='col s12 center-align' style="margin-top: 15px;">
		<button class="waves-effect waves-light btn-large shapedbox middle-align" style="background-color: #ff8f00 !important" onclick="opcionesChecked(${id},${existencia},${idTipoProductos},'${descLarga}', ${precioPublico}, ${precioDolar})">Agregar</button>
		</div>`;
		
		$("#divModalContent").html(opcionesBody);
		$("#modal1 .modal-content").attr("style","padding-top: 0px");
		$("#modal-title").html(descLarga);
		$("#iCloseModal1").attr("onclick","cerrarModal();");

		if(localStorage.isMobile == "false"){
			$("#modal1").modal("open");
		}
		
	}, "json",);
}

//Guardar las opciones seleccionadas del producto
function opcionesChecked(id,existencia,idTipoProductos,descLarga,precioPublico,precioDolar){
	if (localStorage.isMobile == "false"){
		$("#modal1").modal("close");
	}

	let listOpc = $(".opc");   
	var arrGlobal = [];

	for (var i = 0; i < listOpc.length; i++) {   
		var opcPrincipal =  listOpc[i].value;

		$(`input[name="${opcPrincipal}"]:checked`).each(function() {
			var arr = {};
			arr["opcion"] = listOpc[i].value;
			arr["subopcion"] = this.value;
			arrGlobal.push(arr);
		});
	} 
	agregarProductoVenta(id,existencia,idTipoProductos,descLarga,'1',precioPublico,arrGlobal,precioDolar,0);
}

function guardarOpciones(id,arrGlobal){
	$("#loader").show();
	params = {
		service: "guardarOpciones",
		idProducto: id,
		dbName: dbName,
		arrGlobal : arrGlobal
	};

	$.post(host, params, function (data) {
		$.each(data, function (key, val) {
		});
	},"json",
	).done(function () {
		$("#loader").hide();
		loadProductosVenta();
	});
}

// Obtine el ID de un producto por medio del sku
// ? tipo: weight or value
function getIdProducto(sku, cantidad, tipo) {
	params = {
		service: "getIdProducto",
		sku: sku,
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales,
		idUsuarios: localStorage.idUsuarios,
	};

	$("#loader").show();

	$.post(host, params, function (data) {
			$.each(data, function (key, val) {
				// ! Revisar respuesta del API, siempre responde success 
				switch (val.message) {
					case "success":
						if (val.precioPublico == 0) {
							swalPrecioPublico(
								val.idProducto,
								val.existencia,
								val.idTipoProductos,
								val.descLarga,
								cantidad,
							);
						} else if(val.idProducto === null){
								Swal.fire({
									title: `${sku}`,
									html: `Codigo no registrado. Intente ingresar el producto manualmente`,
									icon: "warning",
									confirmButtonColor: "#3085d6",
									confirmButtonText: "Ok",
								}).then((result) => {});

						} else {
							let vPrecio, vCantidad;
							switch(tipo){
								case 'weight':
									vCantidad = cantidad;
									vPrecio = cantidad * val.precioPublico;
									break;
								case 'value':
									vCantidad = (cantidad / val.precioPublico).toFixed(3);
									vPrecio = val.precioPublico;
									break;
								default:
									vCantidad = cantidad;
									vPrecio = val.precioPublico;
									break;
							}
							agregarProductoVenta(
								val.idProducto,
								val.existencia,
								val.idTipoProductos,
								val.descLarga,
								vCantidad,
								vPrecio, 
								0,
								$("#precioDolar").val(),
								0
							);
						}
						break;
					case "no_existe":
						Swal.fire({
							title: `${val.barcode}`,
							html: `Código no registrado.`,
							icon: "warning",
							confirmButtonColor: "#3085d6",
							confirmButtonText: "Ok",
						}).then((result) => {});
						break;
					default:
						alert(`Error ID ${val}`);
						break;
				}
			});
		},
		"json",
	).done(function () {
		$("#loader").hide();
	});
}

// Agrega un producto al carrito
function agregarProductoVenta(
	idProductos,
	existencia,
	idTipoProductos,
	producto,
	cantidad,
	precioPublico, 
	arrGlobal,
	precioDolar,
	agrupar
) {
	if (localStorage.isMobile == "false"){
		$("#mm").modal("close");
	}

	if(precioDolar == undefined){ //Para cuando no se manejan precios en dolares
		precioDolar = '0.00';
	}

	params = {
		service: "agregarProductoVenta",
		idProductos: idProductos,
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales,
		idUsuarios: localStorage.idUsuarios,
		cantidad: cantidad,
		precioPublico: precioPublico,
		precioDolar: precioDolar,
		agrupar: agrupar
	};

	$("#loader").show();
	if (idTipoProductos === 1) {
		if (accounting.unformat(existencia) > 0) {
			$.post(host,params,function (data) {
				$.each(data, function (key, val) {
						switch (val.message) {
							case "success":
								if (arrGlobal == 0){
									if(localStorage.isMobile == 'true'){
										returnProductos();
									}
									else{
										loadProductosVenta();
									}
									
								}else{
									guardarOpciones(idProductos,arrGlobal);
								}
								break;
							case "sin_existencia":
								errorMsg = `No hay existencias de componentes del producto: ${producto} \n`;
								errorMsg += "Producto: " + val.producto + "\n";
								errorMsg +=
									"Exitencia: " + val.existencia + "\n";
								errorMsg +=
									"Cantidad solicitada: " +
									val.cantidad +
									"\n";

								Swal.fire({
									title: `${producto}`,
									text: `No hay existencias de los componentes`,
									icon: "warning",
									confirmButtonColor: "#3085d6",
									confirmButtonText: "Ok",
								}).then((result) => {});

								break;
							default:
								alert(`Error PROD ${val.error}`);
								break;
						}
					});
				},
				"json",
			).done(function () {
				$("#loader").hide();
			});
		}
	} else {
		$.post(host, params, function (data) {
				$.each(data, function (key, val) {
					switch (val.message) {
						case "success":
							if (arrGlobal == 0){
								if(localStorage.isMobile == 'true'){
									returnProductos();
								}
								else{
									loadProductosVenta();
								}
								
							}else{
								guardarOpciones(idProductos,arrGlobal);
							}
							break;
						case "sin_existencia":
							errorMsg = `No hay existencias de componentes del producto: ${producto} \n`;
							errorMsg += "Producto: " + val.producto + "\n";
							errorMsg += "Exitencia: " + val.existencia + "\n";
							errorMsg +=
								"Cantidad solicitada: " + val.cantidad + "\n";

							Swal.fire({
								title: `${producto}`,
								text: `No hay existencias de los componentes`,
								icon: "warning",
								confirmButtonColor: "#3085d6",
								confirmButtonText: "Ok",
							}).then((result) => {});

							break;
						default:
							alert(`Error ${val.error}`);
							break;
					}
				});
			},
			"json",
		).done(function () {
			$("#loader").hide();
		});
	}
}

// Swal que muestra las opciones de un producto en el carrito
function menuOpciones(id, descLarga, total, cantidad,idProductos,precioDolares) {

	if(localStorage.isMobile == "true"){
		if(ATO){
			eliminarProductoVenta(id,descLarga,idProductos);
		}
		else {
			Swal.fire({
				title: `${descLarga}`,   
				html: `<button class="btn-large full-width shapedbox" style="background-color:#e53935 !important;margin-bottom: 15px;" onclick="eliminarProductoVenta(${id},'${descLarga}',${idProductos});">Borrar</button><br/>
				<button class="btn-large full-width shapedbox" style="background-color: #8bc34a !important;margin-bottom: 15px;" onclick="swalDescuento(${id},'${total}','${descLarga}','${cantidad}',${precioDolares})">Aplicar Descuento</button><br/>
				<button class="btn-large full-width shapedbox" style="background-color:#42a5f5 !important;margin-bottom: 15px;">Pesar</button><br/>
				<button class="btn-large full-width shapedbox" style="background-color:#ffee58  !important;margin-bottom: 15px;">Editar Cantidad</button><br/>`,
				showConfirmButton: false,
				showCancelButton: false,
				//cancelButtonColor: '#d33',
				cancelButtonText: "Cancelar",
				customClass: {
					container: 'my-swalMobile' //Utiliza una clase distinta por z-index
				}
			}).then((result) => {})
		}
	}else{
		Swal.fire({
			title: `${descLarga}`,   
			html: `<button class="btn-large full-width shapedbox" style="background-color:#e53935 !important;margin-bottom: 15px;" onclick="autorizarEliminacion(${id},'${descLarga}',${idProductos});">Borrar</button><br/>
			<button class="btn-large full-width shapedbox" style="background-color: #8bc34a !important;margin-bottom: 15px;" onclick="swalDescuento(${id},'${total}','${descLarga}','${cantidad}',${precioDolares})">Aplicar Descuento</button><br/>
			<button class="btn-large full-width shapedbox" style="background-color:#455a64 !important;margin-bottom: 15px;" onclick="modalEditarCantidad(${id},'${descLarga}',${idProductos},${cantidad});">Editar Cantidad</button><br/>
			<button class="btn-large full-width shapedbox" style="background-color:#42a5f5 !important;margin-bottom: 15px;">Pesar</button><br/>`,
			showConfirmButton: false,
			showCancelButton: false,
			//cancelButtonColor: '#d33',
			cancelButtonText: "Cancelar",
			customClass: {
				container: 'my-swal'
			}
		}).then((result) => {})
	}
};

function modalEditarCantidad(id, descLarga, idProducto,cantidad){
	$("#idDescuento").val(id);

    var modalCantidad = "";
    modalCantidad = `
    <div class="row">
        <div class="col s6 blue-text" style="font-size:1.5em !important;padding-right: 0px; padding-top: 50px;">
            <b>
            <div style="padding-left: 0px;">${descLarga}</div>
            <br/>
            <div class="row">
                <div  class="col s3" style="padding-left: 0px;padding-left: 10px;">Cantidad: </div>
            
                <div  class="col s9" style="text-align: center;">
                    <i class="medium material-icons" onclick="cantidadEdicion('remove')" 
                    style="font-size: 40px;">indeterminate_check_box</i>
                    <input class="big-numbers" type="number" id="editarCantidad" value="1" min="1" style="text-align: center;width: 50%;">
                    <i class="medium material-icons" onclick="cantidadEdicion('add')" 
                    style="font-size: 40px;">add_box</i> 
                </div>	
            </div>
            </b>
        </div>
        <div class="col s6" id="divNumPadCantidad"></div>
    </div>`;

    $("#divModalContent").html(modalCantidad);
	$("#modal-title").html("Editar Cantidad");
    $("#modal1").modal("open");
	$("#iCloseModal1").attr("onclick","cerrarModal();");
    //abrir modal de cantidad
	if(touchEnabled){
		createNumPad("divNumPadCantidad", "editarCantidad", ".", "", "confirm");
	}else{
		assignKeyActionsPrecio();
		$("#editarCantidad").focus().val("").val(cantidad);
	}
	
}

function editarCantidad(){
	$("#loader").show();
	let cantidad = $("#editarCantidad").val();
	let id = $("#idDescuento").val();
	// en el servicio conseguir el precio publico en base al id de la venta

	params = {
		service: "editarCantidadProductos",
		dbName: dbName,
		id: id,
		cantidad: cantidad 
	};
	$.post(host, params, function (data) {
		if (data.message === "success") {
			Swal.fire({
				icon: "success", 
				text: "La cantidad del producto se actualizo correctamente" 
			}).then(function () {
				loadProductosVenta();
				$("#modal1").modal("close");
			});
		} else {
			alert(`Error: ${data.Query}`);
		}
	}, "json").done(function () {
		$("#loader").hide();
	});

}

function assignKeyActionsPrecio(){
	$('#editarCantidad').keypress(function(event){
		var keycode = (event.keyCode ? event.keyCode : event.which);
		if(keycode == '13'){
			fnConfirm('confirm', 'editarCantidad');
		}
	});
}



function cantidadEdicion(boton){
    let precio = accounting.unformat($("#inputPrecio").val());
	let contador = $("#editarCantidad").get(0).value;
    let int = parseInt(contador, 10);

    if (boton == 'add'){
        $("#editarCantidad").get(0).value = int +1;
    } else {
        $("#editarCantidad").get(0).value = int -1;
        if ($("#editarCantidad").get(0).value < 1){
            $("#editarCantidad").get(0).value = 1;
        }
	}
	let moneda = ($("#tipoMoneda").val() == "2")? "$":"Q";
	let total = $("#editarCantidad").get(0).value * precio;
	$("#mTotal").val(accounting.formatMoney(total, moneda, 2));
}

function cantidad(boton){
    let precio = accounting.unformat($("#inputPrecio").val());
	let contador = $("#contador").get(0).value;
    let int = parseInt(contador, 10);

    if (boton == 'add'){
        $("#contador").get(0).value = int +1;
    } else {
        $("#contador").get(0).value = int -1;
        if ($("#contador").get(0).value < 1){
            $("#contador").get(0).value = 1;
        }
	}
	let moneda = ($("#tipoMoneda").val() == "2")? "$":"Q";
	let total = $("#contador").get(0).value * precio;
	$("#mTotal").val(accounting.formatMoney(total, moneda, 2));
}

function modalDescuento(){
	$("#loader").hide();
	var subtotal;

	if ($("#tipoMoneda").val() == "2"){ //Si es Dolar:
		subtotal = $("#subtotalD").val();
	}else{
		subtotal = $("#subtotalQ").val();
	}

	let descLarga = $("#descLarga").val();
	let cantidad = (accounting.unformat($("#cantidad").val()));

	//Creacion del modal de Aplicar Descuento con numpad
	var descuentoBody = ("");
	if(localStorage.isMobile == "true"){
		descuentoBody = `<div class="row">
							<div class="col s12 blue-text" style="font-size:1.5em !important;padding-right: 0px;">
								<b>
								<div style="padding-left: 0px;">${descLarga}</div>
								<div style="padding-left: 0px;">Cantidad: ${cantidad}</div>
								<br/>
								<div>
									<div class="col s6" style="padding-left: 0px;">Sub-total: Q</div>
									<div id="subtotal"  class="big-numbers col s6" style="padding-left: 0px; padding-right: 0px;">${subtotal}</div>
								</div>
								<br/>
								<div class="input-field">
									<div class="col s5" style="padding-left: 0px;">Descuento: </div>
									<div id="percent" class="col s2" style="visibility:hidden;">%</div>
									<input type="text" id="inputDescuento" class="big-numbers col s5" style="" disabled>
								</div>
								<br/>
								<div>
									<div class="col s7" style="padding-left: 0px;">Total: Q</div>
									<input type="text" id="outputDescuento" class="big-numbers col s5" style="" disabled>
								</div>
								</b>
							</div>
							<div class="col s12" id="divNumPadDesc"></div>
						</div>`;
	} else {
		descuentoBody = `<div class="row">
							<div class="col s6 blue-text" style="font-size:1.5em !important;padding-right: 0px;">
								<b>
								<div style="padding-left: 0px;">${descLarga}</div>
								<div style="padding-left: 0px;">Cantidad: ${cantidad}</div>
								<br/>
								<div>
									<div class="col s6" style="padding-left: 0px;">Sub-total: Q</div>
									<div id="subtotal"  class="big-numbers col s6" style="padding-left: 0px; padding-right: 0px;">${subtotal}</div>
								</div>
								<br/>
								<div class="input-field">
									<div class="col s6" style="padding-left: 0px;">Descuento: </div>
									<div id="percent" class="col s2" style="visibility:hidden;">%</div>
									<input type="text" id="inputDescuento" class="big-numbers col s4" style="" disabled>
								</div>
								<br/>
								<div>
									<div class="col s8" style="padding-left: 0px;">Total: Q</div>
								<input type="text" id="outputDescuento" class="big-numbers col s4" style="" disabled="">
								</div>
								</b>
							</div>
							<div class="col s6" id="divNumPadDesc"></div>
						</div>`;
	}
		
	$("#divModalContent").html(descuentoBody);
	$("#modal-title").html("Aplicar Descuento");
	
	$("#inputDescuento").attr("placeholder", "");
	$("#inputDescuento").val("");
	$("#subtotal").val(subtotal); //valor subtotal para utilizarse en el calculo del descuento
	$("#iCloseModal1").attr("onclick","cerrarModal();");

    if(localStorage.touchEnabled == "false"){
        $("#inputDescuento").removeAttr('disabled');
        $("#inputDescuento").focus();
    }

	if(localStorage.isMobile == "false"){
		$("#modal1").modal("open");
		if(localStorage.touchEnabled == 'false'){
			assignKeyActions('inputDescuento', 'confirm'); 
		}
		else{
			createNumPad("divNumPadDesc", "inputDescuento", ".", "percentage", "confirm");
		}
	}
	
	$("#outputDescuento").val(subtotal); //Valor para mostrar en el modal de descuento

	if(localStorage.touchEnabled == 'false'){
		$("#inputDescuento").keyup(function() {
			let totalDescuento = subtotal;
			$("#inputDescuento").each(function() {
				var thisVal = parseFloat($(this).val());
				thisVal = (isNaN(thisVal))? 0: thisVal;
				totalDescuento = totalDescuento - thisVal;
				$("#percent").val(accounting.formatNumber(thisVal, 2));
			});
			$("#outputDescuento").val(accounting.formatNumber(totalDescuento, 2));
		});
	}
	else{
		//Calcular el descuento automaticamente
		$("#inputDescuento").change(function() {
			let totalDescuento = subtotal;
			$("#inputDescuento").each(function() {
				var thisVal = parseFloat($(this).val());
				thisVal = (isNaN(thisVal))? 0: thisVal;
				totalDescuento = totalDescuento - thisVal;
				$("#percent").val(accounting.formatNumber(thisVal, 2));
			});
			$("#outputDescuento").val(accounting.formatNumber(totalDescuento, 2));
		});
	}
	
};

// Muestra modal de autorizacion para el descuento
function swalDescuento(id,subtotal,descLarga,cantidad,precioDolares){
	$("#loader").show();
	if (authDelProd || localStorage.tipoUsuario == "1" || localStorage.tipoUsuario == "2") {
		$("#idDescuento").val(id);
		//$("#subtotalProduc").val(subtotal);

		//Traer subtotal para Q y D
		$("#subtotalQ").val(subtotal);
		$("#subtotalD").val(accounting.formatNumber((precioDolares * cantidad), 2));

		$("#descLarga").val(descLarga);
		$("#cantidad").val(cantidad);
		modalDescuento();
	} else {	
		
		$("#loader").hide();
		$("#opcionAutorizacion").val("descuento");
		$('#usuario').show();
        $('#password').hide();
		$("#iconoPSW").addClass("scale-out");
		$("#iconoPSW").hide();
		$("#iconoUSR").removeClass("scale-out");
		$("#iconoUSR").show();

		if(localStorage.isMobile == "false"){
			$('#divNumPadAutorizacion').empty();
			if(localStorage.touchEnabled == "false"){
				$("#modalAutorizacion").modal("open");
				assignKeyActions('usuario', 'confirm'); 
			}
			else{
				createNumPad("divNumPadAutorizacion","usuario","confirm","","");
				$("#modalAutorizacion").modal("open");
			}
			
		}
		
		$("#idDescuento").val(id);
		//$("#subtotalProduc").val(subtotal);
		$("#subtotalQ").val(subtotal);
		$("#subtotalD").val(accounting.formatNumber((precioDolares * cantidad), 2));
		$("#descLarga").val(descLarga);
		$("#cantidad").val(cantidad);
		huella();
	}
};

// Modal de autorizacion para eliminar un producto
function autorizarEliminacion(id, descLarga,idProductos){
	$("#loader").show();
	if (authDelProd || localStorage.tipoUsuario == "1" || localStorage.tipoUsuario == "2") {
		eliminarProductoVenta(id, descLarga,idProductos);
	} else {	
		// * Creacion de NumPad para el Modal de autorización de eliminacion
		$("#loader").hide();
		$("#opcionAutorizacion").val("eliminar");
		$('#usuario').show();
        $('#password').hide();
		$("#iconoPSW").addClass("scale-out");
		$("#iconoPSW").hide();
		$("#iconoUSR").removeClass("scale-out");
		$("#iconoUSR").show();

		if(localStorage.isMobile == "false"){
			$('#divNumPadAutorizacion').empty();

			if(localStorage.touchEnabled == "false"){
				$("#modalAutorizacion").modal("open");
				assignKeyActions('usuario', 'confirm'); 
			}
			else{
				createNumPad("divNumPadAutorizacion","usuario","confirm","","");
				$("#modalAutorizacion").modal("open");
			}
		}

		$("#descLarga").val(descLarga);
		$("#productoID").val(id);
		$("#idProductos").val(idProductos);
		huella();
	}
};

function loadProductosVenta() {
	
	params = {
		service: "loadProductosVenta",
		dbName: dbName,
		idUsuarios: localStorage.idUsuarios,
		idEmpresas: localStorage.idEmpresas
	};
	$.post(host, params, function (data) {
			drawCart(data);	
		},
		"json",
	).done(function () {
		$("#loader").hide();
	});
}

// Confirmacion para eliminar un item del carrito
function eliminarProductoVenta(id, descLarga,idProductos) {
	$("#loader").hide();
	Swal.fire({
		title: "&iquest;Eliminar Producto?",
		text: `${descLarga}`,
		icon: "warning",
		showCancelButton: true,
		confirmButtonColor: "#3085d6",
		cancelButtonColor: "#d33",
		confirmButtonText: "Si",
		cancelButtonText: "Cancelar",
	}).then((result) => {
		if (result.value) {
			params = {
				service: "eliminarProductoVenta",
				dbName: dbName,
				id: id,
				idProductos: idProductos
			};
			$.post(
				host,
				params,
				function (data) {
					$.each(data, function (key, val) {
						if (val.message === "success") {
							loadProductosVenta();
						} else {
							alert(`Error: ${val.Query}`);
						}
					});
				},
				"json",
			);
		}
	});
}

function valeCaja() {
	$("#divModalContent").html("");
	$("#modal-title").html("VALE DE CAJA");
	$("#iCloseModal1").attr("onclick","cerrarModal();");

	if (localStorage.isMobile == "false"){
		$("#modal1").modal("open");
	}
	component = `
			<div id="valeCaja" class= "col s6">
			<div class='col s6'>
              <label>SOLICITADO POR</label>
              </div>
              <div class='col s6'>
              <input type='text' id="solicitado" class='inputs'/>
              </div>
              <div class='col s6'>
              <label>MONTO</label>
              </div>
              <div class='col s6'>
              <input type='text' id="montoVale" class='big-numbers blue-text' disabled="" />
              </div>
              <div class='col s6'>
              <label>MOTIVO</label>
              </div>
              <div class='col s6'>
              <input type='text' id="motivoVale" class='inputs'/>
              </div>
			</div>
			 <div class="col s6" id="divNumPadVale"></div> 
			  `;

	$("#divModalContent").html(component);
	createNumPad("divNumPadVale", "montoVale", ".", "", "confirm");
	
	if(localStorage.touchEnabled == "false"){
		$("#montoVale").removeAttr('disabled');
		$("#montoVale").focus();
    }
}


function registrarVale() {
	var solicitadoPor = $("#solicitado").val();
	var monto = $("#montoVale").val();
	var observaciones = $("#motivoVale").val();
	var errorMsg = "Corrige los siguiente errores: </br>";
	var flag = true;

	if (!solicitadoPor) {
		flag = false;
		errorMsg += "Ingrese nombre del solicitante </br>";
	}
	if (!monto || monto < 0) {
		flag = false;
		errorMsg += "Ingrese monto del vale </br>";
	}
	/*
	if (!$.isNumeric(monto)) {
		flag = false;
		errorMsg += "Valor en monto incorrecto </br>";
	}*/
	if (!observaciones) {
		flag = false;
		errorMsg += "Ingrese motivo del vale </br>";
	}
	if (flag === false) {
		//alert(errorMsg);
		Swal.fire({
			html: errorMsg,
			icon: "warning",
			confirmButtonColor: "#3085d6",
			confirmButtonText: "Ok",
		}).then((result) => {});
		return false;
	} else {
		params = {
			service: "registrarVale",
			solicitadoPor: solicitadoPor,
			monto: monto,
			observaciones: observaciones,
			dbName: dbName,
			idSucursales: localStorage.idSucursales,
			idUsuarios: localStorage.idUsuarios,
			idEmpresas: localStorage.idEmpresas,
		};
		$.post(
			host,
			params,
			function (respuesta) {
				$.each(respuesta, function (key, val) {
					if (val.message === "success") {
						if (localStorage.isMobile != "true")
							sunmiInnerPrinter.openDrawer();

						//localPrinter(val, "printVale");
						alert("Vale operado exitosamente");
						// if para movil e if para modal
						if (localStorage.isMobile == "true"){
							location.reload();
						}else{
							cerrarModal();
						}

					} else {
						alert("Error al ingresar vale");
					}
				});
			},
			"json",
		);
	}
}

function cerrarModal() {
	// ! modals comentados
	$("#modal1").modal("close");
}

// TODO: Optimizar para cuando se utilicen dolares (switch)
// TODO: Agregarle el campo de dolares (cuando no se usa el switch)
function calcTotal(param) {
	let valSaldo = parseFloat(accounting.unformat($("#TxtSaldo").val()));
	let valTotalFactura = parseFloat(
		accounting.unformat($("#totalFactura").val()),
	);

	// Valida que la cantidad ingresada sea mayor a 0
	if($("#TxtNumPad").val() < 0 ){
		Swal.fire({
		icon: "warning",
		text: "Debe ingresar un monto valido.",
		showCloseButton: true,
		confirmButtonText: "Intentar de nuevo",
		html: "Debe ingresar un monto valido.",
	});
	}else{
		if (valSaldo > 0) {
			let valDolares = 0;
			let valNuevo = parseFloat($("#TxtNumPad").val());
			let valAnterior = parseFloat($("#" + param).val());

			// TODO: Para cobrar en dolares (no facturar en dolares)
			

			valNuevo = isNaN(valNuevo) ? valSaldo : valNuevo;
			valAnterior = isNaN(valAnterior) ? 0 : valAnterior;

			if (param == "TxtEfectivo" || param == "TxtDolares") {
				$("#TxtNumPad").attr("placeholder", "");

				if (valNuevo >= valSaldo) {
					let restante = valNuevo - valSaldo;
					valNuevo = valSaldo;
					valSaldo = accounting.formatNumber(0, 2);

					// if(param == 'TxtDolares'){
					// 	restante = accounting.formatNumber(restante * 7.5, 2);
					// }
					// else{
					// 	restante = accounting.formatNumber(restante, 2);
					// }
					restante = accounting.formatNumber(restante, 2);
					$("#TxtNumPad").attr("placeholder", `Cambio: ${restante}`);
				}
			} else {
				valNuevo = valNuevo > valSaldo ? valSaldo : valNuevo;
			}

			valNuevo = valNuevo + valAnterior;
			$("#" + param).val(accounting.formatNumber(valNuevo, 2));

			// if(param == "TxtDolares"){
			// 	$("#" + param).val(accounting.formatNumber(valDolares, 2));
			// }
			// else{
			// 	$("#" + param).val(accounting.formatNumber(valNuevo, 2));
			// }
			
			let efectivo = parseFloat(accounting.unformat($("#TxtEfectivo").val()));
			let dolares = parseFloat(accounting.unformat($("#TxtDolares").val()));
			//let dolares = valNuevo;
			let visa = parseFloat(accounting.unformat($("#TxtVisa").val()));
			let bac = parseFloat(accounting.unformat($("#TxtBac").val()));
			let descuento = parseFloat(accounting.unformat($("#TxtDescuento").val()));

			efectivo = isNaN(efectivo) ? 0 : efectivo;
			dolares = isNaN(dolares) ? 0 : dolares;
			visa = isNaN(visa) ? 0 : visa;
			bac = isNaN(bac) ? 0 : bac;
			descuento = isNaN(descuento) ? 0 : descuento;
			// ! Multiplicar por tipo de cambio del dia para Cobro multiple con dolares
			// ! dolares = dolares * cambio;
			let valTotal = efectivo + visa + bac + descuento + dolares;
			$("#TxtTotal").val(accounting.formatNumber(valTotal, 2));

			valTotalFactura = isNaN(valTotalFactura) ? 0 : valTotalFactura;

			valSaldo = valTotalFactura - valTotal;
			$("#TxtSaldo").val(accounting.formatNumber(valSaldo, 2));

			$("#TxtNumPad").val("");

			if (valSaldo == 0 || $('#tipoVenta').is(":checked")) {
				if(localStorage.isMobile == 'false'){
					if ($("#btnCobrar").hasClass("disabled")) {
						$("#btnCobrar").removeClass("disabled");
						$("#btnCobrar").addClass("pulse");
					}
				}
				else{
					let attr = $('#btnCobrar').attr('disabled');
					if(typeof attr !== typeof undefined && attr !== false){
						$('#btnCobrar').removeAttr('disabled');
					}
				}
			}
			else{
				if(localStorage.isMobile == 'false'){
					if (!$("#btnCobrar").hasClass("disabled")) {
						$("#btnCobrar").addClass("disabled");
						$("#btnCobrar").removeClass("pulse");
					}
				}
				else{
					let attr = $('#btnCobrar').attr('disabled');
					if(typeof attr == typeof undefined || attr == false){
						$('#btnCobrar').attr('disabled','""');
					}
				}
			}
		}
	}
	
}

// ! Revisar si se sigue usando
// ? Se utilizaba para el descuento general
function calcDescuento(param) {
	if (localStorage.tipoUsuario != "1" && localStorage.tipoUsuario != "2") {
		if (($("#TxtTotal").val()) == ($("#" + param).val())) {
			Swal.fire({icon: "error", text: "Descuento aplicado"});
		} else {
			// * Creacion de NumPad para el Modal de autorización de descuento
			$('#divNumPadAutorizacion').html("");
			createNumPad("divNumPadAutorizacion","usuario","confirm","","",);
			$("#iconoPSW").addClass("scale-out");
			$("#iconoPSW").hide();
			$("#iconoUSR").removeClass("scale-out");
			$("#iconoUSR").show();

			// ! modals comentados
			//$("#modalDescuento").modal("open");
		}
	} else {
		calcTotal(param);
	}
}

// TODO: Optimizar para cuando se usen dolares
function resetCuenta() {
	$("#TxtSaldo").val($("#totalFactura").val());
	$("#TxtNumPad").attr("placeholder", "");
	$("#TxtEfectivo").val("");
	$("#TxtDolares").val("");
	$("#TxtVisa").val("");
	$("#TxtBac").val("");
	$("#TxtDescuento").val("");
	$("#TxtTotal").val(0.0);

	if(localStorage.isMobile == 'false'){
		if (!$("#btnCobrar").hasClass("disabled")) {
			$("#btnCobrar").addClass("disabled");
			if(localStorage.isMobile == 'false')
				$("#btnCobrar").removeClass("pulse");
		}
	}
	else{
		let attr = $('#btnCobrar').attr('disabled');
		if(typeof attr == typeof undefined || attr == false){
			$('#btnCobrar').attr('disabled','""');
		}
	}
	
}

// Obliga a facturar cuando se utilizo visa o bac (pago con tarjeta)
function confirmCompra() {
	let visa = $("#TxtVisa").val();
	let bac = $("#TxtBac").val();

	if (emitirRecibo == false){
		$("#chkTipoTransaccion").prop("checked", true).change();
		$("#chkTipoTransaccion").attr("disabled", "disabled");
	} else if (facturaDefault == true) {
		$("#chkTipoTransaccion").prop("checked", true).change();
	} else {
		if (visa > 0 || bac > 0) {
			$("#chkTipoTransaccion").prop("checked", true).change();
			$("#chkTipoTransaccion").attr("disabled", "disabled");
		} else {
			$("#chkTipoTransaccion").prop("checked", false).change();
			$("#chkTipoTransaccion").removeAttr("disabled", "disabled");
		}
	}

	if(localStorage.isMobile == 'true'){
		showFacturacion();
	}
	else{
		$("#modalCuenta").css("height","unset");
		$("#searchClient").slideUp();
		$("#divFormasPago").slideUp();
		$("#divFacturar").slideDown();
		if(localStorage.touchEnabled == "false"){
			$("#nit").focus();
		}
	}
	
}

// ! No se esta utilizando
// TODO: Implementar boton o interfaz que permita Limipiar el carrito.
function cancelarVenta() {
	var r = confirm("¿Esta seguro de cancelar esta venta?");
	if (r == true) {
		params = {
			service: "cancelarVenta",
			dbName: dbName,
			idUsuarios: localStorage.idUsuarios
		};
		$.post(host, params, function (data) {
				$.each(data, function (key, val) {
					if (val.message === "success") {
						loadProductosVenta();
					} else {
						alert(`Error ${val.Query}`);
					}
				});
			},"json");
	} else {
		return false;
	}
}

function validacionCarrito(){
	if ($("#totalItems").val() === undefined || $("#totalItems").val() === '0'  ) {
		Swal.fire({
			html: 'No tiene articulos en esta venta',
			timer: 2000,
			timerProgressBar: true,
			confirmButtonColor: "#ff8f00",
			confirmButtonText: "Aceptar",
		}).then((result) => {
			if(localStorage.isMobile == "true"){
				showCarrito();
			}
		});
	} else {
		drawFormasPago();
	}
}

// Prepara los campos del modalCuenta en el onclick de DESPACHAR 
function getDatosVenta() {
	//Restablece los valores por default para los botones y campos.
	$("#modalCuenta").css("height","unset");
	$("#nombre").val("");
	$("#tipoVenta").prop("checked", false).change();
	/*
	$("#finVentaC").html("BUSCAR");
	$("#finVentaC").attr("onclick","getSaldoCliente();");
	*/
	
	$("#divNumPadCobro").empty();
	$("#divNumPadNIT").empty();
	if(localStorage.isMobile == "false"){
		//Validacion para caso de carrito vacío
		if ($("#totalItems").val() === undefined || $("#totalItems").val() === '0'  ) {
			Swal.fire({
				html: 'No tiene articulos en esta venta',
				timer: 2000,
				timerProgressBar: true,
				confirmButtonColor: "#ff8f00",
				confirmButtonText: "Aceptar",
			}).then((result) => {
				if(localStorage.isMobile == "true"){
					showCarrito();
				}
			});
		} else {
			// si es mobile (optimiza la forma de mostrar) y hace otro if en donde checa tipo moneda
			if(localStorage.isMobile == "true"){
				if($("#tipoMoneda").val() == "2"){ //Si es DOLARES:
					$("#divVisa").hide();
					$("#divBac").hide();
				}
			}

			if(localStorage.isMobile == "false"){
				if($("#tipoMoneda").val() == "2"){
					$('.divEfectivo').hide();
					$('.divVisa').hide();
					$('.divBac').hide();
					$('.divDolares').show();
				}
				else{
					$('.divDolares').hide();
					$('.divEfectivo').show();
					$('.divVisa').show();
					$('.divBac').show();
				}
				$("#modalCuenta").modal("open");
			}

			if(localStorage.touchEnabled == "false"){
				$("#TxtNumPad").removeAttr('disabled');
				$("#TxtNumPad").focus();
			}
			else{
				createNumPad("divNumPadCobro", "TxtNumPad", ".", "percentage", "");
				createNumPad("divNumPadNIT", "nit", "K", "", "");
			}

			$("#TxtNumPad").attr("placeholder", "");
			$("#TxtTotal").val(0.0);
			$(".formasPago").val("");
			$("#TxtNumPad").val("");
			$("#nit").val("");
			$("#divFacturar").hide();
			$("#searchClient").hide();
			$("#divFormasPago").show();

			if (!$("#btnCobrar").hasClass("disabled")) {
				$("#btnCobrar").addClass("disabled");
				if(localStorage.isMobile == 'false')
					$("#btnCobrar").removeClass("pulse");
			}

			if ($("#tipoMoneda").val() == "2"){ //Si es Dolar:
				$("#totalFactura").val(accounting.formatNumber($("#totalDolares").val(), 2));
				$("#TxtSaldo").val(accounting.formatNumber($("#totalDolares").val(), 2));
			}else{
				$("#totalFactura").val(accounting.formatNumber($("#total").val(), 2));
				$("#TxtSaldo").val(accounting.formatNumber($("#total").val(), 2));
			}
			$('#btnFinVenta').removeAttr('disabled');
		}
	}
}

// Guarda los datos de la venta y emite la factura o recibo 
// Llama a la funcion de imprimir local/sunmi
function finalizarVenta() {
	$('#btnFinVenta').attr('disabled', 'disabled');
	$("#loader").show();

	if (localStorage.isMobile == "true"){
		agregarVentasATO();
	}

	try {
		var flag = true;
		var errorMsg = "Corrige los siguiente errores:\n";
		let chkTipTrans = $("#chkTipoTransaccion").prop("checked");

		if(!emitirRecibo){
			chkTipTrans = true;
		}

		var nitExtranjero;
        var nit;
        //Validacion para NIT si no se permite NIT Extranjero.
        if (nitExt == false ){
            if (chkTipTrans) {
                if (!$("#nit").val()) {
                } else if ($("#nit").hasClass("invalid")) {
                    errorMsg = "Debe ingesar un NIT valido";
                    flag = false;
                }
            }
        }

		var tipoVenta;
		var anticipo;
		if($('#tipoVenta').is(":checked")){
			tipoVenta = 1;
			anticipo = accounting.unformat($("#TxtTotal").val());
		}else{
			tipoVenta = 0;
			anticipo = 0;
		}

		if (flag === false) {
			Swal.fire({
				html: errorMsg,
				icon: "warning",
				confirmButtonColor: "#3085d6",
				confirmButtonText: "Ok",
			}).then((result) => {});
			$("#loader").hide();
			$('#btnFinVenta').removeAttr('disabled');
			return false;
		} else {
			var detalle = [];
			$(".formasPago").each(function (index) {
				if (accounting.unformat($(this).val()) != 0) {
					var arr = {};
					arr["idFormasPago"] = $(this).data("type");
					arr["idEmisor"] = $(this).data("emisor");
					arr["valor"] = accounting.unformat($(this).val());
					detalle.push(arr);
				}
			});
		
			if ($('#tipoVenta').is(":checked") && detalle.length == 0){
				var arr = {};
				arr["idFormasPago"] = 4;
				arr["idEmisor"] = 0;
				arr["valor"] = accounting.unformat($("#TxtSaldo").val());
				detalle.push(arr);
			}

			if ($("#nit").hasClass("invalid")){
                if (nitExt == true ){
                    nit = "CF";
                    nitExtranjero = $("#nit").val();
                }
            }else{
                nit = $("#nit").val();
                nitExtranjero = "0";
            }
			
			var descuento = accounting.unformat($("#totalDescontado").val());
			var subtotal = accounting.unformat($("#subtotalVenta").val()); 

			var totalFactura = accounting.unformat($("#totalFactura").val());
			var iva = accounting.unformat(((totalFactura / 1.12) * 0.12 * 100) / 100);
			var total = accounting.unformat(totalFactura - iva);
			
			//var nit = !$("#nit").val() ? "CF" : $("#nit").val();
			if(!$("#nit").val()){
                nit = "CF";
                nitExtranjero = "0";
            }
			var nombre = !$("#nombre").val() ? "Consumidor Final" : $("#nombre").val();
			var direccion = !$("#direccion").val() ? "Consumidor Final" : $("#direccion").val();

			//var openCash = (accounting.unformat($("#TxtEfectivo").val()) > 0)? true : false;
			let pagoCash = accounting.unformat($("#TxtEfectivo").val()) + accounting.unformat($("#TxtDolares").val());
			var openCash = (pagoCash > 0)? true : false;

			if ($("#tipoMoneda").val() == "2"){ //Si es Dolar:
				var codigoMoneda = "USD";
				$("#total").val("0.00");
			}else{
				var codigoMoneda = "GTQ";
				$("#totalDolares").val("0.00");
			}

			let vendedor = $('#idVendedor').val();

			let serviceAPI;

			let referenciaInterna = $('#referenciaInterna').val();

			if(tipoVenta == 0){
				serviceAPI = "finalizarVenta";
			}else{
				serviceAPI = "finalizarVentaCambiaria";
			}
			
			params = {
				service: serviceAPI,
				dbName: dbName,
				urlFEL: urlFEL,
				tokenFEL: tokenFEL,
				idVendedor: vendedor,
				idUsuarios: localStorage.idUsuarios,
				idSucursales: localStorage.idSucursales,
				idEmpresas: localStorage.idEmpresas,
				totalFactura : totalFactura,
				total: accounting.unformat($("#total").val()),
				nombre: nombre,
				nit: nit,
				direccion: direccion,
				subtotal: subtotal,
				descuentoM: descuento,
				descuentoP: 0,
				anticipo: anticipo,
				saldo: accounting.unformat($("#TxtSaldo").val()),
				iva: iva,
				tasaCambio: 0,
				totalDolares: accounting.unformat($("#totalDolares").val()), //Guardar el total (con descuento) de Dolares
				tipoVenta: tipoVenta,
				idDocumento: $("#idDocumento").val(),
				serie: $("#serie").val(),
				correlativo: $("#correlativo").val(),
				documento: $("#facutra").val(),
				tipoTransaccion: chkTipTrans ? 1 : 0,
				detalle: detalle,
				codigoMoneda: codigoMoneda,
				nitExt: nitExtranjero,
				referenciaInterna: referenciaInterna
			};

			console.log(params);
			$.post(host, params, function (data) {
					$.each(data, function (key, val) {
						switch (val.message) {
							case "success":
								//alert(val.error);
								printer(val.idVenta, params.tipoTransaccion, openCash, 0);
								if($('#tipoVenta').is(":checked")){
									guardarSaldoActual();
								}
								break;
							case "docExists":
								alert("Correlativo de documento ya existe en el sistema");
								break;
							default:
								alert(val.error);
								break;
						}
					});
				}, "json").done(function () {
				$("#loader").hide();
				$('#btnFinVenta').removeClass('disabled');
			});
		}
	} catch (err) {
		Swal.fire({
			html: err.message,
			icon: "error",
			confirmButtonColor: "#3085d6",
			confirmButtonText: "Ok",
		}).then((result) => {});
		$("#loader").hide();
		return false;
	}
}

// Obtiene el correlativo del siguiente documento a emitir 
function getDocumentoFacturacion() {
	params = {
		service: "getDocumentoFacturacion",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idUsuarios: localStorage.idUsuarios,
	};
	$.post(host, params, function (data) {
			if (data !== null) {
				$.each(data, function (key, val) {
					$("#idDocumento").val(val.id);
					$("#serie").val(val.serie);
					$("#correlativo").val(val.correlativo);
				});
			}
		}, "json");
}

// Consultar NIT
function consultaNIT() {
	if ($("#nit").val().replace(/-/g, "") !== "CF") {
		params = {
			service: "consultaNIT",
			nit: $("#nit").val().replace(/-/g, "")
		};
		$.post(host, params, function (data) {
				$.each(data, function (key, val) {
					switch (val.message) {
						case "success":
							$("#nombre").val(val.nombre);
							$("#direccion").val(val.direccion);
							break;
						default:
							alert(`${val.msj},\nintente ingresar el nit correctamente`);
							break;
					}
				});
			}, "json").done(function () {
			$("#loader").hide();
		});
	}
}

function aperturaCaja() {
	//* Buscar el fondo de caja dependiendo de la configuración de apertura y corte manual o automatica

	var corte = corteManual;
	if(corte == true){
		corte = 1;
	}else{
		corte = 0;
	}

	params = {
		service: "fondoCaja",
		dbName: dbName,
		IdSucursales: localStorage.idSucursales,
		IdUsuarios: localStorage.idUsuarios,
		corte: corte
	};
	$.post(host, params, function (data) {
			if (data === null) {
				$("#divModalContent").html("");
				$("#modal-title").html("APERTURA DE CAJA");

				let component;
				if(localStorage.isMobile == 'true'){
					
					component = `
					<div class="mdl-grid ">
						<div class="mdl-cell mdl-cell--4-col-phone" style="text-align: center;">
							<h4>Apertura de Caja</h4>
						</div>
					</div>
					<div class="mdl-grid ">
						<div class="mdl-cell mdl-cell--4-col-phone ">
							<input type="number" id="monto" class="big-numbers full-width right-align" disabled="">
						</div>
					</div>
					<div id="divAperturaPad" class="mdl-grid" style="text-align: center; padding: 0px;">
					</div>
					`;

					$('#productosMobile').html(component);
				}
				else{
					component = `<div class='col s4 offset-s4'>`;
					component += `
							<input type='text' id="monto" class='big-numbers' disabled/>
							</div>
							<div id='divAperturaPad' class='col s12'>

							</div>`;
					$("#divModalContent").html(component);
				}
				
				if(localStorage.isMobile == "false"){
					$("#modal1").modal("open");
				}
				
				if(localStorage.touchEnabled == "false"){
					assignKeyActions('monto', 'confirm');   
				}
				else{
					createNumPad("divAperturaPad", "monto", ".", "", "confirm");
				}		
			} else {
				if(localStorage.isMobile == 'true'){
					if(ATO){
						showDetalles();
					}
					else{
						returnProductos();
					}
				}
			}
		}, "json").done(function () {
		$("#loader").hide();
	});
}

// funcion que se llama desde el boton de confirmacion del numpad 
function fnConfirm(sender, idInputField) {
	$("#loader").show();
	if (localStorage.idUsuarios == undefined) {
		salirCaja();
	}
	switch (idInputField){
		case 'nit':
			finalizarVenta();
		break;
		case 'txtValor':
        case 'txtGalon':
            let valorFac = parseFloat($('#txtValor').val());
            valorFac = isNaN(valorFac) ? 0 : valorFac;
            if(valorFac > 0){
				agregarProductoVenta(
					idGasolina,
					1,
					3,
					'Gasolina',
					$('#txtGalon').val(),
					precioGas,
					0,
					0,
					0
				);
				$('#TxtSaldo').val(valorFac);
				$('#totalFactura').val(valorFac);
				createNumPad("divNumPadCobro", "TxtNumPad", ".", "reset", "confirm");
                $('#tabBar').tabs('select', 'divFactura');
            }
            else{
				M.Toast.dismissAll();
                M.toast({html: 'Debe ingresar una cantidad valida'});
            }
			$("#loader").hide();
            break;
		case "TxtNumPad":
			let valorSaldo = parseFloat($('#TxtSaldo').val());
            valorSaldo = isNaN(valorSaldo) ? 0 : valorSaldo;
			if(valorSaldo > 0){
				M.Toast.dismissAll();
                M.toast({html: 'Forma de pago incompleto'});
			}
			else{
				$("#divFormasPago").slideUp();
				$("#divDatosFactura").slideDown();
				createNumPad("divNumPadCobro", "nit", "K", "", "confirm");
			}
			$("#loader").hide();
			break;
		case "monto":
			var vMonto = $("#" + idInputField).val();
		if (vMonto == "" || vMonto < 0 ) {
			$("#loader").hide();
			Swal.fire({
				icon: "warning",
				text: "Debe ingresar un monto valido de apertura.",
				showCloseButton: true,
				confirmButtonText: "Intentar de nuevo",
				html: "Debe ingresar un monto valido de apertura.",
			});
		} else {
			params = {
				service: "aperturarCaja",
				dbName: dbName,
				IdSucursales: localStorage.idSucursales,
				IdUsuarios: localStorage.idUsuarios,
				Monto: accounting.unformat(vMonto),
			};

			$.post(host, params, function (data) {
				$.each(data, function (key, val) {
					switch (val.message) {
						case "success":
							printApertura();
							break;
						default:
							alert(`Error al aperturar caja`);
							break;
					}
				});
			}, "json");
		}
			break;
		case "usuario":
		case "password":
			$("#loader").hide();
			fnAutorizacion(idInputField);
			break;
		case "inputDescuento":
			$("#loader").hide();
			aplicarDescuento();
			break;
		
		case "montoVale":
			$("#loader").hide();
			registrarVale();
			break;
		
		// para ingresar la cantidad de productos
		case "inputPrecio":
			$("#loader").hide();
			let idProductos = $("#idProducto").val(); //
			let existencia = $("#existencia").val();
			let idTipoProductos = $("#idTipoProductos").val(); //			
			let producto = $("#descripcion").val(); //descLarga
			let cantidad = $("#contador").val();

			/*
			if($("#inputPrecio").val() == $("#precioPublico").val() || $("#inputPrecio").val() == $("#precioDolar").val()){
				$("#agrupar").val(1); // que si se agrupan
			}else{
				$("#agrupar").val(0); // que no se agrupan
			}
			*/

			//solo en la version que permite el cambio de precios no se agrupa, el shop con dimensiones horizontales si.
			$("#agrupar").val(0);

			$("#subtotalQ").val(accounting.formatNumber(($("#precioPublico").val() * cantidad), 2)); 
			$("#subtotalD").val(accounting.formatNumber(($("#precioDolar").val() * cantidad), 2));
			
			let agrupar = $("#agrupar").val();

			//Una vez recibidos los valores, se determina a cual se le va a asignar el valor introducido manualmente (en ese caso)
			if ($("#tipoMoneda").val() == "2"){ //Si es Dolar:
				var precioPublico = $("#precioPublico").val(); //
				var precioDolar = accounting.unformat($("#inputPrecio").val()); //Precio de producto en dolar
			}else{
				var precioPublico = accounting.unformat($("#inputPrecio").val()); //
				var precioDolar = $("#precioDolar").val(); //Precio de producto en dolar
			}

			if ($("#inputPrecio").val() == "" || $("#inputPrecio").val() <= 0 ){
				Swal.fire({
					icon: "warning",
					text: "Debe ingresar un monto valido.",
					showCloseButton: true,
					confirmButtonText: "Intentar de nuevo",
					html: "Debe ingresar un monto valido.",
				});
			} else {
				agregarProductoVenta(idProductos,existencia,idTipoProductos,producto,cantidad,precioPublico,0,precioDolar,agrupar);
			}
			break;
		
		case "contador":
			console.log("1");
			$("#loader").hide();
			let idProducto = sessionStorage.idProducto; //		
			let cant = $("#contador").val();

			if ($("#contador").val() == "" || $("#contador").val() <= 0 ){
				Swal.fire({
					icon: "warning",
					text: "Debe ingresar una cantidad valida.",
					showCloseButton: true,
					confirmButtonText: "Intentar de nuevo",
					html: "Debe ingresar una cantidad valida",
				});
			} else {
				agregarProductoAjuste(idProducto,cant);
			}
			break;
		case "editarCantidad":
			$("#loader").hide();
			//funcion que haga update al registro
			// id registro, precioPublico y el nuevo input
			if ($("#contador").val() == "" || $("#contador").val() <= 0 ){
				Swal.fire({
					icon: "warning",
					text: "Debe ingresar una cantidad valida.",
					showCloseButton: true,
					confirmButtonText: "Intentar de nuevo",
					html: "Debe ingresar una cantidad valida",
				});
			} else {
				editarCantidad();
			}
			
			break;
	}
}

// Aplica descuento por item desde el Modal
// Se llama desde el fnConfirm del numpad
function aplicarDescuento(){
	let vDescuentoIn = parseFloat($("#inputDescuento").val()); //Valor de descuento que se ingresa (necesario solo para validar que no sea vacio)

	let vDescuentoOut = $("#outputDescuento").val(); //Total luego del descuento
	//let descProducto = $("#descLarga").val();
	let idProducto = $("#idDescuento").val(); //Id de la venta
	let descuento = $("#percent").val(); //Cantidad descontada del subtotal
	
	console.log(vDescuentoIn);
	//let totalDolares = $("#precioDolar").val();
	 
	let totalDolares = ($("#subtotalD").val() - descuento);
	let totalPrecio = ($("#subtotalQ").val() - descuento);

	if ( vDescuentoIn == "" || vDescuentoOut < 0 || vDescuentoOut == "0.00" || vDescuentoIn < 0) {
		Swal.fire({
			icon: "warning",
			text: "Debe ingresar un monto valido.",
			showCloseButton: true,
			confirmButtonText: "Intentar de nuevo",
			html: "Debe ingresar un monto valido.",
		});
	} else {

		params = {
			service: "aplicarDescuento",
			id: idProducto,
			dbName: dbName,
			total : totalPrecio, //la cantidad ya con el descuento aplicado
			descuento: descuento, //el descuento 
			totalDolares: totalDolares
		};
		// * Envia los datos del descuento para aplicarlos al item(s) del carrito
		$.post(host, params, function (data) {
			$.each(data, function (key, val) {
			});
		}, "json");

		Swal.fire({
			icon: "success", 
			text: "Descuento aplicado",
		}).then((result) => {
			if (result.isConfirmed) {
				// ! modals comentados
				if(localStorage.isMobile == "false"){
					$("#modal1").modal("close");
				}
				loadProductosVenta();
			}
		})
	}
};


//! CONSULTA PRECIO Y EXISTENCIAS

function getProductosPrecio(){
	params = {
		service: "getProductos",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};
	$.post(host, params, function (data) {
		
		let productos = "<option></option>";
		$.each(data, function (key, val) {
			productos += `<option value="${val.id}">${val.sku} - ${val.descLarga}</option>`;
		});
		$("#selectProductosPrecios").html(productos);

		$('#selectProductosPrecios').select2({
			placeholder: "Buscar productos...",
            minimumInputLength: 3,
            language: {

                noResults: function() {
            
                  return "No hay resultados";        
                },
                searching: function() {
            
                  return "Buscando..";
                },
                formatInputTooShort: function(){
                    return "Porfavor ingrese mas de 3 caracteres..";
                },
                inputTooShort: function() {
                    return 'Porfavor ingrese 3 o mas caracteres..';
                }
              },
            formatInputTooShort:"Porfavor ingrese 3 o mas caracteres.."
		});
	}, "json",);
}

$("#selectProductosPrecios").on("change", function () {
	getDatosProducto($("#selectProductosPrecios").val());
});

function getDatosProducto(idProducto){

	let page = location.href.split("/").slice(-1);
    page = page[0].split('.');
    let pagina = page[0];

    $("#loader").show();
	//var idProducto = $('#selectProductosAjustes').val();
	params = {
		service: "getDatosProducto",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales,
		idProducto: idProducto 
	};
	$.post(host, params, function (data) {
        console.log(data);
        if (data === null) {

        }else{
            $.each(data, function (key, val) {
				if(pagina == "puntoVenta"){
					agregarProductoCarrito(val.id,val.existencia,val.idTipoProductos,val.descLarga,1,val.precioPublico,0,0,0);
				}else if (pagina == "consultaPrecios"){
					modalPrecios(val.id,val.sku,val.descLarga,val.precioPublico,val.existencia);
				}else if (localStorage.isMobile == "true"){
                    //redireccionar a pantalla con input de cantidad mobile
                    window.location = "cantidadMobile.html";
                    sessionStorage.idProducto = val.id;
                    sessionStorage.descLarga = val.descLarga;
                    sessionStorage.sku = val.sku;
                }else{
                    
					//LLAMAR AL MODAL DE CANTIDADES PARA PERSONALIZARLO
					modalAjuste(val.sku,val.descLarga);
					sessionStorage.idProducto = val.id;
                }
            });
        }
	}, "json",);

}

function modalPrecios(idProducto,sku, descLarga,precio,existencia){
	// funcion que traiga la sucursal / bodega y a un lado cuanto tiene en existencias del producto;
	// pintar tarjetas debajo de este
	params = {
		service: "getExistencias",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idProducto: idProducto 
	};
	$.post(host, params, function (data) {

		var bodyPrecio = "";
		bodyPrecio = `
		<div class="row">
			<div class="col s12" style="padding-top: 50px;">
				<b>
				<div class="blue-text" style="font-size:1.5em !important;margin-bottom: 10px;line-height: normal;">${descLarga}</div>
				</b><br/>
				<div style="text-align:left;">${sku}
				<br/><br/>
				<b>PRECIO: </b> ${precio}
					<br/><br/>
				<b><center>EXISTENCIAS</center></b>
				</div>
			</div>
		</div>`;
        console.log(data);
        if (data === null) {

        }else{
			bodyPrecio += `<ul id="detallePrecios" class='mdl-list' style="padding: 0; margin: 0;font-size: large;">`;
            $.each(data, function (key, val) {
				if(val.inventario != "NONE"){
					bodyPrecio += `
					<div class="row" style="margin-bottom: 0px;">
					<div class="col s12">
					<div class="cardNoPointer card" style="background-color:white;text-transform:capitalize">
						<div class="card-content">
						<span><div class="row"><div class="col s6"><b>${(val.inventario).toLowerCase()}</b></div><div class="col s6"><b>Saldo: </b>${val.saldo}</div></span>
						</div>
					</div>
					</div>
				</div>`;
				}
				
			});
		}
			bodyPrecio += `</ul>`;

		    $("#bodyConsultarPrecio").html(bodyPrecio);

	}, "json").done(function () {
		$("#loader").hide();
	});


}




