const barcodeFormat1 = "pccccccwwwwww";
const prefixNum1 = "3";

$(document).ready(function() {

    let page = location.href.split("/").slice(-1);
    page = page[0].split('.');
    let pagina = page[0];

    if(pagina == "ajustes"){
        cargarAjustes();
        sessionStorage.idAjuste = undefined;
        sessionStorage.idEstadoAjuste = undefined;
        $("#btn-transladarAjuste").hide();
       $("#btn-continuarAjuste").hide();
       $("#btn-iniciarAjuste").show();
    }

    
    resizeDOMHeights();

    
    if(pagina == "ajustesForm"){
        getSucursalesBodegas();
        if (sessionStorage.idAjuste != "undefined"){
            console.log(sessionStorage.idAjuste); 
            getAjusteData(sessionStorage.idAjuste);
            $("#btn-transladarAjuste").show();
            $("#btn-continuarAjuste").show();
            $("#btn-iniciarAjuste").hide();
         }
     
         if(sessionStorage.idEstadoAjuste == "12"){
            $("#descAjuste").attr('readonly', true);
            $("#facturaAjuste").attr('readonly', true);
            $("#selectBodegaSucursal").attr('disabled', true);
            $(`input[name='tipoAjuste']`).attr('disabled', true);

         }else{
            $("#descAjuste").attr('readonly', false);
            $("#facturaAjuste").attr('readonly', false);
            $("#selectBodegaSucursal").attr('readonly', false);
         }
    }

    if(pagina == "registroEntradas"){
        cargarAjustesDetalle();
        getProductoSelect2();

        if(localStorage.isMobile == false || localStorage.isMobile == "false"){
            $('#modalAjuste').modal({
                "dismissible": false,
                "inDuration": 0,
                "outDuration": 0
            });
        }
    }

    if(pagina == "cantidadMobile"){
        modalAjusteMovil();
    }

}); 


// ? tipo: weight or value
function getIdProducto(sku, cantidad, tipo) {
    console.log(sku);
	params = {
		service: "getIdProducto",
		sku: sku,
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales,
		idUsuarios: localStorage.idUsuarios,
	};

	$("#loader").show();

	$.post(host, params, function (data) {
			$.each(data, function (key, val) {
				// ! Revisar respuesta del API, siempre responde success 
				switch (val.message) {
					case "success":
						if (val.precioPublico == 0) {
							swalPrecioPublico(
								val.idProducto,
								val.existencia,
								val.idTipoProductos,
								val.descLarga,
								cantidad,
							);
						} else if(val.idProducto === null){
                            Swal.fire({
                                title: `${sku}`,
                                html: `Codigo no registrado. Intente ingresar el producto manualmente`,
                                icon: "warning",
                                confirmButtonColor: "#3085d6",
                                confirmButtonText: "Ok",
                            }).then((result) => {});

                        } else {
							let vPrecio, vCantidad;
							switch(tipo){
								case 'weight':
									vCantidad = cantidad;
									vPrecio = cantidad * val.precioPublico;
									break;
								case 'value':
									vCantidad = (cantidad / val.precioPublico).toFixed(3);
									vPrecio = val.precioPublico;
									break;
								default:
									vCantidad = cantidad;
									vPrecio = val.precioPublico;
									break;
							}
                                //agregarProductoAjuste
                                //if mobile
                                getDatosProducto(val.idProducto);
						}
						break;
					case "no_existe":
						Swal.fire({
							title: `${sCode}`,
							html: `Código no registrado.`,
							icon: "warning",
							confirmButtonColor: "#3085d6",
							confirmButtonText: "Ok",
						}).then((result) => {});
						break;
					default:
						alert(`Error ID ${val}`);
						break;
				}
			});
		},
		"json",
	).done(function () {
		$("#loader").hide();
	});
}

function getUsuarios(){
    params = {
		service: "getUsuarios",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas
	};
	$.post(host, params, function (data) {
		let user = "<option></option>";
		$.each(data, function (key, val) {
			user += `<option value="${val.id}"> ${val.userName}</option>`;
		});
		$("#selectUsuarios").html(user);
		$('#selectUsuarios').select2({
			width: '100%',
			placeholder: "Seleccione un usuario...",
		});

	}, "json").done(function(){
		$("#loader").hide();
	});
	$("#selectUsuarios").on("change", function () {
		console.log($("#selectUsuarios").val());
	});
}

function transaldoAjuste(idUsuario){
    $("#loader").show();
    params = {
		service: "trasladarAjuste",
		dbName: dbName,
		idUsuarios: idUsuario,
        idAjuste: sessionStorage.idAjuste
	};
	$.post(host, params, function (data) {
        console.log(data.message);
        switch (data.message) {
                
            case "success":
                Swal.fire({
                    icon: 'success', text: "Transaldo realizado"
                }).then(function () {
                    window.location = "ajustes.html";
                });
                
                break;
            case "error":
                alert("Error al transladar usuario");
                break;
            default:
                alert(`Error`);
                break;
        }
		$.each(data, function (key, val) {
            

		});
	}, "json").done(function(){
        //
		$("#loader").hide();
	});
}

function getAjusteData(idAjuste){
    $("#loader").show();
    params = {
		service: "getAjuste",
		dbName: dbName,
		idAjuste: idAjuste
	};
	$.post(host, params, function (data) {
        console.log(data);
		$.each(data, function (key, val) {
            console.log(val.idEstado);
            $("#idEstado").val(val.idEstado);
            let select = val.idPunto;
            let select2 = select.concat("_",val.inventario);
            $("#descAjuste").val(val.descripcion);
            $("#facturaAjuste").val(val.noFactura);
            $(`input[name='tipoAjuste'][value='${val.idTipoAjustes}'`).attr("checked",true);
           $(`#selectBodegaSucursal`).val(select2);
           $(`#selectBodegaSucursal`).trigger('change');

            // $("#selectBodegaSucursal option:selected").removeAttr("selected");
            // $("#selectBodegaSucursal option[value='"+select2+"']").attr('selected'); 
            
            //$(`#selectBodegaSucursal option[value="${select2}"]`).attr("selected", "selected");
		});
	}, "json").done(function(){
		$("#loader").hide();
	});
}



function modalAjusteMovil(){
	$("#loader").hide();
	$('#modalAgregarProductoAjustes').empty();
	$('#modalAgregarProductoAjustes').height(canvasH);
	//var cantidad =  $("#contador").get(0).value;

    let id = sessionStorage.idProducto;
    let desc = sessionStorage.descLarga;
    let sku = sessionStorage.sku;

	let agregarBody = `
		<div class="mdl-grid" style="font-size:20px;padding: 0px 8px 0px 8px;">
			<div class="mdl-cell mdl-cell--12-col-phone">
                <b>${desc}</b>			
            </div>
		</div>
        <div class="mdl-grid" style="font-size:20px;padding: 0px 8px 0px 8px;">
            <div class="mdl-cell mdl-cell--2-col-phone">
                SKU: 
            </div>
            <div class="mdl-cell mdl-cell--2-col-phone">
            <b>${sku}</b>	
            </div>
        </div>

		<div class="mdl-grid" style="font-size:20px;padding: 0px 8px 0px 8px;">
			<div class="mdl-cell mdl-cell--12-col-phone" style="text-align: center;">
				Cantidad: 
			</div>	
		</div>
        <div class="mdl-grid" style="font-size:20px;padding: 0px 8px 0px 8px;">
			<div class="mdl-cell mdl-cell--12-col-phone"  style="text-align: center;">
                <i class="medium material-icons" onclick="cantidad('remove')" 
                style="font-size: 40px;">indeterminate_check_box</i>
                <input class="big-numbers" type="text" id="contador" value="1" min="1" disabled="" style="text-align: center;width: 50%;">
                <i class="medium material-icons" onclick="cantidad('add')" 
                style="font-size: 40px;">add_box</i> 
			</div>	
		</div>
		<div class="mdl-grid" style="text-align: center;padding: 0px 8px 0px 8px;" id="divNumPadCantidad"></div>
		`;

	$('#modalAgregarProductoAjustes').append(agregarBody);
	createNumPad("divNumPadCantidad", "contador", ".", "", "confirm");
	$("#contador").val("1");

}

function modalAjuste(sku, descLarga){
    $("#loader").hide();
    var modalCantidad = "";
    modalCantidad = `
    <div class="row">
        <div class="col s6 blue-text" style="font-size:1.5em !important;padding-right: 0px; padding-top: 50px;">
            <b>
            <div style="padding-left: 0px;">${descLarga}</div>
            <br/>
            <div style="padding-left: 0px;">${sku}</div>
            <br/>
            <div class="row">
                <div  class="col s3" style="padding-left: 0px;padding-left: 10px;">Cantidad: </div>
            
                <div  class="col s9" style="text-align: center;">
                    <i class="medium material-icons" onclick="cantidad('remove')" 
                    style="font-size: 40px;">indeterminate_check_box</i>
                    <input class="big-numbers" type="text" id="contador" value="1" min="1" style="text-align: center;width: 50%;">
                    <i class="medium material-icons" onclick="cantidad('add')" 
                    style="font-size: 40px;">add_box</i> 
                </div>	
            </div>
            </b>
        </div>
        <div class="col s6" id="divNumPadAjuste"></div>
    </div>`;

    $("#divModalContent").html(modalCantidad);
    $("#modalAjuste").modal("open");
    //abrir modal de cantidad

    if(touchEnabled){
		createNumPad("divNumPadAjuste", "contador", ".", "", "confirm");
	}else{
		assignKeyActionsCantidad();
		$("#contador").focus().val("").val("1");
	}
}

function assignKeyActionsCantidad(){
	$('#contador').keypress(function(event){
		var keycode = (event.keyCode ? event.keyCode : event.which);
		if(keycode == '13'){
			fnConfirm('confirm', 'contador');
		}
	});
}

function cantidad(boton){
    let precio = accounting.unformat($("#inputPrecio").val());
	let contador = $("#contador").get(0).value;
    let int = parseInt(contador, 10);

    if (boton == 'add'){
        $("#contador").get(0).value = int +1;
    } else {
        $("#contador").get(0).value = int -1;
        if ($("#contador").get(0).value < 1){
            $("#contador").get(0).value = 1;
        }
	}
	let moneda = ($("#tipoMoneda").val() == "2")? "$":"Q";
	let total = $("#contador").get(0).value * precio;
	$("#mTotal").val(accounting.formatMoney(total, moneda, 2));
}


function cargarAjustes(){
    $("#loader").show();
    params = {
		service: "getAjustes",
		dbName: dbName,
		idUsuarios: localStorage.idUsuarios,
		idEmpresas: localStorage.idEmpresas
	};
	$.post(host, params, function (data) {
			drawAjustes(data);	
		},
		"json",
	).done(function () {
		$("#loader").hide();
	});
}

function cargarAjustesDetalle(){
    $("#loader").show();
    params = {
		service: "loadProductosAjuste",
		dbName: dbName,
		idUsuarios: localStorage.idUsuarios,
		idAjuste: sessionStorage.idAjuste
	};
	$.post(host, params, function (data) {
			drawAjustesDetalle(data);	
		},
		"json",
	).done(function () {
		$("#loader").hide();
	});
}

function drawAjustesDetalle(items){
    var detail = "";
    console.log(items);
    if (items === null) {
		detail += `
        <div class="row">
        <div class="col s12 center-align">
            El ajuste aun no cuenta con porductos agregados
        </div>
      </div>`;
      $("#btn-FinalizarAjuste").attr('disabled', true);
	} else {
		detail = `<ul id="detalleAjustes" class='mdl-list' style="padding: 0; margin: 0;">`;
		$.each(items, function (key, val) {
			detail += `
            <div class="row" style="margin-bottom: 0px;">
            <div class="col s12 m10 offset-m1">
              <div class="card" style="background-color:white">
                <div class="card-content white-text">
                  <span  style="color:black"><div class="row"><div class="col s10 m11" onclick="">${val.descLarga}</br> x${val.cantidad}</div><div class="col s2 m1" onclick="deleteAjusteDetalle(${val.id},'${val.descLarga}')"><i class="material-icons" style="">delete</i></div></div></span>
                  <p style="color:black" onclick=""> ${val.sku}</br>
                  </p>
                </div>
              </div>
            </div>
          </div>`;
		});
        
	}

    $('#cardAjustesDetalle').empty();
	$("#cardAjustesDetalle").append(detail);
}

function getProductoSelect2(){
	params = {
		service: "getProductos",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas,
		idSucursales: localStorage.idSucursales
	};
	$.post(host, params, function (data) {
		
		let productos = "<option></option>";
		$.each(data, function (key, val) {
			productos += `<option value="${val.id}">${val.sku} - ${val.descLarga}</option>`;
		});
		$("#selectProductosAjustes").html(productos);

		$('#selectProductosAjustes').select2({
			placeholder: "Buscar productos...",
            minimumInputLength: 3,
            language: {

                noResults: function() {
            
                  return "No hay resultados";        
                },
                searching: function() {
            
                  return "Buscando..";
                },
                formatInputTooShort: function(){
                    return "Porfavor ingrese mas de 3 caracteres..";
                },
                inputTooShort: function() {
                    return 'Porfavor ingrese 3 o mas caracteres..';
                }
              },
            formatInputTooShort:"Porfavor ingrese 3 o mas caracteres.."
		});
	}, "json",);
}

$("#selectProductosAjustes").on("change", function () {
   getDatosProducto($("#selectProductosAjustes").val());
});


function agregarProductoAjuste(idProducto,cant){
    console.log(idProducto);

    $("#loader").show();
    params = {
		service: "agregarProductoAjuste",
		dbName: dbName,
		idUsuarios: localStorage.idUsuarios,
        idAjuste: sessionStorage.idAjuste,
        idEstado: sessionStorage.idEstadoAjuste,
        idProducto: idProducto,
        cantidad: cant
	};
	$.post(host, params, function (data) {
			console.log(data);
            sessionStorage.idEstadoAjuste = data.idEstado;
		},
		"json",
	).done(function () {
        $("#loader").hide();
        window.location = "registroEntradas.html";
        
        
	});
}

function getSucursalesBodegas(){
    params = {
		service: "getBodySuc",
		dbName: dbName,
		idEmpresas: localStorage.idEmpresas
	};
	$.post(host, params, function (data) {
			console.log(data);
            let bodegaSucursal = "";
            $.each(data, function (key, val) {
                bodegaSucursal += `<option value="${val.id}_${val.tipo}">${val.descripcion}</option>`;
            });
            $("#selectBodegaSucursal").html(bodegaSucursal);
            $('#selectBodegaSucursal').select2();

		},
		"json",
	).done(function () {
	});
}


function finalizarAjuste(){
    params = {
		service: "movimientoInventario",
		dbName: dbName,
        idAjuste: sessionStorage.idAjuste,
        idUsuarios: localStorage.idUsuarios,
		idEmpresas: localStorage.idEmpresas
	};
	$.post(host, params, function (data) {
			console.log(data);
            switch (data.message) {
                
                case "success":
                    Swal.fire({
                        icon: 'success', text: "Ajuste realizado"
                    }).then(function () {
                        window.location = "ajustes.html";
                    });
                    
                    break;
                case "error":
                    alert("Error al realizar el ajuste");
                    break;
                default:
                    alert(`Error`);
                    break;
            }

            $.each(data, function (key, val) {
            });
		},
		"json",
	).done(function () {
	});
}


function iniciarAjuste(){
    $("#loader").show();

    let v1 = $("#selectBodegaSucursal").val();
    let v1arr = v1.split("_");

    let tipo = v1arr[1];
    let idPunto = v1arr[0];
    let idTipoAjuste = $("input[name=tipoAjuste]:checked").attr("value");
    let descripcion = $("#descAjuste").val();
    let noFactura = $("#facturaAjuste").val();
    
    console.log(idTipoAjuste);

    if(idTipoAjuste === undefined || idTipoAjuste == "undefined" ){
        Swal.fire({
            icon: 'error',
            text: 'Ingrese un tipo de ajuste',
            showCloseButton: true,
            confirmButtonText: 'Intentar de nuevo',
        });
        $("#loader").hide();
    }else{
        params = {
            service: "iniciarAjuste",
            dbName: dbName,
            idUsuarios: localStorage.idUsuarios,
            idEmpresas: localStorage.idEmpresas,
            tipo: tipo,
            idPunto: idPunto,
            idTipoAjuste: idTipoAjuste,
            descripcion: descripcion,
            noFactura: noFactura
        };
        console.log(params);
        $.post(host, params, function (data) {
            console.log(data);
            if (data.error){
                alert (data.message);
            }else{
                sessionStorage.idAjuste = data.idAjuste;
                sessionStorage.idEstadoAjuste = "11";
            }
        },
            "json",
        ).done(function () {
            $("#loader").hide();
            window.location = "registroEntradas.html";
        });  
    }
}

function modalTranslado(){
    $("#loader").show();
	Swal.fire({
		title: `Seleccione un usuario`,   
		html: `<div class="row">
			<div  class="col s12" style="padding-top: 15px;">
			    <select class="select2" id="selectUsuarios" style="border-top-width: 10px;font-size: small;border: 1px solid white;border-bottom-color: #545454;"></select>
			</div>
		</div>`,
		showConfirmButton: true,
		showCancelButton: true,
		confirmButtonColor: '#ff8f00',
		cancelButtonText: "Cancelar",
		confirmButtonText: "Continuar",
		onOpen() {
			getUsuarios();
		},
		customClass: {
			container: 'my-swal'
		}	
	}).then((result) => {
		if (result.isConfirmed) {
            transaldoAjuste($("#selectUsuarios").val());
            console.log("UPDATE USUARIOS");
		}		
	});
    
}

function drawAjustes(items){

    var detail = "";

    if (items === null) {
		detail += `
        <div class="row">
        <div class="col s12 center-align">
            El usuario no cuenta con ajustes creados o en proceso...
        </div>
      </div>`;
	} else {
		detail = `<ul id="detalleAjustes" class='mdl-list' style="padding: 0; margin: 0;">`;
        let estado = "";
		$.each(items, function (key, val) {
            if(val.idEstado == "11"){ // creado
                estado = "(Creado)";
            }else{
                estado = "(En Proceso)";
            }
			detail += `
            <div class="row" style="margin-bottom: 0px;">
            <div class="col s12 m10 offset-m1">
              <div class="card" style="background-color:white">
                <div class="card-content white-text">
                  <span class="card-title" style="color:black;"><div class="row" style="margin-bottom: 0px;"><div class="col s10 m11" style="margin-bottom: 0px;" onclick="editarAjuste(${val.id},${val.idEstado})">${val.id} - ${val.documento}, ${estado}</div><div class="col s2 m1" onclick="deleteAjuste(${val.id},'${val.documento}')"><i class="material-icons" style="">delete</i></div></div></span>
                  <p style="color:black" onclick="editarAjuste(${val.id},${val.idEstado})">${val.fecha} | ${val.nombre}  | ${val.noFactura}.  </br>
                  ${val.descripcion}
                  </p>
                </div>
              </div>
            </div>
          </div>`;

		});
        
        
	}

    $('#cardAjustes').empty();
	$("#cardAjustes").append(detail);
}

function cerrarModalAjuste() {
    $("#modalAjuste").modal("close");
}


function editarAjuste(idAjuste,idEstado){
    console.log(idEstado);


    if(idEstado == 11 || idEstado == 12 ){
        window.location = "ajustesForm.html";
        
    }else{
        console.log("ajustesDetalle");
    }

    console.log(idAjuste);
    sessionStorage.idAjuste = idAjuste;
    sessionStorage.idEstadoAjuste = idEstado;


}

function deleteAjuste(idAjuste,documento){
    console.log("idEstado");
    
    Swal.fire({
		title: "&iquestEliminar Ajuste?",
		text: `${idAjuste} - ${documento}`,
		icon: "warning",
		showCancelButton: true,
		confirmButtonColor: "#3085d6",
		cancelButtonColor: "#d33",
		confirmButtonText: "Si",
		cancelButtonText: "Cancelar",
	}).then((result) => {
		if (result.value) {
            $("#loader").show();
            params = {
                service: "deleteAjuste",
                idAjuste: idAjuste,
                dbName: dbName,
            };
            $.post(host, params, function (data) {
                console.log(data);
                $.each(data, function (key, val) {
                });
            },
                "json",
            ).done(function () {
                $("#loader").hide();
                cargarAjustes();
                
            });


        }
    });




    
}


function deleteAjusteDetalle(idDetalle,desc){
    console.log("idEstado");
    
    Swal.fire({
		title: "&iquestEliminar Ajuste?",
		text: `${desc}`,
		icon: "warning",
		showCancelButton: true,
		confirmButtonColor: "#3085d6",
		cancelButtonColor: "#d33",
		confirmButtonText: "Si",
		cancelButtonText: "Cancelar",
	}).then((result) => {
		if (result.value) {
            $("#loader").show();
            params = {
                service: "deleteProductoAjuste",
                idDetalle: idDetalle,
                dbName: dbName,
            };
            $.post(host, params, function (data) {
                console.log(data);
                $.each(data, function (key, val) {
                });
            },
                "json",
            ).done(function () {
                $("#loader").hide();
                cargarAjustesDetalle();
            });


        }
    });

}



function nuevoAjuste(){

    window.location = "ajustesForm.html";


}

function continuarAjuste(){
    window.location = "registroEntradas.html";
}


function returnCardAjustes(){
    window.location = "ajustes.html";
}

function returnAjustesForm(){

    window.location = "ajustesForm.html";
    //cambiar todos los input a readOnly

}